/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerInvoice;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.batch.TaxableRamificationNotificationStep;
import org.kuali.kfs.module.tem.businessobject.TravelAdvance;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.document.TaxableRamificationDocument;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.service.TaxableRamificationDocumentService;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.springframework.transaction.annotation.Transactional;

public class TaxableRamificationDocumentServiceImpl
implements TaxableRamificationDocumentService {
    public static Logger LOG = Logger.getLogger(TaxableRamificationDocumentServiceImpl.class);
    private DocumentService documentService;
    private ParameterService parameterService;
    private BusinessObjectService businessObjectService;
    private TravelDocumentService travelDocumentService;
    private AccountsReceivableModuleService accountsReceivableModuleService;

    @Override
    public List<TravelAdvance> getAllQualifiedOutstandingTravelAdvance() {
        Map invoiceOpenAmountMap;
        Set<String> arInvoiceDocNumbers;
        List<TravelAdvance> qualifiedOutstandingTravelAdvance = new ArrayList<TravelAdvance>();
        List<String> customerTypeCodes = this.getTravelerCustomerTypes();
        Integer customerInvoiceAge = this.getNotificationOnDays();
        Date lastTaxableRamificationNotificationDate = this.getLastTaxableRamificationNotificationDate();
        if (ObjectUtils.isNull((Object)lastTaxableRamificationNotificationDate)) {
            lastTaxableRamificationNotificationDate = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate();
        }
        if (ObjectUtils.isNotNull(arInvoiceDocNumbers = (invoiceOpenAmountMap = this.getAccountsReceivableModuleService().getCustomerInvoiceOpenAmount(customerTypeCodes, customerInvoiceAge, lastTaxableRamificationNotificationDate)).keySet()) && !arInvoiceDocNumbers.isEmpty()) {
            qualifiedOutstandingTravelAdvance = this.getTravelDocumentService().getOutstandingTravelAdvanceByInvoice(arInvoiceDocNumbers);
        }
        return qualifiedOutstandingTravelAdvance;
    }

    @Override
    @Transactional
    public void blanketApproveRamificationDocument(TaxableRamificationDocument taxRamificationDocument) {
        try {
            this.addAdHocRoutePersons(taxRamificationDocument);
            this.getDocumentService().blanketApproveDocument((Document)taxRamificationDocument, "", new ArrayList(taxRamificationDocument.getAdHocRoutePersons()));
        }
        catch (WorkflowException we) {
            LOG.error((Object)"Failed to blanket approve the given tax ramification document. ", (Throwable)we);
            throw new RuntimeException(we);
        }
    }

    @Override
    @Transactional
    public TaxableRamificationDocument createAndBlanketApproveRamificationDocument(TravelAdvance travelAdvance) {
        if (this.hasTaxableRamification(travelAdvance)) {
            throw new RuntimeException("There exists a tax ramification document created from the given travel advance. " + (Object)((Object)travelAdvance));
        }
        TaxableRamificationDocument taxRamificationDocument = this.createRamificationDocument(travelAdvance);
        if (ObjectUtils.isNotNull((Object)((Object)taxRamificationDocument))) {
            this.blanketApproveRamificationDocument(taxRamificationDocument);
        }
        return taxRamificationDocument;
    }

    @Override
    public boolean hasTaxableRamification(TravelAdvance travelAdvance) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("travelAdvanceDocumentNumber", travelAdvance.getDocumentNumber());
        int count = this.getBusinessObjectService().countMatching(TaxableRamificationDocument.class, fieldValues);
        return count > 0;
    }

    @Override
    public TaxableRamificationDocument createRamificationDocument(TravelAdvance travelAdvance) {
        try {
            TaxableRamificationDocument taxRamificationDocument = (TaxableRamificationDocument)this.getDocumentService().getNewDocument(TaxableRamificationDocument.class);
            this.populateTaxRamificationDocument(taxRamificationDocument, travelAdvance);
            return taxRamificationDocument;
        }
        catch (WorkflowException we) {
            LOG.error((Object)we);
            throw new RuntimeException(we);
        }
    }

    protected void addAdHocRoutePersons(TaxableRamificationDocument taxableRamificationDocument) {
        Set<String> adHocRecipientPrincipalIds = this.getFYIRecipientsPrincipalIds(taxableRamificationDocument);
        for (String principalId : adHocRecipientPrincipalIds) {
            this.getTravelDocumentService().addAdHocFYIRecipient((Document)taxableRamificationDocument, principalId);
        }
    }

    protected Set<String> getFYIRecipientsPrincipalIds(TaxableRamificationDocument taxRamificationDocument) {
        HashSet<String> adHocRecipients = new HashSet<String>();
        return adHocRecipients;
    }

    protected void populateTaxRamificationDocument(TaxableRamificationDocument taxRamificationDocument, TravelAdvance travelAdvance) {
        taxRamificationDocument.setArInvoiceDocNumber(travelAdvance.getArInvoiceDocNumber());
        taxRamificationDocument.setTravelAdvanceDocumentNumber(travelAdvance.getDocumentNumber());
        taxRamificationDocument.setTravelAdvance(travelAdvance);
        TravelAuthorizationDocument travelAuthorizationDocument = this.getTravelAuthorizationDocument(travelAdvance);
        String travelDocumentIdentifier = travelAuthorizationDocument.getTravelDocumentIdentifier();
        taxRamificationDocument.setTravelDocumentIdentifier(travelDocumentIdentifier);
        TravelerDetail travelerDetail = travelAuthorizationDocument.getTraveler();
        this.refreshTraverler(travelerDetail);
        taxRamificationDocument.setTravelerDetailId(travelerDetail.getId());
        taxRamificationDocument.setTravelerDetail(travelerDetail);
        AccountsReceivableCustomerInvoice customerInvoice = this.getOpenCustomerInvoice(travelAdvance);
        taxRamificationDocument.setOpenAmount(customerInvoice.getOpenAmount());
        taxRamificationDocument.setInvoiceAmount(customerInvoice.getTotalDollarAmount());
        taxRamificationDocument.setDueDate(customerInvoice.getInvoiceDueDate());
        String taxRamificationNotice = this.getNotificationText();
        taxRamificationDocument.setTaxableRamificationNotice(taxRamificationNotice);
        taxRamificationDocument.getDocumentHeader().setOrganizationDocumentNumber(String.valueOf(travelDocumentIdentifier));
        String travelerPrincipalName = StringUtils.upperCase((String)travelerDetail.getPrincipalName());
        String description = this.getNotificationSubject() + travelerPrincipalName;
        taxRamificationDocument.getDocumentHeader().setDocumentDescription(StringUtils.left((String)description, (int)KFSConstants.getMaxLengthOfDocumentDescription()));
    }

    protected void refreshTraverler(TravelerDetail travelerDetail) {
        if (ObjectUtils.isNull((Object)((Object)travelerDetail))) {
            return;
        }
        String principalName = travelerDetail.getPrincipalName();
        if (StringUtils.isNotBlank((String)principalName)) {
            return;
        }
        String principalId = travelerDetail.getPrincipalId();
        Person person = ((PersonService)SpringContext.getBean(PersonService.class)).getPerson(principalId);
        if (ObjectUtils.isNotNull((Object)person)) {
            travelerDetail.setPrincipalName(person.getPrincipalName());
        }
    }

    protected Date getLastTaxableRamificationNotificationDate() {
        return this.getTravelDocumentService().findLatestTaxableRamificationNotificationDate();
    }

    protected TravelAuthorizationDocument getTravelAuthorizationDocument(TravelAdvance travelAdvance) {
        String travelAuthorizationDocumentNumber = travelAdvance.getDocumentNumber();
        return (TravelAuthorizationDocument)this.getBusinessObjectService().findBySinglePrimaryKey(TravelAuthorizationDocument.class, (Object)travelAuthorizationDocumentNumber);
    }

    protected AccountsReceivableCustomerInvoice getOpenCustomerInvoice(TravelAdvance travelAdvance) {
        String customerInvoiceDocumentNumber = travelAdvance.getArInvoiceDocNumber();
        return this.getAccountsReceivableModuleService().getOpenCustomerInvoice(customerInvoiceDocumentNumber);
    }

    protected String getNotificationText() {
        return this.getParameterService().getParameterValueAsString(TaxableRamificationNotificationStep.class, "NOTIFICATION_TEXT");
    }

    protected String getNotificationSubject() {
        return "Notice for ";
    }

    protected List<String> getTravelerCustomerTypes() {
        return new ArrayList<String>(this.getParameterService().getParameterValuesAsString(TravelAuthorizationDocument.class, "CUSTOMER_TYPE_CODE"));
    }

    protected Integer getNotificationOnDays() {
        String daysAsString = this.getParameterService().getParameterValueAsString(TaxableRamificationNotificationStep.class, "NOTIFICATION_DAYS");
        if (!StringUtils.isNumeric((String)daysAsString)) {
            return TemConstants.DEFAULT_NOTIFICATION_DAYS;
        }
        return Integer.parseInt(daysAsString);
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public AccountsReceivableModuleService getAccountsReceivableModuleService() {
        return this.accountsReceivableModuleService;
    }

    public void setAccountsReceivableModuleService(AccountsReceivableModuleService accountsReceivableModuleService) {
        this.accountsReceivableModuleService = accountsReceivableModuleService;
    }

    public TravelDocumentService getTravelDocumentService() {
        return this.travelDocumentService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }
}

