/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.service.impl;

import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.OffsetDefinition;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coa.service.OffsetDefinitionService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerCreditMemo;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerInvoice;
import org.kuali.kfs.integration.ar.AccountsReceivableDocumentHeader;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleService;
import org.kuali.kfs.integration.ar.AccountsReceivableOrganizationOptions;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.dao.DocumentDao;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.businessobject.AccountingDocumentRelationship;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.PerDiemExpense;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLine;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLineTotalPercentage;
import org.kuali.kfs.module.tem.businessobject.TravelAdvance;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.businessobject.TripType;
import org.kuali.kfs.module.tem.document.TEMReimbursementDocument;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.document.service.AccountingDocumentRelationshipService;
import org.kuali.kfs.module.tem.document.service.TravelAuthorizationService;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.service.TravelReimbursementService;
import org.kuali.kfs.module.tem.pdf.Coversheet;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class TravelReimbursementServiceImpl
implements TravelReimbursementService {
    protected static Logger LOG = Logger.getLogger(TravelReimbursementServiceImpl.class);
    protected KualiRuleService kualiRuleService;
    protected BusinessObjectService businessObjectService;
    protected DataDictionaryService dataDictionaryService;
    protected ObjectCodeService objectCodeService;
    protected DocumentService documentService;
    protected ConfigurationService ConfigurationService;
    protected TravelDocumentService travelDocumentService;
    protected TravelAuthorizationService travelAuthorizationService;
    protected ParameterService parameterService;
    protected WorkflowDocumentService workflowDocumentService;
    protected PersonService personService;
    protected IdentityService identityService;
    protected DocumentDao documentDao;
    protected AccountingDocumentRelationshipService accountingDocumentRelationshipService;
    protected AccountsReceivableModuleService accountsReceivableModuleService;
    protected GeneralLedgerPendingEntryService generalLedgerPendingEntryService;
    protected OffsetDefinitionService offsetDefinitionService;
    protected OptionsService optionsService;
    protected NoteService noteService;
    protected List<PropertyChangeListener> propertyChangeListeners;

    @Override
    public List<TravelReimbursementDocument> findByTravelId(String travelDocumentIdentifier) throws WorkflowException {
        List<TravelReimbursementDocument> retval = this.travelDocumentService.findReimbursementDocuments(travelDocumentIdentifier);
        for (TravelReimbursementDocument reimbursement : retval) {
            this.addListenersTo(reimbursement);
        }
        return retval;
    }

    @Override
    public TravelReimbursementDocument find(String documentNumber) throws WorkflowException {
        TravelReimbursementDocument retval = (TravelReimbursementDocument)this.documentService.getByDocumentHeaderId(documentNumber);
        this.addListenersTo(retval);
        return retval;
    }

    @Override
    public void addListenersTo(TravelReimbursementDocument reimbursement) {
        if (reimbursement != null) {
            reimbursement.setPropertyChangeListeners(this.propertyChangeListeners);
        }
    }

    @Override
    public Coversheet generateCoversheetFor(TravelReimbursementDocument document) throws Exception {
        String docNumber = document.getDocumentNumber();
        String initiatorId = document.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
        String instructions = this.parameterService.getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "TRAVEL_COVERSHEET_INSTRUCTIONS");
        String mailTo = this.travelDocumentService.retrieveAddressFromLocationCode(document.getTravelPayment().getDocumentationLocationCode());
        String destination = document.getPrimaryDestination().getPrimaryDestinationName();
        String directory = this.ConfigurationService.getPropertyValueAsString("externalizable.help.url");
        Person initiator = this.personService.getPerson(initiatorId);
        TravelerDetail traveler = document.getTraveler();
        traveler.refreshReferenceObject("customer");
        Coversheet cover = new Coversheet();
        cover.setInstructions(instructions);
        cover.setMailTo(mailTo);
        cover.setTripId(document.getTravelDocumentIdentifier() + "");
        cover.setDate(new SimpleDateFormat("MM/dd/yyyy").format(document.getTripBegin()));
        cover.setInitiatorName(initiator.getFirstName() + " " + initiator.getLastName());
        cover.setInitiatorPrincipalName(initiator.getPrincipalName());
        cover.setInitiatorPhone(initiator.getPhoneNumber());
        cover.setInitiatorEmail(initiator.getEmailAddress());
        cover.setTravelerName(traveler.getFirstName() + " " + traveler.getLastName());
        Person person = this.personService.getPerson(traveler.getPrincipalId());
        cover.setTravelerPrincipalName(person != null ? person.getPrincipalName() : "");
        cover.setTravelerPhone(traveler.getPhoneNumber());
        cover.setTravelerEmail(traveler.getEmailAddress());
        cover.setDestination(destination);
        cover.setDocumentNumber(docNumber);
        boolean mileageReceiptRequired = false;
        boolean lodgingReceiptRequired = false;
        ArrayList<Map<String, String>> expenses = new ArrayList<Map<String, String>>();
        if (document.getActualExpenses() != null) {
            for (ActualExpense expense : document.getActualExpenses()) {
                HashMap<String, String> expenseMap = new HashMap<String, String>();
                expense.refreshReferenceObject("expenseTypeObjectCode");
                expenseMap.put("expenseType", expense.getExpenseTypeObjectCode().getExpenseType().getName());
                BigDecimal rate = expense.getCurrencyRate();
                KualiDecimal amount = expense.getExpenseAmount();
                expenseMap.put("amount", new KualiDecimal(amount.bigDecimalValue().multiply(rate)).toString());
                expenseMap.put("receipt", this.getFormattedReceiptRequired(expense.getExpenseTypeObjectCode().isReceiptRequired()));
                if (TemConstants.ExpenseTypeMetaCategory.LODGING.getCode().equals(expense.getExpenseType().getExpenseTypeMetaCategoryCode())) {
                    lodgingReceiptRequired |= expense.getExpenseTypeObjectCode().isReceiptRequired();
                } else if (TemConstants.ExpenseTypeMetaCategory.MILEAGE.getCode().equals(expense.getExpenseType().getExpenseTypeMetaCategoryCode())) {
                    mileageReceiptRequired |= expense.getExpenseTypeObjectCode().isReceiptRequired();
                }
                expenses.add(expenseMap);
            }
        }
        if (document.getPerDiemExpenses() != null && document.getPerDiemExpenses().size() > 0) {
            HashMap<String, String> mealsIncidentialsMap = new HashMap<String, String>();
            mealsIncidentialsMap.put("expenseType", "Meals & Incidentals");
            mealsIncidentialsMap.put("amount", document.getMealsAndIncidentalsGrandTotal().toString());
            mealsIncidentialsMap.put("receipt", "-");
            expenses.add(mealsIncidentialsMap);
            HashMap<String, String> lodgingMap = new HashMap<String, String>();
            lodgingMap.put("expenseType", "Lodging");
            lodgingMap.put("amount", document.getLodgingGrandTotal().toString());
            lodgingMap.put("receipt", this.getFormattedReceiptRequired(lodgingReceiptRequired));
            expenses.add(lodgingMap);
            HashMap<String, String> mileageMap = new HashMap<String, String>();
            mileageMap.put("expenseType", "Mileage");
            mileageMap.put("amount", document.getMilesGrandTotal().toString());
            mileageMap.put("receipt", this.getFormattedReceiptRequired(mileageReceiptRequired));
            expenses.add(mileageMap);
        }
        cover.setExpenses(expenses);
        return cover;
    }

    protected String getFormattedReceiptRequired(boolean receiptRequired) {
        return receiptRequired ? "Yes" : "No";
    }

    @Override
    public void addDateChangedNote(TravelReimbursementDocument travelReqDoc, TravelAuthorizationDocument taDoc) {
        block3: {
            Timestamp currentEnd;
            Timestamp startDateIn = taDoc.getTripBegin();
            Timestamp endDateIn = taDoc.getTripEnd();
            Timestamp currentStart = travelReqDoc.getTripBegin();
            if (!this.areDatesNull(startDateIn, currentStart, endDateIn, currentEnd = travelReqDoc.getTripEnd()).booleanValue() && this.haveDatesChanged(startDateIn, currentStart, endDateIn, currentEnd).booleanValue()) {
                try {
                    this.notifyDateChangedOn(travelReqDoc, startDateIn, endDateIn);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Could not add a note to reimbursement with document number: " + travelReqDoc.getDocumentHeader().getDocumentNumber()));
                    LOG.warn((Object)e.getMessage());
                    if (!LOG.isDebugEnabled()) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    protected Boolean areDatesNull(Date startDateIn, Date currentStart, Date endDateIn, Date currentEnd) {
        Boolean nullDates = new Boolean(false);
        if (startDateIn == null) {
            nullDates = true;
        } else if (currentStart == null) {
            nullDates = true;
        } else if (endDateIn == null) {
            nullDates = true;
        } else if (currentEnd == null) {
            nullDates = true;
        }
        return nullDates;
    }

    protected Boolean haveDatesChanged(Date startDateIn, Date currentStart, Date endDateIn, Date currentEnd) {
        Boolean diffDates = new Boolean(false);
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
        String origStartDateStr = formatter.format(startDateIn);
        String origEndDateStr = formatter.format(endDateIn);
        String currStartDateStr = formatter.format(currentStart);
        String currEndDateStr = formatter.format(currentEnd);
        if (!origStartDateStr.equals(currStartDateStr)) {
            diffDates = true;
        }
        if (!origEndDateStr.equals(currEndDateStr)) {
            diffDates = true;
        }
        return diffDates;
    }

    @Override
    public void notifyDateChangedOn(TravelReimbursementDocument reimbursement, Date start, Date end) throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
        String origStartDateStr = formatter.format(start);
        String origEndDateStr = formatter.format(end);
        String newStartDateStr = formatter.format(reimbursement.getTripBegin());
        String newEndDateStr = formatter.format(reimbursement.getTripEnd());
        String noteText = String.format("The trip begin/end dates have been changed from %s - %s to %s - %s by Travel Reimbursement Doc # %s", origStartDateStr, origEndDateStr, newStartDateStr, newEndDateStr, reimbursement.getDocumentNumber());
        Note noteToAdd = this.documentService.createNoteFromDocument((Document)reimbursement, noteText);
        Principal systemUser = this.getIdentityService().getPrincipalByPrincipalName("kfs");
        noteToAdd.setAuthorUniversalIdentifier(systemUser.getPrincipalId());
        reimbursement.addNote(noteToAdd);
        this.getNoteService().save(noteToAdd);
    }

    @Override
    public void processCustomerReimbursement(TravelReimbursementDocument reimbursement) throws WorkflowException {
        Map<AccountsReceivableCustomerInvoice, KualiDecimal> openInvoiceMap = this.getInvoicesOpenAmountMapFor(reimbursement.getTraveler().getCustomerNumber(), reimbursement.getTravelDocumentIdentifier());
        KualiDecimal invoicesTotal = KualiDecimal.ZERO;
        for (KualiDecimal invoiceAmount : openInvoiceMap.values()) {
            invoicesTotal = (KualiDecimal)invoicesTotal.add((AbstractKualiDecimal)invoiceAmount);
        }
        KualiDecimal reimbursableTotal = reimbursement.getReimbursableTotal();
        LOG.info((Object)String.format("Invoice Total $%f - Reimbursable Total $%f", invoicesTotal.bigDecimalValue(), reimbursableTotal.bigDecimalValue()));
        if (reimbursableTotal.isGreaterEqual((AbstractKualiDecimal)invoicesTotal)) {
            if (invoicesTotal.isNonZero()) {
                for (AccountsReceivableCustomerInvoice invoice : this.orderInvoices(openInvoiceMap.keySet())) {
                    this.spawnCustomerCreditMemoDocument(reimbursement, invoice, openInvoiceMap.get(invoice));
                }
            }
            reimbursement.setReimbursableAmount((KualiDecimal)reimbursableTotal.subtract((AbstractKualiDecimal)invoicesTotal));
        } else {
            for (AccountsReceivableCustomerInvoice invoice : this.orderInvoices(openInvoiceMap.keySet())) {
                KualiDecimal invoiceAmount = openInvoiceMap.get(invoice);
                if (invoiceAmount.isGreaterEqual((AbstractKualiDecimal)reimbursableTotal)) {
                    this.spawnCustomerCreditMemoDocument(reimbursement, invoice, reimbursableTotal);
                    break;
                }
                this.spawnCustomerCreditMemoDocument(reimbursement, invoice, invoiceAmount);
                reimbursableTotal = (KualiDecimal)reimbursableTotal.subtract((AbstractKualiDecimal)invoiceAmount);
            }
        }
    }

    protected List<AccountsReceivableCustomerInvoice> orderInvoices(Set<AccountsReceivableCustomerInvoice> invoices) {
        ArrayList<AccountsReceivableCustomerInvoice> orderedInvoices = new ArrayList<AccountsReceivableCustomerInvoice>();
        orderedInvoices.addAll(invoices);
        Collections.sort(orderedInvoices, this.getCustomerInvoiceComparator());
        return orderedInvoices;
    }

    @Override
    public KualiDecimal getReimbursableToTraveler(TEMReimbursementDocument reimbursementDocument) {
        KualiDecimal invoicesTotal = this.getInvoiceAmount(reimbursementDocument);
        KualiDecimal reimbursableToTraveler = (KualiDecimal)reimbursementDocument.getReimbursableTotal().subtract((AbstractKualiDecimal)invoicesTotal);
        return reimbursableToTraveler;
    }

    @Override
    public KualiDecimal getInvoiceAmount(TEMReimbursementDocument reimbursementDocument) {
        KualiDecimal invoicesTotal = KualiDecimal.ZERO;
        if (!ObjectUtils.isNull((Object)((Object)reimbursementDocument.getTraveler())) && !StringUtils.isBlank((String)reimbursementDocument.getTravelDocumentIdentifier())) {
            Map<AccountsReceivableCustomerInvoice, KualiDecimal> openInvoiceMap = this.getInvoicesOpenAmountMapFor(reimbursementDocument.getTraveler().getCustomerNumber(), reimbursementDocument.getTravelDocumentIdentifier());
            for (KualiDecimal invoiceAmount : openInvoiceMap.values()) {
                invoicesTotal = (KualiDecimal)invoicesTotal.add((AbstractKualiDecimal)invoiceAmount);
            }
        }
        return invoicesTotal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void spawnCustomerCreditMemoDocument(TravelReimbursementDocument reimbursement, AccountsReceivableCustomerInvoice invoice, KualiDecimal creditAmount) throws WorkflowException {
        AccountsReceivableCustomerCreditMemo customerCreditMemo = this.createCustomerCreditMemo(reimbursement, invoice, creditAmount);
        String blanketApproveAnnotation = String.format("Blanket Approved CRM Doc # %s by system TR Document: %s TEM Doc # %s", customerCreditMemo.getDocumentNumber(), reimbursement.getDocumentNumber(), reimbursement.getTravelDocumentIdentifier());
        LOG.info((Object)blanketApproveAnnotation);
        UserSession originalUser = GlobalVariables.getUserSession();
        WorkflowDocument originalWorkflowDocument = customerCreditMemo.getFinancialSystemDocumentHeader().getWorkflowDocument();
        try {
            GlobalVariables.setUserSession((UserSession)new UserSession("kfs"));
            WorkflowDocument newWorkflowDocument = this.workflowDocumentService.loadWorkflowDocument(customerCreditMemo.getDocumentNumber(), GlobalVariables.getUserSession().getPerson());
            newWorkflowDocument.setTitle(originalWorkflowDocument.getTitle());
            customerCreditMemo.getFinancialSystemDocumentHeader().setWorkflowDocument(newWorkflowDocument);
            this.accountsReceivableModuleService.blanketApproveCustomerCreditMemoDocument(customerCreditMemo, blanketApproveAnnotation);
            String noteText = String.format("Customer Credit Memo Document %s was system generated.", customerCreditMemo.getDocumentNumber());
            Note noteToAdd = this.documentService.createNoteFromDocument((Document)reimbursement, noteText);
            reimbursement.addNote(noteToAdd);
            this.getNoteService().save(noteToAdd);
        }
        catch (Exception ex) {
            LOG.error((Object)("Encountered error on the CRM document with travelDocumentIdentifier " + reimbursement.getTravelDocumentIdentifier()), (Throwable)ex);
        }
        finally {
            GlobalVariables.setUserSession((UserSession)originalUser);
            customerCreditMemo.getFinancialSystemDocumentHeader().setWorkflowDocument(originalWorkflowDocument);
        }
        String relationDescription = "TR - Customer Credit Memo";
        this.accountingDocumentRelationshipService.save(new AccountingDocumentRelationship(reimbursement.getDocumentNumber(), customerCreditMemo.getDocumentNumber(), relationDescription));
    }

    protected AccountsReceivableCustomerCreditMemo createCustomerCreditMemo(TravelReimbursementDocument reimbursement, AccountsReceivableCustomerInvoice invoice, KualiDecimal creditAmount) throws WorkflowException {
        AccountsReceivableCustomerCreditMemo arCreditMemoDoc = this.accountsReceivableModuleService.createCustomerCreditMemoDocument();
        arCreditMemoDoc.setAccountsReceivableDocumentHeader(this.createAccountsReceivableDocumentHeader(arCreditMemoDoc.getDocumentNumber(), reimbursement.getTraveler().getCustomerNumber()));
        int documentDescriptionMaxLength = this.dataDictionaryService.getAttributeMaxLength(arCreditMemoDoc.getFinancialSystemDocumentHeader().getClass(), "documentDescription");
        String documentDescription = "Travel Advance - " + reimbursement.getTravelDocumentIdentifier() + " - " + reimbursement.getTraveler().getFirstName() + " " + reimbursement.getTraveler().getLastName();
        if (documentDescription.length() > documentDescriptionMaxLength) {
            documentDescription = documentDescription.substring(0, documentDescriptionMaxLength - 1);
        }
        arCreditMemoDoc.getFinancialSystemDocumentHeader().setDocumentDescription(documentDescription);
        arCreditMemoDoc.getFinancialSystemDocumentHeader().setOrganizationDocumentNumber(reimbursement.getTravelDocumentIdentifier());
        this.accountsReceivableModuleService.populateCustomerCreditMemoDocumentDetails(arCreditMemoDoc, invoice.getDocumentNumber(), creditAmount);
        reimbursement.setTravelAdvanceAmount(creditAmount);
        return arCreditMemoDoc;
    }

    @Override
    public TravelAuthorizationDocument getRelatedOpenTravelAuthorizationDocument(TravelReimbursementDocument reimbursement) {
        TravelAuthorizationDocument travelAuthorizationDocument = null;
        List<Document> travelAuthDocs = this.travelDocumentService.getDocumentsRelatedTo(reimbursement, "TA", "TAA");
        for (Document document : travelAuthDocs) {
            TravelAuthorizationDocument travelDocument = (TravelAuthorizationDocument)document;
            if (!this.travelDocumentService.isTravelAuthorizationOpened(travelDocument)) continue;
            travelAuthorizationDocument = travelDocument;
            break;
        }
        return travelAuthorizationDocument;
    }

    public AccountsReceivableDocumentHeader createAccountsReceivableDocumentHeader(String documentNumber, String customerNumber) {
        AccountsReceivableOrganizationOptions orgOptions = this.travelDocumentService.getOrgOptions();
        String processingChart = orgOptions.getProcessingChartOfAccountCode();
        String processingOrg = orgOptions.getProcessingOrganizationCode();
        AccountsReceivableDocumentHeader arDocHeader = this.accountsReceivableModuleService.getNewAccountsReceivableDocumentHeader(processingChart, processingOrg);
        arDocHeader.setDocumentNumber(documentNumber);
        arDocHeader.setCustomerNumber(customerNumber);
        return arDocHeader;
    }

    protected Map<AccountsReceivableCustomerInvoice, KualiDecimal> getInvoicesOpenAmountMapFor(String customerNumber, String travelDocId) {
        Collection invoices = this.accountsReceivableModuleService.getOpenInvoiceDocumentsByCustomerNumberForTrip(customerNumber, travelDocId);
        HashMap<AccountsReceivableCustomerInvoice, KualiDecimal> invoiceOpenAmountMap = new HashMap<AccountsReceivableCustomerInvoice, KualiDecimal>();
        LOG.debug((Object)("Invoices for customer " + customerNumber + " " + invoices));
        for (AccountsReceivableCustomerInvoice invoice : invoices) {
            KualiDecimal openAmountForCustomerInvoiceDocument = this.accountsReceivableModuleService.getOpenAmountForCustomerInvoiceDocument(invoice);
            invoiceOpenAmountMap.put(invoice, openAmountForCustomerInvoiceDocument);
        }
        return invoiceOpenAmountMap;
    }

    @Override
    public void enableDuplicateExpenses(TravelReimbursementDocument trDocument, ActualExpense actualExpense) {
        if (actualExpense == null) {
            for (String key : trDocument.getDisabledProperties().keySet()) {
                if (key.indexOf("perDiemExpenses") == 0) continue;
                trDocument.getDisabledProperties().remove(key);
            }
        } else {
            boolean canRemove;
            boolean bl = canRemove = !this.expenseStillExists(trDocument.getActualExpenses(), actualExpense);
            if (actualExpense.getExpenseTypeObjectCode().getExpenseTypeCode().equals("A") && canRemove) {
                trDocument.getDisabledProperties().remove("document.airfare");
            } else {
                int i = 0;
                for (PerDiemExpense perDiem : trDocument.getPerDiemExpenses()) {
                    String mileageDate = new SimpleDateFormat("MM/dd/yyyy").format(perDiem.getMileageDate());
                    if (actualExpense.getExpenseDate() == null) {
                        return;
                    }
                    String expenseDate = new SimpleDateFormat("MM/dd/yyyy").format(actualExpense.getExpenseDate());
                    LOG.debug((Object)("Comparing " + mileageDate + " to " + expenseDate));
                    if (mileageDate.equals(expenseDate)) {
                        String temp = "";
                        if (actualExpense.getExpenseTypeObjectCode().getExpenseTypeCode().equals("HB") && canRemove) {
                            temp = String.format("document.perDiemExpenses[%d].%s", i, "breakfast");
                            trDocument.getDisabledProperties().remove(temp);
                        } else if (actualExpense.getExpenseTypeObjectCode().getExpenseTypeCode().equals("HL") && canRemove) {
                            temp = String.format("document.perDiemExpenses[%d].%s", i, "lunch");
                            trDocument.getDisabledProperties().remove(temp);
                        } else if (actualExpense.getExpenseTypeObjectCode().getExpenseTypeCode().equals("HD") && canRemove) {
                            temp = String.format("document.perDiemExpenses[%d].%s", i, "dinner");
                            trDocument.getDisabledProperties().remove(temp);
                        } else if (actualExpense.getExpenseTypeObjectCode().getExpenseTypeCode().equals("L") && canRemove) {
                            temp = String.format("document.perDiemExpenses[%d].%s", i, "LODGING".toLowerCase());
                            trDocument.getDisabledProperties().remove(temp);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private boolean expenseStillExists(List<ActualExpense> actualExpenses, ActualExpense actualExpense) {
        boolean success = false;
        for (ActualExpense temp : actualExpenses) {
            if (temp.equals(actualExpense) || !temp.getExpenseTypeObjectCode().getExpenseTypeCode().equals(actualExpense.getExpenseTypeObjectCode().getExpenseTypeCode())) continue;
            success = true;
        }
        return success;
    }

    @Override
    public void generateEntriesForAdvances(TravelReimbursementDocument trDocument, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        Map<AccountsReceivableCustomerInvoice, KualiDecimal> openInvoiceMap = this.getInvoicesOpenAmountMapFor(trDocument.getTraveler().getCustomerNumber(), trDocument.getTravelDocumentIdentifier());
        KualiDecimal remainingReimbursableTotal = trDocument.getReimbursableTotal();
        for (AccountsReceivableCustomerInvoice invoice : this.orderInvoices(openInvoiceMap.keySet())) {
            TravelAdvance advance;
            KualiDecimal invoicePayment = this.rollReimbursementForInvoiceAmount(invoice, remainingReimbursableTotal);
            if (invoicePayment.isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO) && (advance = this.getAdvanceForInvoice(invoice)) != null) {
                this.generatePendingEntriesForAdvanceClearing(trDocument, invoicePayment, sequenceHelper);
                this.generatePendingEntriesForAdvanceCrediting(trDocument, advance, invoicePayment, sequenceHelper);
            }
            remainingReimbursableTotal = (KualiDecimal)remainingReimbursableTotal.subtract((AbstractKualiDecimal)invoicePayment);
        }
    }

    protected KualiDecimal rollReimbursementForInvoiceAmount(AccountsReceivableCustomerInvoice invoice, KualiDecimal remainingReimbursementAmount) {
        if (invoice.getOpenAmount().isLessEqual((AbstractKualiDecimal)remainingReimbursementAmount)) {
            return invoice.getOpenAmount();
        }
        return remainingReimbursementAmount;
    }

    protected TravelAdvance getAdvanceForInvoice(AccountsReceivableCustomerInvoice invoice) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("arInvoiceDocNumber", invoice.getDocumentNumber());
        Collection advances = this.businessObjectService.findMatching(TravelAdvance.class, fieldValues);
        if (advances == null || advances.isEmpty()) {
            return null;
        }
        if (advances.size() > 1) {
            throw new RuntimeException("Attempted to find advance for AR invoice identified by: " + invoice.getDocumentNumber() + " but multiple advances returned.  That condition should not exist in the system and the advances should be cleaned up.");
        }
        TravelAdvance advance = null;
        Iterator iterator = advances.iterator();
        while (iterator.hasNext()) {
            TravelAdvance adv;
            advance = adv = (TravelAdvance)((Object)iterator.next());
        }
        return advance;
    }

    protected void generatePendingEntriesForAdvanceClearing(TravelReimbursementDocument reimbursement, KualiDecimal paymentAmount, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        List<TemSourceAccountingLine> expenseAccountingLines = this.travelDocumentService.smooshAccountingLinesToSubAccount(reimbursement.getSourceAccountingLines());
        if (!ObjectUtils.isNull(expenseAccountingLines) && !expenseAccountingLines.isEmpty()) {
            List<TemSourceAccountingLineTotalPercentage> expenseAccountingLinesTotalPercentages = this.getPercentagesForLines(expenseAccountingLines);
            List<TemSourceAccountingLine> clearingLines = this.createAccountingLinesFromPercentages(expenseAccountingLinesTotalPercentages, paymentAmount, reimbursement.getDocumentNumber());
            this.takeAPennyLeaveAPenny(clearingLines, paymentAmount);
            for (TemSourceAccountingLine clearingLine : clearingLines) {
                OffsetDefinition offsetDefinition = this.getOffsetDefinitionForAdvanceClearing(reimbursement, clearingLine);
                clearingLine.setFinancialObjectCode(offsetDefinition.getFinancialObjectCode());
                clearingLine.setFinancialSubObjectCode(null);
                clearingLine.setFinancialDocumentLineTypeCode("B");
                reimbursement.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)clearingLine, sequenceHelper);
                sequenceHelper.increment();
            }
        }
    }

    protected void generatePendingEntriesForAdvanceCrediting(TravelReimbursementDocument reimbursement, TravelAdvance advance, KualiDecimal paymentAmount, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        List<TemSourceAccountingLine> advanceAccountingLines = this.travelDocumentService.smooshAccountingLinesToSubAccount(this.getAccountingLinesForAdvance(advance));
        if (!ObjectUtils.isNull(advanceAccountingLines) && !advanceAccountingLines.isEmpty()) {
            List<TemSourceAccountingLineTotalPercentage> advanceAccountingLineTotalPercentages = this.getPercentagesForLines(advanceAccountingLines);
            List<TemSourceAccountingLine> creditLines = this.createAccountingLinesFromPercentages(advanceAccountingLineTotalPercentages, paymentAmount, reimbursement.getDocumentNumber());
            this.takeAPennyLeaveAPenny(creditLines, paymentAmount);
            for (TemSourceAccountingLine creditLine : creditLines) {
                creditLine.setFinancialDocumentLineTypeCode("C");
                creditLine.setFinancialObjectCode(this.parameterService.getParameterValueAsString(TravelAuthorizationDocument.class, "TRAVEL_ADVANCE_OBJECT_CODE", ""));
                reimbursement.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySourceDetail)creditLine, sequenceHelper);
                sequenceHelper.increment();
            }
        }
    }

    protected List<TemSourceAccountingLine> getAccountingLinesForAdvance(TravelAdvance advance) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("documentNumber", advance.getDocumentNumber());
        fieldValues.put("financialDocumentLineTypeCode", "A");
        ArrayList<TemSourceAccountingLine> advanceAccountingLines = new ArrayList<TemSourceAccountingLine>();
        advanceAccountingLines.addAll(this.businessObjectService.findMatchingOrderBy(TemSourceAccountingLine.class, fieldValues, "sequenceNumber", true));
        return advanceAccountingLines;
    }

    @Override
    public List<TemSourceAccountingLineTotalPercentage> getPercentagesForLines(List<TemSourceAccountingLine> accountingLines) {
        BigDecimal total = this.calculateLinesTotal(accountingLines).bigDecimalValue();
        ArrayList<TemSourceAccountingLineTotalPercentage> linePercentages = new ArrayList<TemSourceAccountingLineTotalPercentage>();
        for (TemSourceAccountingLine accountingLine : accountingLines) {
            BigDecimal accountingLineAmount = accountingLine.getAmount().bigDecimalValue();
            BigDecimal percentage = accountingLineAmount.divide(total, this.getDistributionScale(accountingLineAmount, total), 4);
            TemSourceAccountingLineTotalPercentage linePercentage = new TemSourceAccountingLineTotalPercentage(accountingLine, percentage);
            linePercentages.add(linePercentage);
        }
        return linePercentages;
    }

    @Override
    public KualiDecimal calculateLinesTotal(List<TemSourceAccountingLine> accountingLines) {
        KualiDecimal sum = KualiDecimal.ZERO;
        for (TemSourceAccountingLine accountingLine : accountingLines) {
            sum = (KualiDecimal)sum.add((AbstractKualiDecimal)accountingLine.getAmount());
        }
        return sum;
    }

    protected int getDistributionScale(BigDecimal dividend, BigDecimal divisor) {
        return 5;
    }

    @Override
    public List<TemSourceAccountingLine> createAccountingLinesFromPercentages(List<TemSourceAccountingLineTotalPercentage> linePercentages, KualiDecimal paymentAmount, String documentNumber) {
        ArrayList<TemSourceAccountingLine> creditLines = new ArrayList<TemSourceAccountingLine>();
        for (TemSourceAccountingLineTotalPercentage linePercentage : linePercentages) {
            KualiDecimal amountForLine = new KualiDecimal(paymentAmount.bigDecimalValue().multiply(linePercentage.getPercentage()));
            TemSourceAccountingLine creditLine = this.createAccountingLineForClearing(linePercentage.getTemSourceAccountingLine(), amountForLine, documentNumber);
            creditLine.setSequenceNumber(creditLines.size() + 1);
            creditLines.add(creditLine);
        }
        return creditLines;
    }

    protected TemSourceAccountingLine createAccountingLineForClearing(TemSourceAccountingLine progenitorLine, KualiDecimal amountForLine, String documentNumber) {
        TemSourceAccountingLine copiedLine = new TemSourceAccountingLine();
        copiedLine.copyFrom((AccountingLine)progenitorLine);
        copiedLine.setAmount(amountForLine);
        copiedLine.setDocumentNumber(documentNumber);
        return copiedLine;
    }

    protected void takeAPennyLeaveAPenny(List<TemSourceAccountingLine> generatedLines, KualiDecimal paymentAmount) {
        KualiDecimal linesTotal = this.calculateLinesTotal(generatedLines);
        if (linesTotal.isLessThan((AbstractKualiDecimal)paymentAmount)) {
            KualiDecimal delta = (KualiDecimal)paymentAmount.subtract((AbstractKualiDecimal)linesTotal);
            KualiDecimal updatedAmount = (KualiDecimal)generatedLines.get(0).getAmount().add((AbstractKualiDecimal)delta);
            generatedLines.get(0).setAmount(updatedAmount);
        } else if (linesTotal.isGreaterThan((AbstractKualiDecimal)paymentAmount)) {
            KualiDecimal delta = (KualiDecimal)linesTotal.subtract((AbstractKualiDecimal)paymentAmount);
            KualiDecimal updatedAmount = (KualiDecimal)generatedLines.get(0).getAmount().subtract((AbstractKualiDecimal)delta);
            generatedLines.get(0).setAmount(updatedAmount);
        }
    }

    protected OffsetDefinition getOffsetDefinitionForAdvanceClearing(TravelReimbursementDocument reimbursement, TemSourceAccountingLine accountingLine) {
        String documentType = reimbursement.getPaymentDocumentType();
        Integer postingYear = reimbursement.getPostingYear();
        String chart = accountingLine.getChartOfAccountsCode();
        SystemOptions postingYearOptions = this.getOptionsService().getOptions(postingYear);
        String balanceType = postingYearOptions.getActualFinancialBalanceTypeCd();
        OffsetDefinition result = this.getOffsetDefinitionService().getByPrimaryId(postingYear, chart, documentType, balanceType);
        return result;
    }

    public void setPropertyChangeListeners(List<PropertyChangeListener> propertyChangeListeners) {
        this.propertyChangeListeners = propertyChangeListeners;
    }

    protected Comparator<AccountsReceivableCustomerInvoice> getCustomerInvoiceComparator() {
        return new Comparator<AccountsReceivableCustomerInvoice>(){

            @Override
            public int compare(AccountsReceivableCustomerInvoice blur, AccountsReceivableCustomerInvoice oasis) {
                return blur.getDocumentNumber().compareTo(oasis.getDocumentNumber());
            }
        };
    }

    @Override
    public boolean doAllReimbursementTripTypesRequireTravelAuthorization() {
        Collection tripTypes = this.businessObjectService.findAll(TripType.class);
        boolean requiresAuthorization = true;
        for (TripType tripType : tripTypes) {
            requiresAuthorization = tripType.getTravelAuthorizationRequired();
            if (requiresAuthorization) continue;
            return requiresAuthorization;
        }
        return requiresAuthorization;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setObjectCodeService(ObjectCodeService objectCodeService) {
        this.objectCodeService = objectCodeService;
    }

    public void setTravelAuthorizationService(TravelAuthorizationService travelAuthorizationService) {
        this.travelAuthorizationService = travelAuthorizationService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public void setRuleService(KualiRuleService kualiRuleService) {
        this.kualiRuleService = kualiRuleService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }

    public void setConfigurationService(ConfigurationService ConfigurationService2) {
        this.ConfigurationService = ConfigurationService2;
    }

    public void setDocumentDao(DocumentDao documentDao) {
        this.documentDao = documentDao;
    }

    public void setAccountingDocumentRelationshipService(AccountingDocumentRelationshipService accountingDocumentRelationshipService) {
        this.accountingDocumentRelationshipService = accountingDocumentRelationshipService;
    }

    public void setAccountsReceivableModuleService(AccountsReceivableModuleService accountsReceivableModuleService) {
        this.accountsReceivableModuleService = accountsReceivableModuleService;
    }

    public void setGeneralLedgerPendingEntryService(GeneralLedgerPendingEntryService generalLedgerPendingEntryService) {
        this.generalLedgerPendingEntryService = generalLedgerPendingEntryService;
    }

    public OffsetDefinitionService getOffsetDefinitionService() {
        return this.offsetDefinitionService;
    }

    public void setOffsetDefinitionService(OffsetDefinitionService offsetDefinitionService) {
        this.offsetDefinitionService = offsetDefinitionService;
    }

    public OptionsService getOptionsService() {
        return this.optionsService;
    }

    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }

    public NoteService getNoteService() {
        return this.noteService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }
}

