/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.util.Calendar;
import org.apache.commons.lang.time.DateUtils;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class ActualExpenseDatesValidation
extends GenericValidation {
    protected ActualExpense actualExpenseForValidation;
    protected DateTimeService dateTimeService;
    protected DataDictionaryService dataDictionaryService;

    public boolean validate(AttributedDocumentEvent event) {
        if (this.getActualExpenseForValidation().getExpenseDate() != null) {
            TravelDocument travelDocument = (TravelDocument)event.getDocument();
            Calendar messageDate = null;
            String messageProperty = null;
            Calendar expenseDate = Calendar.getInstance();
            expenseDate.setTimeInMillis(this.getActualExpenseForValidation().getExpenseDate().getTime());
            if (travelDocument.getTripEnd() != null) {
                Calendar tripEndDate = Calendar.getInstance();
                tripEndDate.setTimeInMillis(travelDocument.getTripEnd().getTime());
                if (DateUtils.truncatedCompareTo((Calendar)expenseDate, (Calendar)tripEndDate, (int)5) <= 0) {
                    return true;
                }
                messageDate = tripEndDate;
                messageProperty = this.getDataDictionaryService().getAttributeLabel(travelDocument.getClass(), "tripEnd");
            }
            if (travelDocument.getDocumentHeader().getWorkflowDocument().getDateCreated() != null) {
                Calendar initiationDate = Calendar.getInstance();
                initiationDate.setTimeInMillis(travelDocument.getDocumentHeader().getWorkflowDocument().getDateCreated().getMillis());
                if (DateUtils.truncatedCompareTo((Calendar)expenseDate, (Calendar)initiationDate, (int)5) > 0) {
                    if (messageDate == null) {
                        messageDate = initiationDate;
                        messageProperty = this.getDataDictionaryService().getAttributeLabel(travelDocument.getDocumentHeader().getWorkflowDocument().getClass(), "createDate");
                    }
                    GlobalVariables.getMessageMap().putError("expenseDate", "error.document.tem.actualexpense.expenseDate.earlyBird", new String[]{this.getDateTimeService().toDateString(expenseDate.getTime()), messageProperty, this.getDateTimeService().toDateString(messageDate.getTime())});
                    return false;
                }
            }
        }
        return true;
    }

    public ActualExpense getActualExpenseForValidation() {
        return this.actualExpenseForValidation;
    }

    public void setActualExpenseForValidation(ActualExpense actualExpenseForValidation) {
        this.actualExpenseForValidation = actualExpenseForValidation;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

