/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeObjectCode;
import org.kuali.kfs.module.tem.businessobject.ImportedExpense;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.service.TravelExpenseService;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class ImportedExpenseLineExpenseTypeValidation
extends GenericValidation {
    protected ImportedExpense importedExpenseForValidation;
    protected TravelExpenseService travelExpenseService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean success = true;
        return success &= this.checkExpenseTypeExistsForDocument(event.getDocument());
    }

    protected boolean checkExpenseTypeExistsForDocument(Document doc) {
        boolean success = true;
        TravelDocument travelDoc = (TravelDocument)doc;
        String documentTypeName = travelDoc.getDocumentTypeName();
        if (!StringUtils.isBlank((String)documentTypeName)) {
            String travelerType = ObjectUtils.isNull((Object)((Object)travelDoc.getTraveler())) ? null : travelDoc.getTraveler().getTravelerTypeCode();
            ExpenseTypeObjectCode expenseTypeObjectCode = this.getTravelExpenseService().getExpenseType(this.getImportedExpenseForValidation().getExpenseTypeCode(), documentTypeName, travelDoc.getTripTypeCode(), travelerType);
            if (expenseTypeObjectCode == null) {
                GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("newImportedExpenseLines", "error.document.tem.travel.import.expense.type.not.allowed", new String[]{this.getImportedExpenseForValidation().getExpenseTypeCode()});
                success = false;
            }
        }
        return success;
    }

    public ImportedExpense getImportedExpenseForValidation() {
        return this.importedExpenseForValidation;
    }

    public void setImportedExpenseForValidation(ImportedExpense importedExpenseForValidation) {
        this.importedExpenseForValidation = importedExpenseForValidation;
    }

    public TravelExpenseService getTravelExpenseService() {
        return this.travelExpenseService;
    }

    public void setTravelExpenseService(TravelExpenseService travelExpenseService) {
        this.travelExpenseService = travelExpenseService;
    }
}

