/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.PerDiemMealIncidentalBreakDown;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class PerDiemMealIncidentalBreakDownRule
extends MaintenanceDocumentRuleBase {
    private ParameterService parameterService;

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        boolean result = super.processCustomSaveDocumentBusinessRules(document);
        PerDiemMealIncidentalBreakDown perDiemMealIncidentalBreakDown = (PerDiemMealIncidentalBreakDown)document.getNewMaintainableObject().getBusinessObject();
        return result &= this.validateTotals(perDiemMealIncidentalBreakDown);
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean result = super.processCustomRouteDocumentBusinessRules(document);
        PerDiemMealIncidentalBreakDown perDiemMealIncidentalBreakDown = (PerDiemMealIncidentalBreakDown)document.getNewMaintainableObject().getBusinessObject();
        return result &= this.validateTotals(perDiemMealIncidentalBreakDown);
    }

    protected boolean validateTotals(PerDiemMealIncidentalBreakDown perDiemMealIncidentalBreakdown) {
        boolean valid = true;
        valid &= this.validateAmounts(perDiemMealIncidentalBreakdown);
        if (this.validateAmounts(perDiemMealIncidentalBreakdown)) {
            valid &= this.validateMealsAndIncidentalsTotals(perDiemMealIncidentalBreakdown);
        }
        return valid;
    }

    protected boolean validateAmounts(PerDiemMealIncidentalBreakDown perDiemMealIncidentalBreakdown) {
        boolean result = this.validateAmount(perDiemMealIncidentalBreakdown.getMealsAndIncidentals(), "mealsAndIncidentals");
        result &= this.validateAmount(perDiemMealIncidentalBreakdown.getBreakfast(), "breakfast");
        result &= this.validateAmount(perDiemMealIncidentalBreakdown.getLunch(), "lunch");
        result &= this.validateAmount(perDiemMealIncidentalBreakdown.getDinner(), "dinner");
        return result &= this.validateAmount(perDiemMealIncidentalBreakdown.getIncidentals(), "incidentals");
    }

    protected boolean validateAmount(KualiDecimal amount, String property) {
        if (ObjectUtils.isNull((Object)amount)) {
            return false;
        }
        if (amount.isNegative()) {
            this.putFieldError(property, "error.perdiem.mib.invalid.amountsMustBePositive");
            return false;
        }
        return true;
    }

    protected boolean validateMealsAndIncidentalsTotals(PerDiemMealIncidentalBreakDown perDiemMealIncidentalBreakdown) {
        KualiDecimal total = perDiemMealIncidentalBreakdown.getMealsAndIncidentals();
        KualiDecimal breakfast = perDiemMealIncidentalBreakdown.getBreakfast();
        KualiDecimal lunch = perDiemMealIncidentalBreakdown.getLunch();
        KualiDecimal dinner = perDiemMealIncidentalBreakdown.getDinner();
        KualiDecimal incidentals = perDiemMealIncidentalBreakdown.getIncidentals();
        KualiDecimal breakdown = (KualiDecimal)((KualiDecimal)((KualiDecimal)breakfast.add((AbstractKualiDecimal)lunch)).add((AbstractKualiDecimal)dinner)).add((AbstractKualiDecimal)incidentals);
        if (!total.equals((Object)breakdown)) {
            this.putFieldError("mealsAndIncidentals", "error.perdiem.mib.invalid.total.mealsAndIncidentals");
            return false;
        }
        return true;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

