/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.document.TravelDocumentBase;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class TravelAuthCustomerExistValidation
extends GenericValidation {
    public static Logger LOG = Logger.getLogger(TravelAuthCustomerExistValidation.class);
    protected ParameterService parameterService;

    public boolean validate(AttributedDocumentEvent event) {
        GlobalVariables.getMessageMap().clearErrorPath();
        GlobalVariables.getMessageMap().addToErrorPath("tripOverview");
        boolean rulePassed = true;
        TravelDocumentBase taDocument = (TravelDocumentBase)event.getDocument();
        LOG.debug((Object)("Looking up customer with number " + taDocument.getTraveler().getCustomerNumber()));
        taDocument.getTraveler().refreshReferenceObject("customer");
        LOG.debug((Object)("Got " + taDocument.getTraveler().getCustomer()));
        if (taDocument.getTraveler().getCustomer() == null && this.getParameterService().getParameterValuesAsString(TemParameterConstants.TEM_DOCUMENT.class, "NON_EMPLOYEE_TRAVELER_TYPE_CODES").contains(taDocument.getTraveler().getTravelerTypeCode())) {
            GlobalVariables.getMessageMap().putError("travelerTypeCode", "error.document.tem.arCustomerNotFound", new String[0]);
            rulePassed = false;
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("tripOverview");
        return rulePassed;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }
}

