/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.document.authorization.TransactionalDocumentAuthorizer;
import org.kuali.kfs.kns.document.authorization.TransactionalDocumentPresentationController;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.document.DocumentAuthorizer;
import org.kuali.kfs.krad.document.DocumentPresentationController;
import org.kuali.kfs.krad.service.DocumentDictionaryService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TemProfileAccount;
import org.kuali.kfs.module.tem.businessobject.TravelAdvance;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.service.TemProfileService;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedApproveDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedBlanketApproveDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedRouteDocumentEvent;
import org.kuali.kfs.sys.util.KfsDateUtils;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class TravelAuthTravelAdvanceValidation
extends GenericValidation {
    protected TemProfileService temProfileService;
    protected DocumentDictionaryService documentDictionaryService;
    protected TravelDocumentService travelDocumentService;
    protected ParameterService parameterService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean success = true;
        TravelAuthorizationDocument document = (TravelAuthorizationDocument)event.getDocument();
        if (document.getTraveler() == null) {
            GlobalVariables.getMessageMap().putError("travelerTypeCode", "error.document.tem.travel.advance.profile.missing", new String[0]);
            return false;
        }
        if ((event instanceof AttributedRouteDocumentEvent || event instanceof AttributedApproveDocumentEvent || event instanceof AttributedBlanketApproveDocumentEvent) && document.shouldProcessAdvanceForDocument()) {
            success = this.isTravelAdvanceValid(document, document.getTravelAdvance());
            success = success && this.validateAdvanceAmount((TravelDocument)event.getDocument());
        }
        return success;
    }

    private boolean isTravelAdvanceValid(TravelAuthorizationDocument document, TravelAdvance advance) {
        boolean testCards;
        boolean success = true;
        GlobalVariables.getMessageMap().addToErrorPath("document.travelAdvance.");
        if (advance.getTravelAdvanceRequested() != null) {
            KualiDecimal advReq = advance.getTravelAdvanceRequested();
            if (advReq.isLessEqual((AbstractKualiDecimal)KualiDecimal.ZERO)) {
                success = false;
            }
        } else {
            success = false;
        }
        if (!success) {
            GlobalVariables.getMessageMap().putError("travelAdvanceRequested", "error.document.tem.travelAdvRequestedGreaterThanZero", new String[0]);
        }
        if (this.canCurrentUserEditDocument(document)) {
            success = success && this.validateDueDate(advance, document.getTripEnd());
        }
        String travelerID = document.getTraveler().getPrincipalId();
        Boolean checkPolicy = Boolean.FALSE;
        checkPolicy = travelerID != null ? Boolean.valueOf(GlobalVariables.getUserSession().getPrincipalId().equals(travelerID)) : Boolean.TRUE;
        if (checkPolicy.booleanValue() && !advance.getTravelAdvancePolicy()) {
            success = false;
            GlobalVariables.getMessageMap().putError("travelAdvancePolicy", "error.document.tem.travel.advance.policy", new String[0]);
        }
        if (testCards = this.getParameterService().getParameterValueAsBoolean(TravelAuthorizationDocument.class, "CASH_ADVANCE_WARNING_IND").booleanValue()) {
            Collection cardTypes = this.getParameterService().getParameterValuesAsString(TravelAuthorizationDocument.class, "CASH_ADVANCE_CREDIT_CARD_TYPES");
            HashMap<String, String> cardTypeMap = new HashMap<String, String>();
            for (String cardType : cardTypes) {
                cardTypeMap.put(cardType.toUpperCase(), cardType.toUpperCase());
            }
            TemProfile temProfile = document.getTemProfile();
            if (temProfile == null && travelerID != null) {
                temProfile = this.temProfileService.findTemProfileByPrincipalId(travelerID);
            }
            if (temProfile != null && temProfile.getAccounts() != null && temProfile.getAccounts().size() > 0) {
                for (TemProfileAccount account : temProfile.getAccounts()) {
                    if (!cardTypeMap.containsKey(account.getName().toUpperCase()) || !StringUtils.isBlank((String)advance.getAdditionalJustification())) continue;
                    success = false;
                    GlobalVariables.getMessageMap().putError("additionalJustification", "error.document.tem.travel.advance.additional.justification", new String[0]);
                }
            }
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("document.travelAdvance.");
        return success;
    }

    protected boolean validateDueDate(TravelAdvance advance, Timestamp tripEnd) {
        boolean success = true;
        if (advance.getDueDate() != null) {
            Date dueDate = KfsDateUtils.clearTimeFields((Date)advance.getDueDate());
            java.util.Date today = KfsDateUtils.clearTimeFields((java.util.Date)new java.util.Date());
            if (dueDate != null && dueDate.before(today)) {
                GlobalVariables.getMessageMap().putError("dueDate", "error.custom", new String[]{"The Payment Due Date cannot be in the past."});
                success = false;
            }
        }
        if (advance.getDueDate() != null && tripEnd == null) {
            GlobalVariables.getMessageMap().putError("tripEnd", "error.document.tem.travel.trip.end.date.missing", new String[0]);
            success = false;
        } else if (advance.getDueDate() != null && advance.getDueDate().after(tripEnd)) {
            GlobalVariables.getMessageMap().putError("dueDate", "error.document.tem.travel.advance.due.date.invalid", new String[0]);
            success = false;
        }
        return success;
    }

    protected boolean validateAdvanceAmount(TravelDocument document) {
        boolean success = true;
        TravelAuthorizationDocument travelAuthorizationDocument = (TravelAuthorizationDocument)document;
        KualiDecimal totalAdvanceRequested = KualiDecimal.ZERO;
        GlobalVariables.getMessageMap().addToErrorPath("document.travelAdvance.");
        totalAdvanceRequested = (KualiDecimal)totalAdvanceRequested.add((AbstractKualiDecimal)travelAuthorizationDocument.getAdvanceTotal());
        List<TravelAdvance> advances = this.travelDocumentService.getTravelAdvancesForTrip(document.getTravelDocumentIdentifier());
        for (TravelAdvance advance : advances) {
            totalAdvanceRequested = (KualiDecimal)totalAdvanceRequested.add((AbstractKualiDecimal)advance.getTravelAdvanceRequested());
        }
        KualiDecimal totalTripAmount = travelAuthorizationDocument.getEncumbranceTotal();
        if (totalAdvanceRequested.isGreaterThan((AbstractKualiDecimal)totalTripAmount)) {
            GlobalVariables.getMessageMap().putError("travelAdvance", "error.document.tem.travel.advance.exceed.total.trip.amount", new String[0]);
            success = false;
        }
        return success;
    }

    protected boolean canCurrentUserEditDocument(TravelAuthorizationDocument doc) {
        String documentTypeName = this.getDocumentDictionaryService().getDocumentTypeByClass(doc.getClass());
        DocumentPresentationController presController = this.getDocumentDictionaryService().getDocumentPresentationController(documentTypeName);
        DocumentAuthorizer authorizer = this.getDocumentDictionaryService().getDocumentAuthorizer(documentTypeName);
        Set presControllerEditModes = ((TransactionalDocumentPresentationController)presController).getEditModes((Document)doc);
        Set editModes = ((TransactionalDocumentAuthorizer)authorizer).getEditModes((Document)doc, GlobalVariables.getUserSession().getPerson(), presControllerEditModes);
        return editModes.contains("fullEntry") && presController.canEdit((Document)doc) && authorizer.canEdit((Document)doc, GlobalVariables.getUserSession().getPerson());
    }

    public TemProfileService getTemProfileService() {
        return this.temProfileService;
    }

    public void setTemProfileService(TemProfileService temProfileService) {
        this.temProfileService = temProfileService;
    }

    public DocumentDictionaryService getDocumentDictionaryService() {
        return this.documentDictionaryService;
    }

    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

