/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.document.TravelDocumentBase;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.service.PostalCodeValidationService;

public class TravelAuthTravelerValidation
extends GenericValidation {
    protected PostalCodeValidationService postalCodeValidationService;

    public boolean validate(AttributedDocumentEvent event) {
        GlobalVariables.getMessageMap().clearErrorPath();
        GlobalVariables.getMessageMap().addToErrorPath("tripOverview");
        TravelDocumentBase doc = (TravelDocumentBase)event.getDocument();
        Timestamp beginDate = doc.getTripBegin();
        Timestamp endDate = doc.getTripEnd();
        TravelerDetail traveler = doc.getTraveler();
        GlobalVariables.getMessageMap().addToErrorPath("traveler");
        if (ObjectUtils.isNotNull((Object)((Object)traveler)) && ObjectUtils.isNotNull((Object)traveler.getTravelerTypeCode())) {
            if (traveler.getTravelerTypeCode().equals("EMP") && ObjectUtils.isNull((Object)traveler.getPrincipalId())) {
                GlobalVariables.getMessageMap().putError("document.traveler.principalId", "error.required", new String[]{"Principal Id"});
            }
            if (this.shouldValidateAddress(traveler.getCountryCode(), traveler.getStateCode())) {
                this.getPostalCodeValidationService().validateAddress(traveler.getCountryCode(), traveler.getStateCode(), traveler.getZipCode(), "stateCode", "zipCode");
            }
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("traveler");
        if (endDate != null && beginDate != null && ((Date)endDate).compareTo(beginDate) < 0) {
            GlobalVariables.getMessageMap().putError("tripBegin", "error.document.tem.endDateBeforeBegin", new String[0]);
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("tripOverview");
        int errCount = GlobalVariables.getMessageMap().getErrorCount();
        return errCount <= 0;
    }

    protected boolean shouldValidateAddress(String countryCode, String stateCode) {
        return StringUtils.equals((String)"US", (String)countryCode) || !StringUtils.isBlank((String)stateCode) && !stateCode.matches("^-+$");
    }

    public PostalCodeValidationService getPostalCodeValidationService() {
        return this.postalCodeValidationService;
    }

    public void setPostalCodeValidationService(PostalCodeValidationService postalCodeValidationService) {
        this.postalCodeValidationService = postalCodeValidationService;
    }
}

