/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.PerDiem;
import org.kuali.kfs.module.tem.businessobject.PerDiemExpense;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelDocumentBase;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.service.PerDiemService;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.util.KfsDateUtils;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class TravelAuthTripDetailMealsAndIncidentalsValidation
extends GenericValidation {
    protected TravelDocumentService travelDocumentService;
    protected ParameterService parameterService;
    protected PerDiemService perDiemService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean rulePassed = true;
        TravelDocumentBase document = (TravelDocumentBase)event.getDocument();
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        boolean checkDailyPerDiem = this.parameterService.getParameterValueAsBoolean(TemParameterConstants.TEM_DOCUMENT.class, "VALIDATE_DAILY_PER_DIEM_AND_INCIDENTALS_IND");
        int count = 0;
        for (PerDiemExpense estimate : document.getPerDiemExpenses()) {
            PerDiem estimatePerDiem;
            boolean prorated;
            boolean bl = prorated = !KfsDateUtils.isSameDay((Date)document.getTripBegin(), (Date)document.getTripEnd()) && (KfsDateUtils.isSameDay((Date)estimate.getMileageDate(), (Date)document.getTripBegin()) || KfsDateUtils.isSameDay((Date)estimate.getMileageDate(), (Date)document.getTripEnd()));
            if (prorated && !estimate.isProrated()) {
                estimate.setProrated(true);
            }
            Integer perDiemPercent = this.travelDocumentService.calculateProratePercentage(estimate, document.getTripType().getPerDiemCalcMethod(), document.getTripEnd());
            String expenseDate = sdf.format(estimate.getMileageDate());
            if (estimate != null && (estimatePerDiem = this.getPerDiemService().getPerDiem(estimate.getPrimaryDestinationId(), estimate.getMileageDate(), document.getEffectiveDateForPerDiem(estimate))) != null && perDiemPercent != null) {
                if (!checkDailyPerDiem) {
                    KualiDecimal defaultIncidentals;
                    KualiDecimal defaultDinner;
                    KualiDecimal defaultLunch;
                    KualiDecimal defaultBreakfast = PerDiemExpense.calculateMealsAndIncidentalsProrated(estimatePerDiem.getBreakfast(), perDiemPercent);
                    if (defaultBreakfast.isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO) && defaultBreakfast.isLessThan((AbstractKualiDecimal)estimate.getBreakfastValue())) {
                        GlobalVariables.getMessageMap().putError("document.perDiemExpenses[" + count + "]." + "unfilteredBreakfastValue", "error.document.tem.invalidMealsAndIncidentals", new String[]{"Breakfast - " + expenseDate, estimate.getBreakfastValue().toString(), defaultBreakfast.toString()});
                        rulePassed = false;
                    }
                    if ((defaultLunch = PerDiemExpense.calculateMealsAndIncidentalsProrated(estimatePerDiem.getLunch(), perDiemPercent)).isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO) && defaultLunch.isLessThan((AbstractKualiDecimal)estimate.getLunchValue())) {
                        GlobalVariables.getMessageMap().putError("document.perDiemExpenses[" + count + "]." + "unfilteredLunchValue", "error.document.tem.invalidMealsAndIncidentals", new String[]{"Lunch - " + expenseDate, estimate.getLunchValue().toString(), defaultLunch.toString()});
                        rulePassed = false;
                    }
                    if ((defaultDinner = PerDiemExpense.calculateMealsAndIncidentalsProrated(estimatePerDiem.getDinner(), perDiemPercent)).isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO) && defaultDinner.isLessThan((AbstractKualiDecimal)estimate.getDinnerValue())) {
                        GlobalVariables.getMessageMap().putError("document.perDiemExpenses[" + count + "]." + "unfilteredDinnerValue", "error.document.tem.invalidMealsAndIncidentals", new String[]{"Dinner - " + expenseDate, estimate.getDinnerValue().toString(), defaultDinner.toString()});
                        rulePassed = false;
                    }
                    if ((defaultIncidentals = PerDiemExpense.calculateMealsAndIncidentalsProrated(estimatePerDiem.getIncidentals(), perDiemPercent)).isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO) && defaultIncidentals.isLessThan((AbstractKualiDecimal)estimate.getIncidentalsValue())) {
                        GlobalVariables.getMessageMap().putError("document.perDiemExpenses[" + count + "]." + "unfilteredIncidentalsValue", "error.document.tem.invalidMealsAndIncidentals", new String[]{"Incidentals - " + expenseDate, estimate.getIncidentalsValue().toString(), defaultIncidentals.toString()});
                        rulePassed = false;
                    }
                } else {
                    KualiDecimal dailyPerDiem = PerDiemExpense.calculateMealsAndIncidentalsProrated(estimatePerDiem.getMealsAndIncidentals(), perDiemPercent);
                    if (dailyPerDiem.isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO) && dailyPerDiem.isLessThan((AbstractKualiDecimal)estimate.getMealsAndIncidentals())) {
                        GlobalVariables.getMessageMap().putError("document.perDiemExpenses", "error.document.tem.invalidMealsAndIncidentals", new String[]{"Daily PerDiem - " + expenseDate, estimate.getMealsAndIncidentals().toString(), dailyPerDiem.toString()});
                        rulePassed = false;
                        break;
                    }
                }
            }
            ++count;
        }
        if (StringUtils.isBlank((String)document.getMealWithoutLodgingReason()) && document.isMealsWithoutLodging()) {
            GlobalVariables.getMessageMap().putError("document.mealWithoutLodgingReason", "error.document.tem.travel.meals.no.loding.requires.justification", new String[0]);
            rulePassed = false;
        }
        return rulePassed;
    }

    protected boolean hasLodgingActualExpense(TravelDocument document) {
        for (ActualExpense expense : document.getActualExpenses()) {
            if (!expense.isLodging() && !expense.isLodgingAllowance()) continue;
            return true;
        }
        return false;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public PerDiemService getPerDiemService() {
        return this.perDiemService;
    }

    public void setPerDiemService(PerDiemService perDiemService) {
        this.perDiemService = perDiemService;
    }
}

