/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.ExpenseType;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeObjectCode;
import org.kuali.kfs.module.tem.businessobject.PerDiemExpense;
import org.kuali.kfs.module.tem.businessobject.TemExpense;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.validation.impl.TemDocumentExpenseLineValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.bo.BusinessObject;

public class TravelDocumentActualExpenseLineValidation
extends TemDocumentExpenseLineValidation {
    protected ActualExpense actualExpenseForValidation;
    protected boolean currentExpenseInCollection = true;

    public boolean validate(AttributedDocumentEvent event) {
        boolean success = true;
        TravelDocument document = (TravelDocument)event.getDocument();
        success = this.getDictionaryValidationService().isBusinessObjectValid((BusinessObject)this.getActualExpenseForValidation());
        if (success) {
            success = this.validateExpenses(this.getActualExpenseForValidation(), document);
        }
        return success;
    }

    public boolean validateExpenses(ActualExpense expense, TravelDocument document) {
        boolean success = this.validateGeneralRules(expense, document) && this.validateExpenseDetail(expense) && this.validateAirfareRules(expense, document) && this.validateRentalCarRules(expense, document) && this.validateLodgingRules(expense, document) && this.validateLodgingAllowanceRules(expense, document) && this.validatePerDiemRules(expense, document) && this.validateMaximumAmountRules(expense, document);
        return success;
    }

    public boolean validateGeneralRules(ActualExpense actualExpense, TravelDocument document) {
        boolean success = true;
        if (ObjectUtils.isNull((Object)actualExpense)) {
            return false;
        }
        ExpenseTypeObjectCode expenseTypeCode = actualExpense.getExpenseTypeObjectCode();
        if (!actualExpense.isMileage() && actualExpense.getExpenseAmount().isNegative()) {
            GlobalVariables.getMessageMap().putError("expenseAmount", "error.zeroOrNegativeAmount", new String[]{"Expense Amount"});
            success = false;
        }
        if (actualExpense.getCurrencyRate().compareTo(BigDecimal.ZERO) < 0) {
            GlobalVariables.getMessageMap().putError("currencyRate", "error.zeroOrNegativeAmount", new String[]{"Currency Rate"});
            success = false;
        }
        if (this.isDuplicateEntry(actualExpense, document)) {
            success = false;
            if (expenseTypeCode != null && expenseTypeCode.isPerDaily()) {
                GlobalVariables.getMessageMap().putError("expenseAmount", "error.document.tem.actualexpense.duplicateexpenseentrydaily", new String[]{actualExpense.getExpenseTypeCode()});
            } else {
                GlobalVariables.getMessageMap().putError("expenseAmount", "error.document.tem.actualexpense.duplicateexpenseentry", new String[]{actualExpense.getExpenseTypeCode(), actualExpense.getExpenseDate().toString()});
            }
        }
        return success;
    }

    public boolean validateExpenseDetail(ActualExpense actualExpense) {
        boolean success = true;
        actualExpense.refreshReferenceObject("expenseTypeObjectCode");
        ExpenseTypeObjectCode expenseType = actualExpense.getExpenseTypeObjectCode();
        if (ObjectUtils.isNotNull((Object)((Object)expenseType)) && expenseType.getExpenseType().isExpenseDetailRequired() && actualExpense.getExpenseDetails().isEmpty()) {
            if (this.isWarningOnly()) {
                GlobalVariables.getMessageMap().putWarning("detail", "error.document.tem.actualexpense.detail.required", new String[]{expenseType.getExpenseType().getName()});
            } else {
                GlobalVariables.getMessageMap().putError("detail", "error.document.tem.actualexpense.detail.required", new String[]{expenseType.getExpenseType().getName()});
                success = false;
            }
        }
        return success;
    }

    public boolean validateMaximumAmountRules(ActualExpense actualExpense, TravelDocument document) {
        boolean success = true;
        ExpenseTypeObjectCode expenseTypeObjectCode = actualExpense.getExpenseTypeObjectCode();
        KualiDecimal maxAmount = this.getMaximumAmount(actualExpense, document, expenseTypeObjectCode);
        if (maxAmount.isNonZero()) {
            if (expenseTypeObjectCode.isPerDaily()) {
                if (maxAmount.isLessThan((AbstractKualiDecimal)actualExpense.getConvertedAmount())) {
                    success = false;
                    GlobalVariables.getMessageMap().putError("expenseAmount", "error.document.tem.actualexpense.maxamountperpersondaily", new String[]{expenseTypeObjectCode.getMaximumAmount().toString()});
                }
            } else if (expenseTypeObjectCode.isPerOccurrence().booleanValue()) {
                KualiDecimal totalPerExpenseType = this.getTotalDocumentAmountForExpenseType(document, actualExpense.getExpenseType());
                if (!this.isCurrentExpenseInCollection()) {
                    totalPerExpenseType = (KualiDecimal)totalPerExpenseType.add((AbstractKualiDecimal)actualExpense.getConvertedAmount());
                }
                if (maxAmount.isLessThan((AbstractKualiDecimal)totalPerExpenseType)) {
                    success = false;
                    GlobalVariables.getMessageMap().putError("expenseAmount", "error.document.tem.actualexpense.maxamountperoccurrence", new String[]{expenseTypeObjectCode.getMaximumAmount().toString()});
                }
            }
        }
        return success;
    }

    protected KualiDecimal getTotalDocumentAmountForExpenseType(TravelDocument document, ExpenseType expenseType) {
        KualiDecimal total = (KualiDecimal)this.getTotalForExpenseType(document.getActualExpenses(), expenseType).add((AbstractKualiDecimal)this.getTotalForExpenseType(document.getImportedExpenses(), expenseType));
        return total;
    }

    protected KualiDecimal getTotalForExpenseType(List<? extends TemExpense> expenses, ExpenseType expenseType) {
        KualiDecimal total = KualiDecimal.ZERO;
        for (TemExpense temExpense : expenses) {
            if (!StringUtils.equals((String)temExpense.getExpenseTypeCode(), (String)expenseType.getCode())) continue;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)temExpense.getConvertedAmount());
        }
        return total;
    }

    public boolean validateLodgingRules(ActualExpense actualExpense, TravelDocument document) {
        boolean success = true;
        if (actualExpense.isLodging() && this.isLodgingAllowanceEntered(actualExpense, document)) {
            success = false;
            GlobalVariables.getMessageMap().putError("currencyRate", "error.document.tem.actualexpense.lodgingentered", new String[0]);
        }
        return success;
    }

    public boolean validateLodgingAllowanceRules(ActualExpense actualExpense, TravelDocument document) {
        boolean success = true;
        if (actualExpense.isLodgingAllowance()) {
            ExpenseTypeObjectCode expenseTypeCode = actualExpense.getExpenseTypeObjectCode();
            KualiDecimal maxAmount = ObjectUtils.isNotNull((Object)((Object)expenseTypeCode)) && ObjectUtils.isNotNull((Object)expenseTypeCode.getMaximumAmount()) ? expenseTypeCode.getMaximumAmount() : KualiDecimal.ZERO;
            GlobalVariables.getMessageMap().putInfo("description", "info.document.tem.actualexpense.lodgingallowance", new String[]{maxAmount.toString()});
            if (this.isLodgingEntered(actualExpense, document)) {
                success = false;
                GlobalVariables.getMessageMap().putError("expenseTypeCode", "error.document.tem.actualexpense.lodgingentered", new String[0]);
            }
            if (this.isPerDiemLodgingEntered(actualExpense.getExpenseDate(), document.getPerDiemExpenses())) {
                GlobalVariables.getMessageMap().putWarning("description", "warning.document.tem.perdiemexpense.lodgingentered", new String[0]);
            }
        }
        return success;
    }

    protected boolean isLodgingAllowanceEntered(ActualExpense ote, TravelDocument document) {
        for (ActualExpense actualExpense : document.getActualExpenses()) {
            if (!actualExpense.isLodgingAllowance() || ote.equals(actualExpense) || ote.getExpenseDate() == null || !ote.getExpenseDate().equals(actualExpense.getExpenseDate())) continue;
            return true;
        }
        for (PerDiemExpense perDiemExpense : document.getPerDiemExpenses()) {
            if (!KualiDecimal.ZERO.isLessThan((AbstractKualiDecimal)perDiemExpense.getLodging()) || ote.getExpenseDate() == null || !ote.getExpenseDate().equals(perDiemExpense.getMileageDate())) continue;
            return true;
        }
        return false;
    }

    protected boolean isLodgingEntered(ActualExpense ote, TravelDocument document) {
        for (ActualExpense actualExpense : document.getActualExpenses()) {
            if (!actualExpense.isLodging() || ote.equals(actualExpense) || ote.getExpenseDate() == null || !ote.getExpenseDate().equals(actualExpense.getExpenseDate())) continue;
            return true;
        }
        return false;
    }

    protected boolean isDuplicateEntry(ActualExpense expense, TravelDocument document) {
        if (document.shouldRefreshExpenseTypeObjectCode()) {
            expense.refreshExpenseTypeObjectCode(document.getDocumentTypeName(), document.getTraveler().getTravelerTypeCode(), document.getTripTypeCode());
        }
        ExpenseTypeObjectCode expenseTypeCode = expense.getExpenseTypeObjectCode();
        if (!document.getActualExpenses().contains(expense)) {
            for (ActualExpense actualExpense : document.getActualExpenses()) {
                if (expense.getExpenseDate() == null || !expense.getExpenseDate().equals(actualExpense.getExpenseDate()) || !actualExpense.getExpenseTypeCode().equals(expense.getExpenseTypeCode())) continue;
                return true;
            }
        }
        return false;
    }

    protected KualiDecimal getMaximumAmount(ActualExpense actualExpense, TravelDocument document, ExpenseTypeObjectCode expenseTypeObjectCode) {
        KualiDecimal maxAmount = KualiDecimal.ZERO;
        if (expenseTypeObjectCode != null && expenseTypeObjectCode.getMaximumAmount() != null) {
            maxAmount = expenseTypeObjectCode.getMaximumAmount();
        }
        if (actualExpense.getExpenseType().isGroupTravel()) {
            KualiDecimal groupTravelMultipier = new KualiDecimal(document.getGroupTravelers().size() + 1);
            maxAmount = (KualiDecimal)maxAmount.multiply((AbstractKualiDecimal)groupTravelMultipier);
        }
        return maxAmount;
    }

    protected KualiDecimal getTotalExpenseAmount(ActualExpense ote, TravelDocument document) {
        KualiDecimal totalExpenseAmount = KualiDecimal.ZERO;
        for (ActualExpense actualExpense : document.getActualExpenses()) {
            if (ote.equals(actualExpense) || !ote.getExpenseTypeCode().equals(actualExpense.getExpenseTypeCode())) continue;
            totalExpenseAmount = (KualiDecimal)totalExpenseAmount.add((AbstractKualiDecimal)actualExpense.getExpenseAmount());
        }
        return (KualiDecimal)totalExpenseAmount.add((AbstractKualiDecimal)ote.getExpenseAmount());
    }

    public ActualExpense getActualExpenseForValidation() {
        return this.actualExpenseForValidation;
    }

    public void setActualExpenseForValidation(ActualExpense actualExpenseForValidation) {
        this.actualExpenseForValidation = actualExpenseForValidation;
    }

    public boolean isCurrentExpenseInCollection() {
        return this.currentExpenseInCollection;
    }

    public void setCurrentExpenseInCollection(boolean currentExpenseInCollection) {
        this.currentExpenseInCollection = currentExpenseInCollection;
    }
}

