/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.document.TravelEntertainmentDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class TravelEntertainmentHostCertificationAttachmentValidation
extends GenericValidation {
    protected boolean warningOnly = true;

    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        GlobalVariables.getMessageMap().clearErrorPath();
        TravelEntertainmentDocument document = (TravelEntertainmentDocument)event.getDocument();
        boolean entertainmentHostAttached = false;
        List notes = document.getNotes();
        for (Note note : notes) {
            if (!ObjectUtils.isNotNull((Object)note.getAttachment()) || !"Entertainment Host Certification".equals(note.getAttachment().getAttachmentTypeCode())) continue;
            entertainmentHostAttached = true;
            break;
        }
        if (!document.getHostAsPayee().booleanValue() && !entertainmentHostAttached) {
            valid = this.addError();
        }
        return valid;
    }

    protected boolean addError() {
        boolean success = true;
        if (this.warningOnly) {
            GlobalVariables.getMessageMap().putWarning("document.document.hostName", "tem.entertainment.host.certification.required", new String[0]);
        } else {
            success = false;
            GlobalVariables.getMessageMap().putError("document.document.hostName", "tem.entertainment.host.certification.required", new String[0]);
            String matchingErrorPath = StringUtils.join((Collection)GlobalVariables.getMessageMap().getErrorPath(), (String)".") + "." + "document.hostName";
            GlobalVariables.getMessageMap().removeAllWarningMessagesForProperty(matchingErrorPath);
        }
        return success;
    }

    public boolean isWarningOnly() {
        return this.warningOnly;
    }

    public void setWarningOnly(boolean warningOnly) {
        this.warningOnly = warningOnly;
    }
}

