/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import java.util.Observable;
import java.util.Observer;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.validation.event.AddActualExpenseLineEvent;
import org.kuali.kfs.module.tem.document.web.bean.TravelMvcWrapperBean;
import org.kuali.kfs.module.tem.document.web.struts.AddActualExpenseDetailEvent;
import org.kuali.kfs.module.tem.service.AccountingDistributionService;
import org.kuali.kfs.module.tem.service.TravelExpenseService;
import org.kuali.kfs.sys.context.SpringContext;

public class AddActualExpenseEvent
implements Observer {
    public static Logger LOG = Logger.getLogger(AddActualExpenseDetailEvent.class);
    protected volatile TravelExpenseService travelExpenseService;

    @Override
    public void update(Observable arg0, Object arg1) {
        if (!(arg1 instanceof TravelMvcWrapperBean)) {
            return;
        }
        TravelMvcWrapperBean wrapper = (TravelMvcWrapperBean)arg1;
        TravelDocument document = wrapper.getTravelDocument();
        ActualExpense newActualExpenseLine = wrapper.getNewActualExpenseLine();
        if (newActualExpenseLine != null) {
            newActualExpenseLine.refreshReferenceObject("expenseTypeObjectCode");
        }
        boolean rulePassed = true;
        if (rulePassed &= this.getRuleService().applyRules(new AddActualExpenseLineEvent<ActualExpense>("newActualExpenseLine", (Document)document, newActualExpenseLine))) {
            if (newActualExpenseLine != null) {
                document.addExpense(newActualExpenseLine);
            }
            ActualExpense newExpense = this.getTravelExpenseService().createNewDetailForActualExpense(newActualExpenseLine);
            wrapper.setNewActualExpenseLine(new ActualExpense());
            wrapper.getNewActualExpenseLines().add(newExpense);
            wrapper.setDistribution(this.getAccountingDistributionService().buildDistributionFrom(document));
        }
    }

    protected TravelDocumentService getTravelDocumentService() {
        return (TravelDocumentService)SpringContext.getBean(TravelDocumentService.class);
    }

    protected KualiRuleService getRuleService() {
        return (KualiRuleService)SpringContext.getBean(KualiRuleService.class);
    }

    protected AccountingDistributionService getAccountingDistributionService() {
        return (AccountingDistributionService)SpringContext.getBean(AccountingDistributionService.class);
    }

    protected TravelExpenseService getTravelExpenseService() {
        if (this.travelExpenseService == null) {
            this.travelExpenseService = (TravelExpenseService)SpringContext.getBean(TravelExpenseService.class);
        }
        return this.travelExpenseService;
    }
}

