/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import java.lang.reflect.InvocationTargetException;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.module.tem.businessobject.ImportedExpense;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.validation.event.AddImportedExpenseDetailLineEvent;
import org.kuali.kfs.module.tem.document.web.bean.TravelMvcWrapperBean;
import org.kuali.kfs.module.tem.service.AccountingDistributionService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class AddImportedExpenseDetailEvent
implements Observer {
    public static Logger LOG = Logger.getLogger(AddImportedExpenseDetailEvent.class);
    private static final int WRAPPER_ARG_IDX = 0;
    private static final int SELECTED_LINE_ARG_IDX = 1;

    @Override
    public void update(Observable arg0, Object arg1) {
        if (!(arg1 instanceof Object[])) {
            return;
        }
        Object[] args = (Object[])arg1;
        LOG.debug(args[0]);
        if (!(args[0] instanceof TravelMvcWrapperBean)) {
            return;
        }
        TravelMvcWrapperBean wrapper = (TravelMvcWrapperBean)args[0];
        TravelDocument document = wrapper.getTravelDocument();
        Integer index = (Integer)args[1];
        ImportedExpense newImportedExpenseLine = wrapper.getNewImportedExpenseLines().get(index);
        if (newImportedExpenseLine != null) {
            newImportedExpenseLine.refreshReferenceObject("expenseTypeObjectCode");
        }
        ImportedExpense line = document.getImportedExpenses().get(index);
        boolean rulePassed = true;
        if (rulePassed &= this.getRuleService().applyRules(new AddImportedExpenseDetailLineEvent<ImportedExpense>("newImportedExpenseLines[" + index + "]", (Document)document, newImportedExpenseLine))) {
            if (newImportedExpenseLine != null && line != null) {
                newImportedExpenseLine.setExpenseLineTypeCode(null);
                newImportedExpenseLine.setCardType(line.getCardType());
                document.addExpenseDetail(newImportedExpenseLine, index);
                newImportedExpenseLine.setExpenseDetails(null);
            }
            KualiDecimal detailTotal = line.getTotalDetailExpenseAmount();
            ImportedExpense newExpense = new ImportedExpense();
            try {
                BeanUtils.copyProperties((Object)newExpense, (Object)line);
                newExpense.setConvertedAmount(null);
                newExpense.setExpenseParentId(newExpense.getId());
                newExpense.setId(null);
                newExpense.setNotes(null);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
            if (detailTotal.isLessThan((AbstractKualiDecimal)line.getExpenseAmount())) {
                KualiDecimal remainderExpense = (KualiDecimal)line.getExpenseAmount().subtract((AbstractKualiDecimal)detailTotal);
                KualiDecimal remainderConverted = (KualiDecimal)line.getConvertedAmount().subtract((AbstractKualiDecimal)new KualiDecimal(detailTotal.bigDecimalValue().multiply(line.getCurrencyRate())));
                newExpense.setExpenseAmount(remainderExpense);
                newExpense.setConvertedAmount(remainderConverted);
            } else {
                newExpense.setExpenseAmount(KualiDecimal.ZERO);
            }
            wrapper.getNewImportedExpenseLines().add(index, newExpense);
            wrapper.getNewImportedExpenseLines().remove(index + 1);
            wrapper.setDistribution(this.getAccountingDistributionService().buildDistributionFrom(document));
        }
    }

    protected TravelDocumentService getTravelDocumentService() {
        return (TravelDocumentService)SpringContext.getBean(TravelDocumentService.class);
    }

    protected KualiRuleService getRuleService() {
        return (KualiRuleService)SpringContext.getBean(KualiRuleService.class);
    }

    protected AccountingDistributionService getAccountingDistributionService() {
        return (AccountingDistributionService)SpringContext.getBean(AccountingDistributionService.class);
    }
}

