/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.web.struts.Inquisitive;
import org.kuali.kfs.module.tem.document.web.struts.QuestionHandler;
import org.kuali.kfs.module.tem.document.web.struts.StrutsInquisitor;
import org.kuali.kfs.module.tem.service.TravelEncumbranceService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.event.AccountingDocumentSaveWithNoLedgerEntryGenerationEvent;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class CancelQuestionHandler
implements QuestionHandler<TravelDocument> {
    private ConfigurationService ConfigurationService;
    private TravelEncumbranceService travelEncumbranceService;
    private DocumentService documentService;
    private TravelDocumentService travelDocumentService;
    private DataDictionaryService dataDictionaryService;

    @Override
    public <T> T handleResponse(Inquisitive<TravelDocument, ?> asker) throws Exception {
        if (asker.denied("CancelTa")) {
            return (T)asker.back();
        }
        if (asker.confirmed("ConfirmCancel")) {
            return (T)asker.end();
        }
        TravelAuthorizationDocument taDocument = (TravelAuthorizationDocument)asker.getDocument();
        String note = this.createNote(asker.getReason(), taDocument.getDocumentNumber());
        StringBuilder noteText = new StringBuilder(note);
        int noteTextLength = noteText.length();
        int noteTextMaxLength = this.getDataDictionaryService().getAttributeMaxLength(Note.class, "noteText");
        if (StringUtils.isBlank((String)asker.getReason()) || noteTextLength > noteTextMaxLength) {
            int reasonLimit = noteTextMaxLength - noteTextLength;
            reasonLimit = reasonLimit < 0 ? reasonLimit * -1 : reasonLimit;
            String message = this.getMessageFrom("travelAuthorization.question.text");
            String question = StringUtils.replace((String)message, (String)"{0}", (String)"Cancel");
            if (StringUtils.isBlank((String)asker.getReason())) {
                return (T)asker.confirm("CancelTa", question, true, "error.travelAuthorization.reasonRequired", "reason", "Cancel");
            }
            return (T)asker.confirm("CancelTa", question, true, "error.travelAuthorization.reason.pastLimit", "reason", new Integer(reasonLimit).toString());
        }
        ActionForward returnActionForward = ((StrutsInquisitor)asker).getMapping().findForward("basic");
        taDocument.refreshReferenceObject("generalLedgerPendingEntries");
        Note reasonNote = this.getDocumentService().createNoteFromDocument((Document)taDocument, noteText.toString());
        reasonNote.setNoteText(noteText.toString());
        taDocument.addNote(reasonNote);
        Note cancelNote = this.getDocumentService().createNoteFromDocument((Document)taDocument, "Travel Authorization cancelled.");
        Principal systemUser = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("kfs");
        cancelNote.setAuthorUniversalIdentifier(systemUser.getPrincipalId());
        taDocument.addNote(cancelNote);
        taDocument.updateAndSaveAppDocStatus("Cancelled");
        this.getTravelEncumbranceService().liquidateEncumbranceForCancelTA(taDocument);
        ((DocumentService)SpringContext.getBean(DocumentService.class)).saveDocument((Document)taDocument, AccountingDocumentSaveWithNoLedgerEntryGenerationEvent.class);
        taDocument.refreshReferenceObject("generalLedgerPendingEntries");
        this.getTravelDocumentService().addAdHocFYIRecipient((Document)taDocument, taDocument.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId());
        this.getTravelDocumentService().addAdHocFYIRecipient((Document)taDocument, taDocument.getTraveler().getPrincipalId());
        ((WorkflowDocumentService)SpringContext.getBean(WorkflowDocumentService.class)).acknowledge(taDocument.getDocumentHeader().getWorkflowDocument(), null, new ArrayList(taDocument.getAdHocRoutePersons()));
        if (ObjectUtils.isNotNull((Object)returnActionForward)) {
            return (T)returnActionForward;
        }
        String message = this.getMessageFrom("travelAuthorization.question.text");
        String question = StringUtils.replace((String)message, (String)"{0}", (String)"Cancel");
        return (T)asker.confirm("CancelTa", question, true, "temSingleConfirmationQuestion", "CancelTa", "");
    }

    @Override
    public <T> T askQuestion(Inquisitive<TravelDocument, ?> asker) throws Exception {
        String key = this.getMessageFrom("travelAuthorization.question.text");
        String question = StringUtils.replace((String)key, (String)"{0}", (String)"Cancel");
        Object retval = asker.confirm("CancelTa", question, true, new String[0]);
        return (T)retval;
    }

    public String getMessageFrom(String messageType) {
        return this.getConfigurationService().getPropertyValueAsString(messageType);
    }

    private String createNote(String reason, String documentNumber) {
        String introNoteMessage = "Note entered while canceling a Travel Authorization :  ";
        return introNoteMessage + reason;
    }

    public void setConfigurationService(ConfigurationService ConfigurationService2) {
        this.ConfigurationService = ConfigurationService2;
    }

    protected ConfigurationService getConfigurationService() {
        return this.ConfigurationService;
    }

    public TravelEncumbranceService getTravelEncumbranceService() {
        return this.travelEncumbranceService;
    }

    public void setTravelEncumbranceService(TravelEncumbranceService travelEncumbranceService) {
        this.travelEncumbranceService = travelEncumbranceService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public TravelDocumentService getTravelDocumentService() {
        return this.travelDocumentService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    protected DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }
}

