/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.businessobject.Attendee;
import org.kuali.kfs.module.tem.businessobject.options.AttendeeTypeValuesFinder;
import org.kuali.kfs.module.tem.document.TravelEntertainmentDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.service.TravelEntertainmentDocumentService;
import org.kuali.kfs.module.tem.document.validation.event.AddAttendeeLineEvent;
import org.kuali.kfs.module.tem.document.web.bean.TravelEntertainmentMvcWrapperBean;
import org.kuali.kfs.module.tem.exception.UploadParserException;
import org.kuali.rice.core.api.util.KeyValue;

public class ImportAttendeesEvent
implements Observer {
    public static Logger LOG = Logger.getLogger(ImportAttendeesEvent.class);
    private static final int WRAPPER_ARG_IDX = 0;
    private static final int FILE_CONTENTS_ARG_IDX = 1;
    public static final String[] ATTENDEE_ATTRIBUTE_NAMES = new String[]{"attendeeType", "company", "title", "name"};
    public static final Integer[] MAX_LENGTH = new Integer[]{10, 40, 40, 40};
    protected KualiRuleService kualiRuleService;
    protected TravelDocumentService travelDocumentService;
    protected TravelEntertainmentDocumentService travelEntertainmentDocumentService;

    @Override
    public void update(Observable observable, Object arg) {
        Object[] args = (Object[])arg;
        LOG.debug(args[0]);
        if (!(args[0] instanceof TravelEntertainmentMvcWrapperBean)) {
            return;
        }
        TravelEntertainmentMvcWrapperBean wrapper = (TravelEntertainmentMvcWrapperBean)args[0];
        String fileContents = (String)args[1];
        TravelEntertainmentDocument document = (TravelEntertainmentDocument)wrapper.getTravelDocument();
        List<Attendee> importedAttendees = null;
        String tabErrorKey = "attendee";
        try {
            HashMap<String, List<String>> defaultValues = new HashMap<String, List<String>>();
            AttendeeTypeValuesFinder finder = new AttendeeTypeValuesFinder();
            ArrayList<String> defaultList = new ArrayList<String>();
            for (KeyValue pair : finder.getKeyValues()) {
                if (pair.getValue().equals("")) continue;
                defaultList.add(pair.getKey().toString());
                defaultList.add(pair.getValue());
            }
            defaultValues.put("attendeeType", defaultList);
            importedAttendees = this.getTravelDocumentService().importFile(fileContents, Attendee.class, ATTENDEE_ATTRIBUTE_NAMES, defaultValues, MAX_LENGTH, "attendee");
            boolean allPassed = true;
            boolean itemLineNumber = false;
            for (Attendee o : importedAttendees) {
                allPassed &= this.getRuleService().applyRules(new AddAttendeeLineEvent<Attendee>("newAttendeeLine", (Document)document, o));
            }
            if (allPassed) {
                for (Attendee attendee : importedAttendees) {
                    attendee.setDocumentNumber(document.getDocumentNumber());
                    document.getAttendee().add(attendee);
                }
            }
        }
        catch (UploadParserException e) {
            GlobalVariables.getMessageMap().putError("attendee", e.getErrorKey(), e.getErrorParameters());
        }
    }

    public TravelDocumentService getTravelDocumentService() {
        return this.travelDocumentService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }

    public TravelEntertainmentDocumentService getTravelEntertainmentDocumentService() {
        return this.travelEntertainmentDocumentService;
    }

    public void setTravelEntertainmentDocumentService(TravelEntertainmentDocumentService travelEntertainmentDocumentService) {
        this.travelEntertainmentDocumentService = travelEntertainmentDocumentService;
    }

    public void setRuleService(KualiRuleService kualiRuleService) {
        this.kualiRuleService = kualiRuleService;
    }

    protected KualiRuleService getRuleService() {
        return this.kualiRuleService;
    }
}

