/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.web.bean.TravelMvcWrapperBean;
import org.kuali.kfs.module.tem.service.AccountingDistributionService;
import org.kuali.kfs.sys.context.SpringContext;

public class RemoveActualExpenseEvent
implements Observer {
    public static Logger LOG = Logger.getLogger(RemoveActualExpenseEvent.class);
    private static final int WRAPPER_ARG_IDX = 0;
    private static final int SELECTED_LINE_ARG_IDX = 1;
    private TravelDocumentService travelDocumentService;
    private AccountingDistributionService accountingDistributionService;
    private KualiRuleService ruleService;

    @Override
    public void update(Observable arg0, Object arg1) {
        if (!(arg1 instanceof Object[])) {
            return;
        }
        Object[] args = (Object[])arg1;
        LOG.debug(args[0]);
        if (!(args[0] instanceof TravelMvcWrapperBean)) {
            return;
        }
        TravelMvcWrapperBean wrapper = (TravelMvcWrapperBean)args[0];
        TravelDocument document = wrapper.getTravelDocument();
        Integer deleteIndex = (Integer)args[1];
        ActualExpense line = document.getActualExpenses().get(deleteIndex);
        document.removeExpense(line, deleteIndex);
        wrapper.getNewActualExpenseLines().remove(deleteIndex);
        List<ActualExpense> actualExpenses = wrapper.getNewActualExpenseLines();
        wrapper.setDistribution(this.getAccountingDistributionService().buildDistributionFrom(document));
        for (String disabledProperty : document.getDisabledProperties().keySet()) {
            this.getTravelDocumentService().restorePerDiemProperty(document, disabledProperty);
        }
        document.getDisabledProperties().clear();
    }

    public TravelDocumentService getTravelDocumentService() {
        return this.travelDocumentService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }

    public KualiRuleService getRuleService() {
        return this.ruleService;
    }

    public void setRuleService(KualiRuleService ruleService) {
        this.ruleService = ruleService;
    }

    public AccountingDistributionService getAccountingDistributionService() {
        if (this.accountingDistributionService == null) {
            this.accountingDistributionService = (AccountingDistributionService)SpringContext.getBean(AccountingDistributionService.class);
        }
        return this.accountingDistributionService;
    }

    public void setAccountingDistributionService(AccountingDistributionService accountingDistributionService) {
        this.accountingDistributionService = accountingDistributionService;
    }
}

