/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.upload.FormFile;
import org.kuali.kfs.kns.web.ui.ExtraButton;
import org.kuali.kfs.kns.web.ui.HeaderField;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.businessobject.AccountingDistribution;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLine;
import org.kuali.kfs.module.tem.businessobject.TransportationModeDetail;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.businessobject.TravelerDetailEmergencyContact;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelDocumentBase;
import org.kuali.kfs.module.tem.document.service.TravelReimbursementService;
import org.kuali.kfs.module.tem.document.web.bean.TravelAuthorizationMvcWrapperBean;
import org.kuali.kfs.module.tem.document.web.struts.TravelFormBase;
import org.kuali.kfs.module.tem.service.TravelService;
import org.kuali.kfs.module.tem.util.MessageUtils;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.rice.core.web.format.CurrencyFormatter;
import org.kuali.rice.kew.api.WorkflowDocument;

public class TravelAuthorizationForm
extends TravelFormBase
implements TravelAuthorizationMvcWrapperBean {
    private TravelerDetailEmergencyContact newEmergencyContactLine;
    private TravelerDetail newTraveler;
    private boolean canCloseTA;
    private boolean canAmend;
    private boolean canCancelTA;
    private boolean canHold;
    private boolean canRemoveHold;
    private boolean canUnmask = false;
    private boolean travelArranger;
    private boolean allowIncidentals = true;
    private String policyURL;
    private Boolean multipleAdvances;
    private boolean showPolicy;
    private boolean waitingOnTraveler;
    private Boolean showCorporateCardTotal;
    private boolean showTravelAdvancesForTrip;
    protected transient FormFile advanceAccountingFile;
    private TemSourceAccountingLine newAdvanceAccountingLine;
    private List<String> tempSelectedTransportationModes = new ArrayList<String>();

    public TravelAuthorizationForm() {
        this.setShowPerDiem(false);
    }

    @Override
    public void setDistribution(List<AccountingDistribution> distribution) {
        super.setDistribution(distribution);
        TravelDocument travelDocument = (TravelDocument)this.getDocument();
        for (AccountingDistribution accountdistribution : this.distribution) {
            if (!accountdistribution.getCardType().equals(travelDocument.getDefaultCardTypeCode())) continue;
            accountdistribution.setSelected(Boolean.FALSE);
            accountdistribution.setDisabled(Boolean.TRUE);
        }
    }

    @Override
    public boolean isDisplayAccountingLines() {
        boolean display = super.isDisplayAccountingLines();
        TravelAuthorizationDocument document = (TravelAuthorizationDocument)this.getTravelDocument();
        display = document.isTripGenerateEncumbrance();
        return display;
    }

    public boolean isDisplayImportedExpenseRelatedTab() {
        boolean display = this.getParameterService().getParameterValueAsBoolean(TravelAuthorizationDocument.class, "DISPLAY_IMPORTED_EXPENSE_IND");
        return display;
    }

    @Override
    public String getPerDiemLabel() {
        return "Estimated " + super.getPerDiemLabel();
    }

    @Override
    public String getExpenseLabel() {
        return "Estimated " + StringUtils.substringAfter((String)super.getExpenseLabel(), (String)" ");
    }

    @Override
    public String getExpenseTabLabel() {
        return "Expenses";
    }

    @Override
    public TravelerDetailEmergencyContact getNewEmergencyContactLine() {
        return this.newEmergencyContactLine;
    }

    @Override
    public void setNewEmergencyContactLine(TravelerDetailEmergencyContact newEmergencyContactLine) {
        this.newEmergencyContactLine = newEmergencyContactLine;
    }

    public TemSourceAccountingLine getNewAdvanceAccountingLine() {
        if (this.getTravelAuthorizationDocument() == null) {
            throw new IllegalArgumentException("TravelAuthorizationDocument cannot be null when creating new accounting line for advance");
        }
        if (this.newAdvanceAccountingLine == null) {
            this.newAdvanceAccountingLine = this.getTravelAuthorizationDocument().createNewAdvanceAccountingLine();
        }
        return this.newAdvanceAccountingLine;
    }

    public void setNewAdvanceAccountingLine(TemSourceAccountingLine newTravelAdvanceAccountingLine) {
        this.newAdvanceAccountingLine = newTravelAdvanceAccountingLine;
    }

    @Override
    public List<String> getSelectedTransportationModes() {
        ArrayList<String> mySelectedTransportationModes = new ArrayList<String>();
        List<TransportationModeDetail> details = this.getTravelAuthorizationDocument().getTransportationModes();
        for (TransportationModeDetail detail : details) {
            mySelectedTransportationModes.add(detail.getTransportationModeCode());
        }
        return mySelectedTransportationModes;
    }

    @Override
    public void setSelectedTransportationModes(List<String> selectedTransportationModes) {
        this.tempSelectedTransportationModes = selectedTransportationModes;
    }

    @Override
    public List<String> getTempSelectedTransporationModes() {
        return this.tempSelectedTransportationModes;
    }

    @Override
    protected String getDocumentIdentifierFieldName() {
        return "travelDocumentIdentifier";
    }

    @Override
    public TravelAuthorizationDocument getTravelAuthorizationDocument() {
        return (TravelAuthorizationDocument)this.getDocument();
    }

    @Override
    public void setNewTraveler(TravelerDetail traveler) {
        this.newTraveler = traveler;
    }

    @Override
    public TravelerDetail getNewTraveler() {
        return this.newTraveler;
    }

    protected String getDefaultDocumentTypeName() {
        return "TA";
    }

    protected Map<String, ExtraButton> createButtonsMap() {
        HashMap<String, ExtraButton> result = new HashMap<String, ExtraButton>();
        ExtraButton amendButton = new ExtraButton();
        amendButton.setExtraButtonProperty("methodToCall.amendTa");
        amendButton.setExtraButtonSource("${externalizable.images.url}buttonsmall_amend.gif");
        amendButton.setExtraButtonAltText("Amend");
        ExtraButton holdButton = new ExtraButton();
        holdButton.setExtraButtonProperty("methodToCall.holdTa");
        holdButton.setExtraButtonSource("${externalizable.images.url}buttonsmall_hold.gif");
        holdButton.setExtraButtonAltText("Hold");
        ExtraButton removeHoldButton = new ExtraButton();
        removeHoldButton.setExtraButtonProperty("methodToCall.removeHoldTa");
        removeHoldButton.setExtraButtonSource("${externalizable.images.url}buttonsmall_removehold.gif");
        removeHoldButton.setExtraButtonAltText("Remove Hold");
        ExtraButton cancelTravelButton = new ExtraButton();
        cancelTravelButton.setExtraButtonProperty("methodToCall.cancelTa");
        cancelTravelButton.setExtraButtonSource("${externalizable.images.url}buttonsmall_cancelta.gif");
        cancelTravelButton.setExtraButtonAltText("Cancel Travel Authorization");
        ExtraButton closeTAButton = new ExtraButton();
        closeTAButton.setExtraButtonProperty("methodToCall.closeTa");
        closeTAButton.setExtraButtonSource("${externalizable.images.url}buttonsmall_closeta.gif");
        closeTAButton.setExtraButtonAltText("Close Travel Authorization");
        result.put(amendButton.getExtraButtonProperty(), amendButton);
        result.put(holdButton.getExtraButtonProperty(), holdButton);
        result.put(removeHoldButton.getExtraButtonProperty(), removeHoldButton);
        result.put(cancelTravelButton.getExtraButtonProperty(), cancelTravelButton);
        result.put(closeTAButton.getExtraButtonProperty(), closeTAButton);
        result.putAll(this.createNewReimbursementButtonMap());
        result.putAll(this.createPaymentExtraButtonMap());
        return result;
    }

    @Override
    public List<ExtraButton> getExtraButtons() {
        super.getExtraButtons();
        Map<String, ExtraButton> buttonsMap = this.createButtonsMap();
        if (this.getDocumentActions().keySet().contains("canAmend")) {
            this.extraButtons.add(buttonsMap.get("methodToCall.amendTa"));
        }
        if (this.getDocumentActions().keySet().contains("canHold")) {
            this.extraButtons.add(buttonsMap.get("methodToCall.holdTa"));
        }
        if (this.getDocumentActions().keySet().contains("canRemoveHold")) {
            this.extraButtons.add(buttonsMap.get("methodToCall.removeHoldTa"));
        }
        if (this.getDocumentActions().keySet().contains("canCloseTA")) {
            this.extraButtons.add(buttonsMap.get("methodToCall.closeTa"));
        }
        if (this.getDocumentActions().keySet().contains("canCancelTA")) {
            this.extraButtons.add(buttonsMap.get("methodToCall.cancelTa"));
        }
        if (this.getDocumentActions().keySet().contains("canNewReimbursement")) {
            this.extraButtons.add(buttonsMap.get("methodToCall.newReimbursement"));
        }
        if (this.getDocumentActions().keySet().contains("canPayVendor")) {
            this.extraButtons.add(buttonsMap.get("methodToCall.payDVToVendor"));
        }
        return this.extraButtons;
    }

    @Override
    public boolean isCanUnmask() {
        return this.canUnmask;
    }

    @Override
    public void setCanUnmask(boolean canUnmask) {
        this.canUnmask = canUnmask;
    }

    protected TravelReimbursementService getTravelReimbursementService() {
        return (TravelReimbursementService)SpringContext.getBean(TravelReimbursementService.class);
    }

    protected TravelService getTravelService() {
        return (TravelService)SpringContext.getBean(TravelService.class);
    }

    public boolean isAllowIncidentals() {
        return this.allowIncidentals;
    }

    public void setAllowIncidentals(boolean allowIncidentals) {
        this.allowIncidentals = allowIncidentals;
    }

    public String getPolicyURL() {
        if (this.policyURL == null) {
            this.policyURL = this.getParameterService().getParameterValueAsString(TravelAuthorizationDocument.class, "TRAVEL_ADVANCES_POLICY_URL");
        }
        return MessageUtils.getMessage("message.document.tem.ta.advance.policy", this.policyURL);
    }

    public boolean isShowTravelAdvancesForTrip() {
        return this.showTravelAdvancesForTrip;
    }

    public void setShowTravelAdvancesForTrip(boolean showTravelAdvancesForTrip) {
        this.showTravelAdvancesForTrip = showTravelAdvancesForTrip;
    }

    public boolean isWaitingOnTraveler() {
        return this.waitingOnTraveler;
    }

    public void setWaitingOnTraveler(boolean waitingOnTraveler) {
        this.waitingOnTraveler = waitingOnTraveler;
    }

    public boolean getShowCorporateCardTotal() {
        if (this.showCorporateCardTotal == null) {
            this.showCorporateCardTotal = (boolean)this.getParameterService().getParameterValueAsBoolean(TemParameterConstants.TEM_DOCUMENT.class, "AMOUNT_DUE_CORPORATE_CARD_TOTAL_LINE_IND", Boolean.valueOf(false));
        }
        return this.showCorporateCardTotal;
    }

    public boolean isShowPolicy() {
        return this.showPolicy;
    }

    public void setShowPolicy(boolean showPolicy) {
        this.showPolicy = showPolicy;
    }

    protected DataDictionaryService getDataDictionaryService() {
        return (DataDictionaryService)SpringContext.getBean(DataDictionaryService.class);
    }

    @Override
    public String getTravelPaymentFormAction() {
        return "temTravelAuthorization";
    }

    public FormFile getAdvanceAccountingFile() {
        return this.advanceAccountingFile;
    }

    public void setAdvanceAccountingFile(FormFile advanceFile) {
        this.advanceAccountingFile = advanceFile;
    }

    public String getCurrencyFormattedAdvanceTotal() {
        return (String)new CurrencyFormatter().format((Object)this.getTravelAuthorizationDocument().getAdvanceTotal());
    }

    public boolean isAdvancePdpStatusTabShown() {
        if (this.getTravelDocument() != null) {
            return this.getTravelAuthorizationDocument().shouldProcessAdvanceForDocument();
        }
        return false;
    }

    public boolean isDefaultTravelAdvanceTab() {
        return this.getTravelDocument() != null && this.getTravelAuthorizationDocument().shouldProcessAdvanceForDocument() && ("In Process".equals(this.getTravelDocument().getAppDocStatus()) || "Awaiting Traveler Review".equals(this.getTravelDocument().getAppDocStatus()) || "Awaiting Fiscal Officer Review".equals(this.getTravelDocument().getAppDocStatus()) || "Awaiting Travel Manager Review".equals(this.getTravelDocument().getAppDocStatus()));
    }

    @Override
    protected SourceAccountingLine createNewSourceAccountingLine(AccountingDocument financialDocument) {
        TemSourceAccountingLine accountingLine = (TemSourceAccountingLine)super.createNewSourceAccountingLine(financialDocument);
        TravelDocumentBase travelDoc = (TravelDocumentBase)financialDocument;
        travelDoc.refreshReferenceObject("tripType");
        if (ObjectUtils.isNotNull((Object)((Object)travelDoc.getTripType()))) {
            accountingLine.setFinancialObjectCode(travelDoc.getTripType().getEncumbranceObjCode());
        }
        return accountingLine;
    }

    @Override
    public void populateHeaderFields(WorkflowDocument workflowDocument) {
        super.populateHeaderFields(workflowDocument);
        boolean vendorPaymentAllowedBeforeFinal = this.getParameterService().getParameterValueAsBoolean(TravelAuthorizationDocument.class, "VENDOR_PAYMENT_ALLOWED_BEFORE_FINAL_APPROVAL_IND");
        String travelDocumentIdentifier = this.getTravelDocument().getTravelDocumentIdentifier();
        String organizationDocumentNumber = this.getTravelDocument().getDocumentHeader().getOrganizationDocumentNumber();
        TravelAuthorizationDocument document = (TravelAuthorizationDocument)this.getTravelDocument();
        if (document.maskTravelDocumentIdentifierAndOrganizationDocNumber()) {
            int i;
            int strLength;
            DataDictionaryService dataDictionaryService = (DataDictionaryService)SpringContext.getBean(DataDictionaryService.class);
            if (ObjectUtils.isNotNull((Object)travelDocumentIdentifier)) {
                travelDocumentIdentifier = "";
                strLength = dataDictionaryService.getAttributeMaxLength(TravelAuthorizationDocument.class.getName(), "travelDocumentIdentifier");
                for (i = 0; i < strLength; ++i) {
                    travelDocumentIdentifier = travelDocumentIdentifier.concat("*");
                }
            }
            if (ObjectUtils.isNotNull((Object)organizationDocumentNumber)) {
                organizationDocumentNumber = "";
                strLength = dataDictionaryService.getAttributeMaxLength(DocumentHeader.class.getName(), "organizationDocumentNumber");
                for (i = 0; i < strLength; ++i) {
                    organizationDocumentNumber = organizationDocumentNumber.concat("*");
                }
            }
            for (HeaderField headerField : this.getDocInfo()) {
                String ddAttributeEntryName = headerField.getDdAttributeEntryName();
                if (ObjectUtils.isNotNull((Object)ddAttributeEntryName) && ddAttributeEntryName.equals("DataDictionary.TravelAuthorizationDocument.attributes.travelDocumentIdentifier")) {
                    headerField.setDisplayValue(travelDocumentIdentifier);
                }
                if (!ObjectUtils.isNotNull((Object)ddAttributeEntryName) || !ddAttributeEntryName.equals("DataDictionary.DocumentHeader.attributes.organizationDocumentNumber")) continue;
                headerField.setDisplayValue(organizationDocumentNumber);
            }
        }
    }
}

