/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.upload.FormFile;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.web.ui.ExtraButton;
import org.kuali.kfs.kns.web.ui.HeaderField;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.InfrastructureException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.uif.field.LinkField;
import org.kuali.kfs.krad.util.NoteType;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.businessobject.AccountingDistribution;
import org.kuali.kfs.module.tem.businessobject.AccountingDocumentRelationship;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.GroupTraveler;
import org.kuali.kfs.module.tem.businessobject.ImportedExpense;
import org.kuali.kfs.module.tem.businessobject.TemDistributionAccountingLine;
import org.kuali.kfs.module.tem.businessobject.TransportationMode;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelDocumentBase;
import org.kuali.kfs.module.tem.document.web.bean.AccountingLineDistributionKey;
import org.kuali.kfs.module.tem.document.web.bean.TravelMvcWrapperBean;
import org.kuali.kfs.module.tem.document.web.struts.TravelStrutsObservable;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.service.PaymentSourceHelperService;
import org.kuali.kfs.sys.web.struts.KualiAccountingDocumentFormBase;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;

public abstract class TravelFormBase
extends KualiAccountingDocumentFormBase
implements TravelMvcWrapperBean {
    protected static final String VENDOR_PAYMENT_BUTTON_IMAGE_NAME = "buttonsmall_vendorpayment.gif";
    private Integer travelerId;
    private Integer tempTravelerId;
    private String empPrincipalId;
    private String tempEmpPrincipalId;
    private boolean showLodging;
    private boolean showMileage;
    private boolean showPerDiem;
    private boolean showPerDiemBreakdown = false;
    private boolean calculated;
    private boolean canCalculate;
    private boolean canReturn;
    private boolean canShowImportExpenseDetails = true;
    private int perDiemPercentage;
    private boolean displayNonEmployeeForm = false;
    private boolean openPaymentInformationWindow = false;
    private boolean canOpenPaymentInformation = false;
    private String wireChargeMessage;
    private String foreignCurrencyUrl;
    private Observable observable;
    private AccountingDocumentRelationship newAccountingDocumentRelationship;
    private String defaultPerDiemMileageExpenseType;
    private Map<String, List<Document>> relatedDocuments;
    private Map<String, List<Note>> relatedDocumentNotes;
    private List<ActualExpense> newActualExpenseLines;
    private ActualExpense newActualExpenseLine;
    private List<ImportedExpense> newImportedExpenseLines;
    private ImportedExpense newImportedExpenseLine;
    private GroupTraveler newGroupTravelerLine;
    protected FormFile groupTravelerImportFile;
    protected List<AccountingDistribution> distribution;
    protected Integer accountDistributionnextSourceLineNumber;
    protected TemDistributionAccountingLine accountDistributionnewSourceLine;
    protected List<TemDistributionAccountingLine> accountDistributionsourceAccountingLines = new ArrayList<TemDistributionAccountingLine>();
    protected List<LinkField> agencyLinks;
    protected boolean shouldDisplayAgencyLinks;
    protected FormFile accountDistributionFile;
    protected String lookupResultsSequenceNumber;
    protected String lookupResultsBOClassName;
    protected String lookedUpCollectionName;
    protected boolean perDiemCreatable = true;

    protected TravelFormBase() {
        this.accountDistributionnextSourceLineNumber = new Integer(1);
        this.setAccountDistributionnewSourceLine(this.setupNewAccountDistributionAccountingLine());
        this.setNewActualExpenseLine(new ActualExpense());
        this.setNewActualExpenseLines(new ArrayList<ActualExpense>());
    }

    protected TemDistributionAccountingLine setupNewAccountDistributionAccountingLine() {
        TemDistributionAccountingLine accountingLine = new TemDistributionAccountingLine();
        accountingLine.setSequenceNumber(new Integer(0));
        return accountingLine;
    }

    public void populate(HttpServletRequest request) {
        super.populate(request);
        boolean enablePrimaryDestination = this.getParameterService().getParameterValueAsBoolean(TravelAuthorizationDocument.class, "OVERRIDE_PRIMARY_DESTINATION_IND");
        request.setAttribute("enablePrimaryDestination", (Object)enablePrimaryDestination);
        boolean enablePerDiemLookupLinks = this.getParameterService().getParameterValueAsBoolean(TravelAuthorizationDocument.class, "DISPLAY_PER_DIEM_URL_IND");
        request.setAttribute("enablePerDiemLookupLinks", (Object)enablePerDiemLookupLinks);
        if (this.getDocument() != null && !StringUtils.isBlank((String)this.getDocument().getDocumentNumber())) {
            this.getNewActualExpenseLine().setDocumentNumber(this.getDocument().getDocumentNumber());
        }
    }

    public boolean isDisplayAccountingLines() {
        TravelDocument document = this.getTravelDocument();
        return !document.hasOnlyPrepaidExpenses();
    }

    public String getPerDiemLabel() {
        return "Per Diem Expenses";
    }

    public String getExpenseLabel() {
        return "Actual Expenses";
    }

    public String getExpenseTabLabel() {
        return "Actual Expenses";
    }

    @Override
    public Integer getTravelerId() {
        return this.travelerId;
    }

    @Override
    public TravelDocument getTravelDocument() {
        return (TravelDocument)this.getDocument();
    }

    @Override
    public void setTravelerId(Integer travelerId) {
        this.travelerId = travelerId;
    }

    @Override
    public Integer getTempTravelerId() {
        return this.tempTravelerId;
    }

    @Override
    public void setTempTravelerId(Integer tempTravelerId) {
        this.tempTravelerId = tempTravelerId;
    }

    public Observable getObservable() {
        return (Observable)SpringContext.getBean(TravelStrutsObservable.class);
    }

    @Override
    public String getEmpPrincipalId() {
        return this.empPrincipalId;
    }

    @Override
    public void setEmpPrincipalId(String empPrincipalId) {
        this.empPrincipalId = empPrincipalId;
    }

    @Override
    public String getTempEmpPrincipalId() {
        return this.tempEmpPrincipalId;
    }

    @Override
    public void setTempEmpPrincipalId(String tempEmpPrincipalId) {
        this.tempEmpPrincipalId = tempEmpPrincipalId;
    }

    protected String getDataDictionaryAttributeName(String attrName) {
        return "DataDictionary." + this.getDocument().getClass().getSimpleName() + ".attributes." + attrName;
    }

    protected abstract String getDocumentIdentifierFieldName();

    protected String getStatusCodeFieldName() {
        return "dummyAppDocStatus";
    }

    public void populateHeaderFields(WorkflowDocument workflowDocument) {
        super.populateHeaderFields(workflowDocument);
        TravelDocument travelDoc = (TravelDocument)this.getDocument();
        String status = "Not Available";
        String identifier = "Not Available";
        if (ObjectUtils.isNotNull((Object)travelDoc.getTravelDocumentIdentifier())) {
            identifier = "" + travelDoc.getTravelDocumentIdentifier();
        }
        status = workflowDocument.getApplicationDocumentStatus();
        this.getDocInfo().add(new HeaderField(this.getDataDictionaryAttributeName(this.getDocumentIdentifierFieldName()), identifier));
        this.getDocInfo().add(new HeaderField(this.getDataDictionaryAttributeName(this.getStatusCodeFieldName()), status));
    }

    @Override
    public Map<String, String> getModesOfTransportation() {
        HashMap<String, String> modesOfTrans = new HashMap<String, String>();
        Collection bos = ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findAll(TransportationMode.class);
        for (TransportationMode mode : bos) {
            if (!mode.isActive()) continue;
            modesOfTrans.put(mode.getCode(), mode.getName());
        }
        return modesOfTrans;
    }

    public void parsePerDiemCategories(Collection<String> perDiemCats) {
        for (String category : perDiemCats) {
            String[] pair = category.split("=");
            if (pair[0].equalsIgnoreCase("LODGING")) {
                this.showLodging = pair[1].equalsIgnoreCase("Y");
            }
            if (pair[0].equalsIgnoreCase("MILEAGE")) {
                this.showMileage = pair[1].equalsIgnoreCase("Y");
            }
            if (!pair[0].equalsIgnoreCase("PER_DIEM")) continue;
            this.showPerDiem = pair[1].equalsIgnoreCase("Y");
        }
    }

    @Override
    public boolean isShowLodging() {
        return this.showLodging;
    }

    @Override
    public void setShowLodging(boolean showLodging) {
        this.showLodging = showLodging;
    }

    @Override
    public boolean isShowMileage() {
        return this.showMileage;
    }

    @Override
    public void setShowMileage(boolean showMileage) {
        this.showMileage = showMileage;
    }

    @Override
    public boolean isShowPerDiem() {
        return this.showPerDiem;
    }

    public void setShowPerDiemBreakdown(boolean showPerDiemBreakdown) {
        this.showPerDiemBreakdown = showPerDiemBreakdown;
    }

    public boolean isShowPerDiemBreakdown() {
        return this.showPerDiemBreakdown;
    }

    @Override
    public boolean canReturn() {
        return this.canReturn;
    }

    @Override
    public void setCanReturn(boolean canReturn) {
        this.canReturn = canReturn;
    }

    public boolean canCalculate() {
        return this.canCalculate;
    }

    public void setCanCalculate(boolean canCalculate) {
        this.canCalculate = canCalculate;
    }

    public boolean isCanShowImportExpenseDetails() {
        return this.getParameterService().getParameterValueAsBoolean(TemParameterConstants.TEM_DOCUMENT.class, "IMPORTED_EXPENSE_DETAIL_IND");
    }

    public void setCanShowImportExpenseDetails(boolean canShowImportExpenseDetails) {
        this.canShowImportExpenseDetails = canShowImportExpenseDetails;
    }

    @Override
    public void setShowPerDiem(boolean showPerDiem) {
        this.showPerDiem = showPerDiem;
    }

    @Override
    public boolean isShowAllPerDiemCategories() {
        return this.showLodging || this.showMileage || this.showPerDiem;
    }

    @Override
    public void setPerDiemPercentage(String perDiemPercentage) {
        this.perDiemPercentage = Integer.parseInt(perDiemPercentage);
    }

    @Override
    public int getPerDiemPercentage() {
        return this.perDiemPercentage;
    }

    @Override
    public void setPerDiemPercentage(int perDiemPercentage) {
        this.perDiemPercentage = perDiemPercentage;
    }

    @Override
    public Map<String, List<Document>> getRelatedDocuments() {
        if (this.relatedDocuments == null) {
            this.relatedDocuments = new HashMap<String, List<Document>>();
        }
        return this.relatedDocuments;
    }

    @Override
    public void setRelatedDocuments(Map<String, List<Document>> relatedDocuments) {
        this.relatedDocuments = relatedDocuments;
    }

    @Override
    public Map<String, List<Note>> getRelatedDocumentNotes() {
        if (this.relatedDocumentNotes == null) {
            this.relatedDocumentNotes = new HashMap<String, List<Note>>();
            for (List<Document> documents : this.relatedDocuments.values()) {
                for (Document document : documents) {
                    List remoteNotes = ((NoteService)SpringContext.getBean(NoteService.class)).getByRemoteObjectId(document.getNoteType() == NoteType.BUSINESS_OBJECT ? document.getObjectId() : document.getDocumentHeader().getObjectId());
                    Collections.reverse(remoteNotes);
                    this.relatedDocumentNotes.put(document.getDocumentNumber(), remoteNotes);
                }
            }
        }
        return this.relatedDocumentNotes;
    }

    @Override
    public void setRelatedDocumentNotes(Map<String, List<Note>> relatedDocumentNotes) {
        this.relatedDocumentNotes = relatedDocumentNotes;
    }

    protected ParameterService getParameterService() {
        return (ParameterService)SpringContext.getBean(ParameterService.class);
    }

    @Override
    public boolean isCalculated() {
        return this.calculated;
    }

    @Override
    public void setCalculated(boolean calculated) {
        this.calculated = calculated;
    }

    @Override
    public List<ExtraButton> getExtraButtons() {
        this.extraButtons.clear();
        String appExternalImageURL = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("externalizable.images.url");
        if (this.canReturn()) {
            this.addExtraButton("methodToCall.returnToFiscalOfficer", appExternalImageURL + "buttonsmall_return_to_fo.gif", "Return to Fiscal Officer");
        }
        if (this.canCalculate()) {
            this.addExtraButton("methodToCall.recalculate", appExternalImageURL + "buttonsmall_calculate.gif", "Calculate");
        }
        return this.extraButtons;
    }

    protected void addExtraButton(String property, String source, String altText) {
        ExtraButton newButton = new ExtraButton();
        newButton.setExtraButtonProperty(property);
        newButton.setExtraButtonSource(source);
        newButton.setExtraButtonAltText(altText);
        this.extraButtons.add(newButton);
    }

    public SourceAccountingLine getNewSourceLine() {
        super.getNewSourceLine();
        if (this.newSourceLine != null && this.newSourceLine.getChartOfAccountsCode() == null && this.newSourceLine.getAccountNumber() == null && this.newSourceLine.getSubAccountNumber() == null && this.newSourceLine.getProjectCode() == null) {
            this.newSourceLine = this.createNewSourceAccountingLine(this.getFinancialDocument());
        }
        return this.newSourceLine;
    }

    protected SourceAccountingLine createNewSourceAccountingLine(AccountingDocument financialDocument) {
        if (financialDocument == null) {
            throw new IllegalArgumentException("invalid (null) document");
        }
        TravelDocumentBase travelDoc = (TravelDocumentBase)financialDocument;
        try {
            SourceAccountingLine newSource = (SourceAccountingLine)financialDocument.getSourceAccountingLineClass().newInstance();
            if (travelDoc.getTemProfile() != null) {
                newSource.setChartOfAccountsCode(travelDoc.getTemProfile().getDefaultChartCode());
                newSource.setAccountNumber(travelDoc.getTemProfile().getDefaultAccount());
                newSource.setSubAccountNumber(travelDoc.getTemProfile().getDefaultSubAccount());
                newSource.setSubAccountNumber(travelDoc.getTemProfile().getDefaultSubAccount());
                newSource.setProjectCode(travelDoc.getTemProfile().getDefaultProjectCode());
            }
            newSource.setFinancialObjectCode("");
            return newSource;
        }
        catch (Exception e) {
            throw new InfrastructureException("Unable to create a new travel document accounting line", e);
        }
    }

    protected Map<String, ExtraButton> createPaymentExtraButtonMap() {
        HashMap<String, ExtraButton> result = new HashMap<String, ExtraButton>();
        result.putAll(this.createDVExtraButtonMap());
        return result;
    }

    protected Map<String, ExtraButton> createDVExtraButtonMap() {
        HashMap<String, ExtraButton> result = new HashMap<String, ExtraButton>();
        ExtraButton payDVToVendorButton = new ExtraButton();
        payDVToVendorButton.setExtraButtonProperty("methodToCall.payDVToVendor");
        payDVToVendorButton.setExtraButtonSource("${externalizable.images.url}buttonsmall_vendorpayment.gif");
        payDVToVendorButton.setExtraButtonAltText("Pay DV to Vendor");
        result.put(payDVToVendorButton.getExtraButtonProperty(), payDVToVendorButton);
        return result;
    }

    protected Map<String, ExtraButton> createNewReimbursementButtonMap() {
        HashMap<String, ExtraButton> result = new HashMap<String, ExtraButton>();
        ExtraButton newReimbursementButton = new ExtraButton();
        newReimbursementButton.setExtraButtonProperty("methodToCall.newReimbursement");
        newReimbursementButton.setExtraButtonSource("${externalizable.images.url}buttonsmall_newreimbursement.png");
        newReimbursementButton.setExtraButtonAltText("New Reimbursement");
        result.put(newReimbursementButton.getExtraButtonProperty(), newReimbursementButton);
        return result;
    }

    @Override
    public List<ActualExpense> getNewActualExpenseLines() {
        if (this.newActualExpenseLines == null) {
            this.newActualExpenseLines = new ArrayList<ActualExpense>();
            for (int i = 0; i < this.getTravelDocument().getActualExpenses().size(); ++i) {
                this.newActualExpenseLines.add(new ActualExpense());
            }
        }
        return this.newActualExpenseLines;
    }

    @Override
    public void setNewActualExpenseLines(List<ActualExpense> newActualExpenseLines) {
        this.newActualExpenseLines = newActualExpenseLines;
    }

    @Override
    public ActualExpense getNewActualExpenseLine() {
        return this.newActualExpenseLine;
    }

    @Override
    public void setNewActualExpenseLine(ActualExpense newActualExpenseLine) {
        this.newActualExpenseLine = newActualExpenseLine;
    }

    @Override
    public List<ImportedExpense> getNewImportedExpenseLines() {
        if (this.newImportedExpenseLines == null) {
            this.newImportedExpenseLines = new ArrayList<ImportedExpense>();
            for (int i = 0; i < this.getTravelDocument().getImportedExpenses().size(); ++i) {
                this.newImportedExpenseLines.add(new ImportedExpense());
            }
        }
        return this.newImportedExpenseLines;
    }

    @Override
    public void setNewImportedExpenseLines(List<ImportedExpense> newImportedExpenseLines) {
        this.newImportedExpenseLines = newImportedExpenseLines;
    }

    @Override
    public ImportedExpense getNewImportedExpenseLine() {
        return this.newImportedExpenseLine;
    }

    @Override
    public void setNewImportedExpenseLine(ImportedExpense newImportedExpenseLine) {
        this.newImportedExpenseLine = newImportedExpenseLine;
    }

    @Override
    public AccountingDocumentRelationship getNewAccountingDocumentRelationship() {
        return this.newAccountingDocumentRelationship;
    }

    @Override
    public void setNewAccountingDocumentRelationship(AccountingDocumentRelationship newAccountingDocumentRelationship) {
        this.newAccountingDocumentRelationship = newAccountingDocumentRelationship;
    }

    public GroupTraveler getNewGroupTravelerLine() {
        return this.newGroupTravelerLine;
    }

    public void setNewGroupTravelerLine(GroupTraveler newGroupTravelerLine) {
        this.newGroupTravelerLine = newGroupTravelerLine;
    }

    public FormFile getGroupTravelerImportFile() {
        return this.groupTravelerImportFile;
    }

    public void setGroupTravelerImportFile(FormFile groupTravelerImportFile) {
        this.groupTravelerImportFile = groupTravelerImportFile;
    }

    @Override
    public Integer getAccountDistributionnextSourceLineNumber() {
        return this.accountDistributionnextSourceLineNumber;
    }

    @Override
    public void setAccountDistributionnextSourceLineNumber(Integer accountDistributionnextSourceLineNumber) {
        this.accountDistributionnextSourceLineNumber = accountDistributionnextSourceLineNumber;
    }

    @Override
    public TemDistributionAccountingLine getAccountDistributionnewSourceLine() {
        return this.accountDistributionnewSourceLine;
    }

    @Override
    public void setAccountDistributionnewSourceLine(TemDistributionAccountingLine accountDistributionnewSourceLine) {
        this.accountDistributionnewSourceLine = accountDistributionnewSourceLine;
    }

    @Override
    public void addAccountDistributionsourceAccountingLine(TemDistributionAccountingLine line) {
        line.setSequenceNumber(this.getAccountDistributionnextSourceLineNumber());
        this.getAccountDistributionsourceAccountingLines().add(line);
        this.accountDistributionnextSourceLineNumber = new Integer(this.getAccountDistributionnextSourceLineNumber() + 1);
        this.setAccountDistributionnewSourceLine(this.setupNewAccountDistributionAccountingLine());
    }

    @Override
    public void setDistribution(List<AccountingDistribution> distribution) {
        if (!this.getDistribution().isEmpty() && this.distribution != null && !this.distribution.isEmpty()) {
            HashMap<AccountingLineDistributionKey, AccountingDistribution> distributionMap = new HashMap<AccountingLineDistributionKey, AccountingDistribution>();
            for (AccountingDistribution accountDistribution : this.distribution) {
                distributionMap.put(new AccountingLineDistributionKey(accountDistribution.getObjectCode(), accountDistribution.getCardType()), accountDistribution);
            }
            for (AccountingDistribution accountDistribution : distribution) {
                AccountingLineDistributionKey key = new AccountingLineDistributionKey(accountDistribution.getObjectCode(), accountDistribution.getCardType());
                if (!distributionMap.containsKey(key)) continue;
                accountDistribution.setSelected(((AccountingDistribution)distributionMap.get(key)).getSelected());
            }
        }
        this.distribution = distribution;
    }

    @Override
    public List<AccountingDistribution> getDistribution() {
        if (this.distribution == null) {
            this.distribution = new ArrayList<AccountingDistribution>();
        }
        return this.distribution;
    }

    public Boolean getHasSelectedDistributionRemainingAmount() {
        return KualiDecimal.ZERO.isLessThan((AbstractKualiDecimal)this.getSelectedDistributionRemainingAmount());
    }

    public KualiDecimal getSelectedDistributionRemainingAmount() {
        return this.getDistributionRemainingAmount(true);
    }

    public KualiDecimal getSelectedDistributionSubTotal() {
        return this.getDistributionSubTotal(true);
    }

    public KualiDecimal getFullDistributionRemainingAmount() {
        KualiDecimal total = KualiDecimal.ZERO;
        for (AccountingDistribution accountDistribution : this.distribution) {
            total = (KualiDecimal)total.add((AbstractKualiDecimal)accountDistribution.getRemainingAmount());
        }
        return total;
    }

    public KualiDecimal getFullDistributionSubTotal() {
        KualiDecimal total = KualiDecimal.ZERO;
        for (AccountingDistribution accountDistribution : this.distribution) {
            total = (KualiDecimal)total.add((AbstractKualiDecimal)accountDistribution.getRemainingAmount());
        }
        return total;
    }

    @Override
    public KualiDecimal getDistributionRemainingAmount(boolean selectedDistributions) {
        KualiDecimal total = KualiDecimal.ZERO;
        KualiDecimal distributedTotal = KualiDecimal.ZERO;
        for (AccountingDistribution accountDistribution : this.distribution) {
            if ((!selectedDistributions || !accountDistribution.getSelected().booleanValue()) && selectedDistributions) continue;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)accountDistribution.getRemainingAmount());
            distributedTotal = (KualiDecimal)distributedTotal.add(accountDistribution.getSubTotal().subtract((AbstractKualiDecimal)accountDistribution.getRemainingAmount()));
        }
        if (this.getTravelDocument().getExpenseLimit() != null && this.getTravelDocument().getExpenseLimit().isPositive()) {
            if (distributedTotal.isGreaterEqual((AbstractKualiDecimal)this.getTravelDocument().getExpenseLimit())) {
                return KualiDecimal.ZERO;
            }
            if (total.isLessEqual((AbstractKualiDecimal)this.getTravelDocument().getExpenseLimit())) {
                return total;
            }
            return (KualiDecimal)this.getTravelDocument().getExpenseLimit().subtract((AbstractKualiDecimal)distributedTotal);
        }
        return total;
    }

    @Override
    public KualiDecimal getDistributionSubTotal(boolean selectedDistributions) {
        KualiDecimal total = KualiDecimal.ZERO;
        for (AccountingDistribution accountDistribution : this.distribution) {
            if ((!selectedDistributions || !accountDistribution.getSelected().booleanValue()) && selectedDistributions) continue;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)accountDistribution.getSubTotal());
        }
        return total;
    }

    public boolean getIsTravelAuthorizationDoc() {
        return this.getTravelDocument().isTravelAuthorizationDoc();
    }

    public FormFile getAccountDistributionFile() {
        return this.accountDistributionFile;
    }

    public void setAccountDistributionFile(FormFile accountDistributionFile) {
        this.accountDistributionFile = accountDistributionFile;
    }

    public String getUploadParserInstructionsUrl() {
        return ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("externalizable.help.url") + ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "UPLOAD_PARSER_INSTRUCTIONS_URL");
    }

    public String getLookupResultsSequenceNumber() {
        return this.lookupResultsSequenceNumber;
    }

    public void setLookupResultsSequenceNumber(String lookupResultsSequenceNumber) {
        this.lookupResultsSequenceNumber = lookupResultsSequenceNumber;
    }

    public String getLookupResultsBOClassName() {
        return this.lookupResultsBOClassName;
    }

    public void setLookupResultsBOClassName(String lookupResultsBOClassName) {
        this.lookupResultsBOClassName = lookupResultsBOClassName;
    }

    public String getLookedUpCollectionName() {
        return this.lookedUpCollectionName;
    }

    public void setLookedUpCollectionName(String lookedUpCollectionName) {
        this.lookedUpCollectionName = lookedUpCollectionName;
    }

    public boolean isDefaultOpenPaymentInfoTab() {
        boolean initiated = this.getTravelDocument().getDocumentHeader().getWorkflowDocument().isInitiated();
        boolean saved = this.getTravelDocument().getDocumentHeader().getWorkflowDocument().isSaved();
        return initiated || saved;
    }

    @Override
    public List<TemDistributionAccountingLine> getAccountDistributionsourceAccountingLines() {
        return this.accountDistributionsourceAccountingLines;
    }

    @Override
    public void setAccountDistributionsourceAccountingLines(List<TemDistributionAccountingLine> accountDistributionsourceAccountingLines) {
        this.accountDistributionsourceAccountingLines = accountDistributionsourceAccountingLines;
    }

    public boolean isDisplayNonEmployeeForm() {
        return this.displayNonEmployeeForm;
    }

    public void setDisplayNonEmployeeForm(boolean displayNonEmployeeForm) {
        this.displayNonEmployeeForm = displayNonEmployeeForm;
    }

    public boolean isOpenPaymentInformationWindow() {
        return this.openPaymentInformationWindow;
    }

    public void setOpenPaymentInformationWindow(boolean openPaymentInformationWindow) {
        this.openPaymentInformationWindow = openPaymentInformationWindow;
    }

    public String getWireChargeMessage() {
        return this.wireChargeMessage;
    }

    public void setWireChargeMessage(String wireChargeMessage) {
        this.wireChargeMessage = wireChargeMessage;
    }

    public abstract String getTravelPaymentFormAction();

    public String getDisbursementInfoUrl() {
        PaymentSourceHelperService paymentSourceHelperService = (PaymentSourceHelperService)SpringContext.getBean(PaymentSourceHelperService.class);
        return paymentSourceHelperService.getDisbursementInfoUrl();
    }

    public String getForeignCurrencyUrl() {
        return this.foreignCurrencyUrl;
    }

    public void setForeignCurrencyUrl(String foreignCurrencyUrl) {
        this.foreignCurrencyUrl = foreignCurrencyUrl;
    }

    public String getDefaultPerDiemMileageExpenseType() {
        if (StringUtils.isBlank((String)this.defaultPerDiemMileageExpenseType)) {
            this.defaultPerDiemMileageExpenseType = this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "PER_DIEM_MILEAGE_RATE_EXPENSE_TYPE_CODE", "");
        }
        return this.defaultPerDiemMileageExpenseType;
    }

    public boolean isPerDiemCreatable() {
        return this.perDiemCreatable;
    }

    public void setPerDiemCreatable(boolean perDiemCreatable) {
        this.perDiemCreatable = perDiemCreatable;
    }

    public List<LinkField> getAgencyLinks() {
        return this.agencyLinks;
    }

    public void setAgencyLinks(List<LinkField> agencyLinks) {
        this.agencyLinks = agencyLinks;
    }

    public boolean isShouldDisplayAgencyLinks() {
        return this.shouldDisplayAgencyLinks;
    }

    public void setShouldDisplayAgencyLinks(boolean shouldDisplayAgencyLinks) {
        this.shouldDisplayAgencyLinks = shouldDisplayAgencyLinks;
    }
}

