/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.fp.document.DisbursementVoucherDocument;
import org.kuali.kfs.fp.document.web.struts.DisbursementVoucherForm;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.tem.businessobject.AccountingDistribution;
import org.kuali.kfs.module.tem.businessobject.AccountingDocumentRelationship;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelRelocationDocument;
import org.kuali.kfs.module.tem.document.authorization.TravelRelocationAuthorizer;
import org.kuali.kfs.module.tem.document.service.TravelRelocationService;
import org.kuali.kfs.module.tem.document.web.bean.TravelRelocationMvcWrapperBean;
import org.kuali.kfs.module.tem.document.web.struts.TravelActionBase;
import org.kuali.kfs.module.tem.document.web.struts.TravelFormBase;
import org.kuali.kfs.module.tem.document.web.struts.TravelRelocationForm;
import org.kuali.kfs.module.tem.pdf.Coversheet;
import org.kuali.kfs.module.tem.report.ExpenseSummaryReport;
import org.kuali.kfs.module.tem.report.NonEmployeeCertificationReport;
import org.kuali.kfs.module.tem.report.SummaryByDayReport;
import org.kuali.kfs.module.tem.report.service.ExpenseSummaryReportService;
import org.kuali.kfs.module.tem.report.service.NonEmployeeCertificationReportService;
import org.kuali.kfs.module.tem.report.service.SummaryByDayReportService;
import org.kuali.kfs.module.tem.report.util.BarcodeHelper;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.report.ReportInfo;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class TravelRelocationAction
extends TravelActionBase {
    public static Logger LOG = Logger.getLogger(TravelRelocationAction.class);
    private static final String[] reloMethodToCallExclusionArray = new String[]{"recalculate", "calculate", "recalculateTripDetailTotal"};

    @Override
    protected void loadDocument(KualiDocumentFormBase form) throws WorkflowException {
        super.loadDocument(form);
        TravelRelocationForm reloForm = (TravelRelocationForm)form;
        TravelRelocationDocument document = reloForm.getTravelRelocationDocument();
        this.refreshCollectionsFor(document);
        reloForm.setDistribution(this.getAccountingDistributionService().buildDistributionFrom(reloForm.getTravelDocument()));
        this.initializeAssignAccounts(reloForm);
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward retval = super.execute(mapping, form, request, response);
        TravelRelocationForm reloForm = (TravelRelocationForm)form;
        TravelRelocationDocument document = ((TravelRelocationForm)form).getTravelRelocationDocument();
        String travelIdentifier = document.getTravelDocumentIdentifier();
        this.setButtonPermissions(reloForm);
        this.setContactMasking(reloForm);
        this.setTaxSelectable(reloForm);
        if (document.getTraveler() != null && document.getTraveler().getPrincipalId() != null) {
            document.getTraveler().setPrincipalName(this.getPersonService().getPerson(document.getTraveler().getPrincipalId()).getPrincipalName());
        }
        if (ObjectUtils.isNotNull(document.getActualExpenses())) {
            document.enableExpenseTypeSpecificFields(document.getActualExpenses());
        }
        this.refreshRelatedDocuments(reloForm);
        if (!reloForm.getMethodToCall().equalsIgnoreCase("dochandler")) {
            if (!this.getCalculateIgnoreList().contains(reloForm.getMethodToCall())) {
                this.recalculateTripDetailTotalOnly(mapping, form, request, response);
            }
            KualiDecimal totalRemaining = KualiDecimal.ZERO;
            for (AccountingDistribution dist : reloForm.getDistribution()) {
                totalRemaining = (KualiDecimal)totalRemaining.add((AbstractKualiDecimal)dist.getRemainingAmount());
            }
            request.setAttribute("remainingDistribution", (Object)totalRemaining);
        }
        this.showAccountDistribution(request, (Document)document);
        request.setAttribute("showReports", (Object)(!document.getDocumentHeader().getWorkflowDocument().isInitiated() ? 1 : 0));
        KualiDecimal paymentTotal = document.getPaymentAmount();
        if (paymentTotal != null && !ObjectUtils.isNull((Object)((Object)document.getTravelPayment()))) {
            document.getTravelPayment().setCheckTotalAmount(paymentTotal);
        }
        if (reloForm.getAccountDistributionsourceAccountingLines() == null || reloForm.getAccountDistributionsourceAccountingLines().isEmpty()) {
            this.initializeAssignAccounts(reloForm);
        }
        return retval;
    }

    protected void setContactMasking(TravelRelocationForm reloForm) {
        reloForm.setCanUnmask(reloForm.isUserDocumentInitiator());
    }

    protected void setButtonPermissions(TravelRelocationForm form) {
        TravelRelocationAuthorizer authorizer = (TravelRelocationAuthorizer)this.getDocumentAuthorizer((KualiDocumentFormBase)form);
        form.setCanCertify(authorizer.canCertify(form.getTravelRelocationDocument(), GlobalVariables.getUserSession().getPerson()));
        this.setCanCalculate(form);
    }

    protected void setTaxSelectable(TravelRelocationForm form) {
        TravelRelocationAuthorizer authorizer = (TravelRelocationAuthorizer)this.getDocumentAuthorizer((KualiDocumentFormBase)form);
        form.getTravelRelocationDocument().setTaxSelectable(authorizer.canTaxSelectable(GlobalVariables.getUserSession().getPerson()));
    }

    protected Class getMvcWrapperInterface() {
        return TravelRelocationMvcWrapperBean.class;
    }

    @Override
    protected void createDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.createDocument(kualiDocumentFormBase);
        TravelRelocationForm travelForm = (TravelRelocationForm)kualiDocumentFormBase;
        TravelRelocationDocument document = (TravelRelocationDocument)travelForm.getDocument();
        this.getTravelRelocationService().addListenersTo(document);
        if (!StringUtils.isBlank((String)travelForm.getTravelDocumentIdentifier())) {
            LOG.debug((Object)("Creating relocation for document number " + travelForm.getTravelDocumentIdentifier()));
            TravelRelocationDocument oldRelocation = this.getTravelRelocation(travelForm.getTravelDocumentIdentifier());
            if (oldRelocation != null) {
                LOG.debug((Object)("Setting traveler with id " + oldRelocation.getTravelerDetailId()));
                document.setTravelerDetailId(oldRelocation.getTravelerDetailId());
                document.refreshReferenceObject("traveler");
                LOG.debug((Object)("Traveler is " + (Object)((Object)document.getTraveler()) + " with customer number " + document.getTraveler().getCustomerNumber()));
                if (document.getTraveler().getPrincipalId() != null) {
                    document.getTraveler().setPrincipalName(this.getPersonService().getPerson(document.getTraveler().getPrincipalId()).getPrincipalName());
                }
                document.setProfileId(oldRelocation.getTemProfileId());
                document.updatePayeeTypeForReimbursable();
                document.setTripDescription(oldRelocation.getTripDescription());
                document.setPrimaryDestinationName(oldRelocation.getPrimaryDestinationName());
                document.setTripBegin(oldRelocation.getTripBegin());
                document.setTripEnd(oldRelocation.getTripEnd());
                document.setJobClsCode(oldRelocation.getJobClsCode());
                document.setReasonCode(oldRelocation.getReasonCode());
                document.setFromAddress1(oldRelocation.getFromAddress1());
                document.setFromAddress2(oldRelocation.getFromAddress2());
                document.setFromCity(oldRelocation.getFromCity());
                document.setFromCountryCode(oldRelocation.getFromCountryCode());
                document.setFromStateCode(oldRelocation.getFromStateCode());
                document.setToAddress1(oldRelocation.getToAddress1());
                document.setToAddress2(oldRelocation.getToAddress2());
                document.setToCity(oldRelocation.getToCity());
                document.setToCountryCode(oldRelocation.getToCountryCode());
                document.setToStateCode(oldRelocation.getToStateCode());
                document.setTravelDocumentIdentifier(oldRelocation.getTravelDocumentIdentifier());
                document.getDocumentHeader().setOrganizationDocumentNumber(oldRelocation.getDocumentHeader().getOrganizationDocumentNumber());
                AccountingDocumentRelationship relationship = this.buildRelationshipToProgenitorDocument(oldRelocation, document);
                this.getBusinessObjectService().save((PersistableBusinessObject)relationship);
                List notes = this.getNoteService().getByRemoteObjectId(oldRelocation.getNoteTarget().getObjectId());
                document.setNotes(notes);
            }
        } else {
            document.setTripProgenitor(true);
        }
        this.initializeAssignAccounts(travelForm);
    }

    protected void createDVDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        Document doc = this.getDocumentService().getNewDocument(kualiDocumentFormBase.getDocTypeName());
        kualiDocumentFormBase.setDocument(doc);
        kualiDocumentFormBase.setDocTypeName(doc.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
        ((DisbursementVoucherDocument)kualiDocumentFormBase.getDocument()).initiateDocument();
        ((DisbursementVoucherForm)kualiDocumentFormBase).setWireChargeMessage(this.retrieveWireChargeMessage());
    }

    @Override
    protected void performRequesterRefresh(TravelDocument document, TravelFormBase travelForm, HttpServletRequest request) {
        ((TravelRelocationDocument)document).updatePayeeTypeForReimbursable();
        this.updateAccountsWithNewProfile(travelForm, document.getTemProfile());
    }

    protected TravelRelocationService getTravelRelocationService() {
        return (TravelRelocationService)SpringContext.getBean(TravelRelocationService.class);
    }

    public ActionForward recalculate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.recalculateTripDetailTotal(mapping, form, request, response);
    }

    protected void refreshCollectionsFor(TravelRelocationDocument relocation) {
        if (!relocation.getDocumentHeader().getWorkflowDocument().isInitiated()) {
            LOG.debug((Object)"Refreshing objects in relocation");
            relocation.refreshReferenceObject("traveler");
            relocation.refreshReferenceObject("actualExpenses");
            relocation.refreshReferenceObject("specialCircumstances");
        }
    }

    protected TravelRelocationDocument getTravelRelocation(String travelDocumentIdentifier) {
        Collection<TravelRelocationDocument> reloList = this.getTravelRelocationService().findByIdentifier(travelDocumentIdentifier);
        if (ObjectUtils.isNotNull(reloList) && reloList.iterator().hasNext()) {
            return reloList.iterator().next();
        }
        return null;
    }

    public ActionForward viewExpenseSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelRelocationForm reloForm = (TravelRelocationForm)form;
        reloForm.setDocument((Document)this.getTravelRelocationService().find(request.getParameter("documentNumber")));
        TravelRelocationDocument relocation = reloForm.getTravelRelocationDocument();
        ExpenseSummaryReport report = this.getExpenseSummaryReportService().buildReport(relocation);
        report.setReportTitle("Moving and Relocation");
        ByteArrayOutputStream baos = this.getTravelReportService().buildReport((ReportInfo)report);
        WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)baos, (String)String.format("%s_Expense_Summary", relocation.getTravelDocumentIdentifier()));
        return null;
    }

    public ActionForward viewSummaryByDay(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelRelocationForm reloForm = (TravelRelocationForm)form;
        reloForm.setDocument((Document)this.getTravelRelocationService().find(request.getParameter("documentNumber")));
        TravelRelocationDocument relocation = reloForm.getTravelRelocationDocument();
        SummaryByDayReport report = this.getSummaryByDayReportService().buildReport(relocation);
        ByteArrayOutputStream baos = this.getTravelReportService().buildReport((ReportInfo)report);
        WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)baos, (String)String.format("%s_Summary_By_Day", relocation.getTravelDocumentIdentifier()));
        return null;
    }

    public ActionForward printCoversheet(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelRelocationForm reloForm = (TravelRelocationForm)form;
        String documentNumber = request.getParameter("documentNumber");
        if (documentNumber != null && !documentNumber.isEmpty()) {
            reloForm.setDocument((Document)this.getTravelRelocationService().find(documentNumber));
        }
        TravelRelocationDocument relocation = reloForm.getTravelRelocationDocument();
        Coversheet cover = this.getTravelRelocationService().generateCoversheetFor(relocation);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        cover.print(stream);
        WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)stream, (String)String.format("%s_cover_sheet.pdf", relocation.getTravelDocumentIdentifier()));
        return null;
    }

    public ActionForward viewNonEmployeeForms(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelRelocationForm reloForm = (TravelRelocationForm)form;
        reloForm.setDocument((Document)this.getTravelRelocationService().find(request.getParameter("documentNumber")));
        TravelRelocationDocument relocation = reloForm.getTravelRelocationDocument();
        NonEmployeeCertificationReport report = this.getNonEmployeeCertificationReportService().buildReport(relocation);
        BarcodeHelper barcode = new BarcodeHelper();
        report.setBarcodeImage(barcode.generateBarcodeImage(relocation.getDocumentNumber()));
        File reportFile = this.getNonEmployeeCertificationReportService().generateReport(report);
        StringBuilder fileName = new StringBuilder();
        fileName.append(relocation.getTravelDocumentIdentifier());
        fileName.append("_Non_Employee_Certification");
        fileName.append(".pdf");
        if (reportFile.length() == 0L) {
            return mapping.findForward("basic");
        }
        this.displayPDF(request, response, reportFile, fileName);
        return null;
    }

    public ActionForward newRelocation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelRelocationDocument reloDoc = ((TravelRelocationForm)form).getTravelRelocationDocument();
        String url = this.buildNewRelocationUrl(reloDoc);
        return new ActionForward(url, true);
    }

    protected String buildNewRelocationUrl(TravelRelocationDocument travelRelo) {
        Properties props = new Properties();
        props.put("travelDocumentIdentifier", travelRelo.getTravelDocumentIdentifier());
        props.put("docTypeName", "RELO");
        props.put("command", "initiate");
        String docUrlBase = this.getResolvedUrlForDocumentType("RELO");
        String url = UrlFactory.parameterizeUrl((String)docUrlBase, (Properties)props);
        return url;
    }

    protected NonEmployeeCertificationReportService getNonEmployeeCertificationReportService() {
        return (NonEmployeeCertificationReportService)SpringContext.getBean(NonEmployeeCertificationReportService.class);
    }

    protected ExpenseSummaryReportService getExpenseSummaryReportService() {
        return (ExpenseSummaryReportService)SpringContext.getBean(ExpenseSummaryReportService.class);
    }

    protected SummaryByDayReportService getSummaryByDayReportService() {
        return (SummaryByDayReportService)SpringContext.getBean(SummaryByDayReportService.class);
    }

    @Override
    protected List<String> getCalculateIgnoreList() {
        return Arrays.asList(reloMethodToCallExclusionArray);
    }
}

