/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.businessobject.GroupTraveler;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.validation.event.AddGroupTravelLineEvent;
import org.kuali.kfs.module.tem.document.web.bean.TravelMvcWrapperBean;

public class UploadGroupTravelersEvent
implements Observer {
    public static Logger LOG = Logger.getLogger(UploadGroupTravelersEvent.class);
    private static final int WRAPPER_ARG_IDX = 0;
    private static final int FILE_CONTENTS_ARG_IDX = 1;
    protected TravelDocumentService travelDocumentService;
    protected KualiRuleService ruleService;

    @Override
    public void update(Observable arg0, Object arg1) {
        if (!(arg1 instanceof Object[])) {
            return;
        }
        Object[] args = (Object[])arg1;
        LOG.debug(args[0]);
        if (!(args[0] instanceof TravelMvcWrapperBean)) {
            return;
        }
        TravelMvcWrapperBean wrapper = (TravelMvcWrapperBean)args[0];
        String fileContents = (String)args[1];
        TravelDocument document = wrapper.getTravelDocument();
        String tabErrorKey = "groupTraveler";
        try {
            List<GroupTraveler> importedGroupTravelers = this.getTravelDocumentService().importGroupTravelers(document, fileContents);
            boolean allPassed = true;
            boolean itemLineNumber = false;
            for (GroupTraveler traveler : importedGroupTravelers) {
                AddGroupTravelLineEvent event = new AddGroupTravelLineEvent("newGroupTravelerLine", (Document)document, traveler);
                allPassed &= this.getRuleService().applyRules((KualiDocumentEvent)event);
            }
            if (allPassed) {
                for (GroupTraveler traveler : importedGroupTravelers) {
                    document.addGroupTravelerLine(traveler);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            GlobalVariables.getMessageMap().putError("groupTraveler", "error.uploadFile.null", new String[0]);
        }
    }

    public TravelDocumentService getTravelDocumentService() {
        return this.travelDocumentService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }

    public KualiRuleService getRuleService() {
        return this.ruleService;
    }

    public void setRuleService(KualiRuleService ruleService) {
        this.ruleService = ruleService;
    }
}

