/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.report.service.impl;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TravelerDetail;
import org.kuali.kfs.module.tem.document.TravelEntertainmentDocument;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.report.EntertainmentHostCertificationReport;
import org.kuali.kfs.module.tem.report.NonEmployeeCertificationReport;
import org.kuali.kfs.module.tem.report.service.TravelEntertainmentHostCertificationService;
import org.kuali.kfs.module.tem.service.TemProfileService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.report.ReportInfo;
import org.kuali.kfs.sys.service.ReportGenerationService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.api.identity.PersonService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class TravelEntertainmentHostCertificationServiceImpl
implements TravelEntertainmentHostCertificationService {
    public static Logger LOG = Logger.getLogger(TravelEntertainmentHostCertificationServiceImpl.class);
    protected ConfigurationService configurationService;
    protected ParameterService parameterService;
    protected PersonService personService;
    protected TravelDocumentService travelDocumentService;
    protected ReportInfo entReportInfo;
    protected TemProfileService temProfileService;

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService ConfigurationService2) {
        this.configurationService = ConfigurationService2;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    @Override
    public EntertainmentHostCertificationReport buildReport(TravelEntertainmentDocument document) {
        EntertainmentHostCertificationReport report = new EntertainmentHostCertificationReport();
        report.setTripId(document.getTravelDocumentIdentifier().toString());
        report.setPurpose(ObjectUtils.isNull((Object)((Object)document.getPurpose())) ? "" : document.getPurpose().getPurposeDescription());
        report.setInstitution(this.getParameterService().getParameterValueAsString(KfsParameterConstants.FINANCIAL_SYSTEM_ALL.class, "INSTITUTION_NAME"));
        report.setTemFaxNumber(this.getParameterService().getParameterValueAsString(TravelReimbursementDocument.class, "FAX_NUMBER"));
        report.setDocumentId(document.getDocumentNumber());
        report.setBeginDate(document.getTripBegin());
        report.setEndDate(document.getTripEnd());
        report.setEventId(document.getTravelDocumentIdentifier());
        report.setEventTitle(document.getEventTitle());
        report.setTotalExpense(document.getDocumentGrandTotal());
        report.setCertificationDescription(this.getTravelDocumentService().getMessageFrom("tem.entertainment.host.certification", report.getInstitution()));
        report.setEntertainmentHostName(document.getHostName());
        if (!ObjectUtils.isNull((Object)((Object)document.getTraveler()))) {
            report.setEmployeeName(document.getTraveler().getFirstName() + " " + document.getTraveler().getLastName());
        }
        report.setApprovingDepartment(this.getApprovingDepartment(document.getTraveler()));
        ArrayList<NonEmployeeCertificationReport.Detail> expenseDetails = new ArrayList<NonEmployeeCertificationReport.Detail>();
        HashMap<String, KualiDecimal> summaryData = new HashMap<String, KualiDecimal>();
        if (document.getActualExpenses().size() > 0) {
            for (ActualExpense expense : document.getActualExpenses()) {
                expense.refreshReferenceObject("expenseTypeObjectCode");
                String expenseDate = new SimpleDateFormat("MM/dd/yyyy").format(expense.getExpenseDate());
                NonEmployeeCertificationReport.Detail detail = new NonEmployeeCertificationReport.Detail(expense.getExpenseTypeObjectCode().getExpenseType().getName() == null ? "" : expense.getExpenseTypeObjectCode().getExpenseType().getName(), new KualiDecimal(expense.getExpenseAmount().bigDecimalValue().multiply(expense.getCurrencyRate())), expenseDate);
                expenseDetails.add(detail);
                this.incrementSummary(summaryData, expense);
            }
        } else {
            expenseDetails.add(new NonEmployeeCertificationReport.Detail("", null, ""));
        }
        report.setExpenseDetails(expenseDetails);
        return report;
    }

    public String getApprovingDepartment(TravelerDetail traveler) {
        String approvingDepartment = "";
        if (ObjectUtils.isNotNull((Object)((Object)traveler)) && ObjectUtils.isNotNull((Object)traveler.getPrincipalId())) {
            TemProfile profile = this.getTemProfileService().findTemProfileByPrincipalId(traveler.getPrincipalId());
            if (ObjectUtils.isNotNull((Object)((Object)profile)) && ObjectUtils.isNotNull((Object)profile.getHomeDepartment())) {
                approvingDepartment = profile.getHomeDepartment();
            }
        } else if (ObjectUtils.isNotNull((Object)((Object)traveler))) {
            HashMap<String, String> criteria = new HashMap<String, String>();
            criteria.put("firstName", traveler.getFirstName());
            criteria.put("lastName", traveler.getLastName());
            TemProfile profile = this.getTemProfileService().findTemProfile(criteria);
            if (ObjectUtils.isNotNull((Object)((Object)profile)) && ObjectUtils.isNotNull((Object)profile.getHomeDepartment())) {
                approvingDepartment = profile.getHomeDepartment();
            }
        }
        return approvingDepartment;
    }

    protected void incrementSummary(Map<String, KualiDecimal> summaryData, ActualExpense expense) {
        String expenseDate = new SimpleDateFormat("MM/dd/yyyy").format(expense.getExpenseDate());
        KualiDecimal summaryAmount = summaryData.get(expenseDate);
        if (summaryAmount == null) {
            summaryAmount = KualiDecimal.ZERO;
        }
        summaryAmount = (KualiDecimal)summaryAmount.add((AbstractKualiDecimal)new KualiDecimal(expense.getExpenseAmount().bigDecimalValue().multiply(expense.getCurrencyRate())));
        LOG.debug((Object)("Adding " + summaryAmount + " for " + expenseDate + " to summary data"));
        summaryData.put(expenseDate, summaryAmount);
    }

    protected boolean isTransportationExpense(ActualExpense expense) {
        LOG.debug((Object)("Checking if " + expense + " is a transportation "));
        return this.expenseTypeCodeMatchesParameter(expense.getExpenseTypeCode(), "TRANSPORTATION_TYPE_CODES");
    }

    protected boolean isMealsExpense(ActualExpense expense) {
        return this.getTravelDocumentService().isHostedMeal(expense);
    }

    protected boolean isLodgingExpense(ActualExpense expense) {
        LOG.debug((Object)("Checking if " + expense + " is a lodging "));
        return this.expenseTypeCodeMatchesParameter(expense.getExpenseTypeCode(), "LODGING_TYPE_CODES");
    }

    protected boolean expenseTypeCodeMatchesParameter(String expenseTypeCode, String parameter) {
        return this.getParameterService().getParameterValuesAsString(TravelReimbursementDocument.class, parameter).contains(expenseTypeCode);
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public TravelDocumentService getTravelDocumentService() {
        return this.travelDocumentService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }

    @Override
    public File generateEntertainmentHostCertReport(EntertainmentHostCertificationReport report) {
        String reportFileName = this.entReportInfo.getReportFileName();
        String reportDirectory = this.entReportInfo.getReportsDirectory();
        String reportTemplateClassPath = this.entReportInfo.getReportTemplateClassPath();
        String reportTemplateName = this.entReportInfo.getReportTemplateName();
        HashMap<String, EntertainmentHostCertificationReport> reportData = new HashMap<String, EntertainmentHostCertificationReport>();
        reportData.put("report", report);
        String template = reportTemplateClassPath + reportTemplateName;
        String fullReportFileName = this.getReportGenerationService().buildFullFileName(new Date(), reportDirectory, reportFileName, "");
        this.getReportGenerationService().generateReportToPdfFile(reportData, report.getExpenseDetails(), template, fullReportFileName);
        File reportFile = new File(fullReportFileName + ".pdf");
        return reportFile;
    }

    public ReportInfo getEntReportInfo() {
        return this.entReportInfo;
    }

    public void setEntReportInfo(ReportInfo entReportInfo) {
        this.entReportInfo = entReportInfo;
    }

    protected ReportGenerationService getReportGenerationService() {
        return (ReportGenerationService)SpringContext.getBean(ReportGenerationService.class);
    }

    public TemProfileService getTemProfileService() {
        return this.temProfileService;
    }

    public void setTemProfileService(TemProfileService temProfileService) {
        this.temProfileService = temProfileService;
    }
}

