/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.report.service.impl;

import java.awt.Color;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabBucket;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabCell;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabDataset;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.base.JRBaseBoxPen;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.tem.report.RString;
import org.kuali.kfs.module.tem.report.RTextStyle;
import org.kuali.kfs.module.tem.report.annotations.ColumnFooter;
import org.kuali.kfs.module.tem.report.annotations.ColumnHeader;
import org.kuali.kfs.module.tem.report.annotations.Crosstab;
import org.kuali.kfs.module.tem.report.annotations.DetailSection;
import org.kuali.kfs.module.tem.report.annotations.Group;
import org.kuali.kfs.module.tem.report.annotations.PageFooter;
import org.kuali.kfs.module.tem.report.annotations.PageHeader;
import org.kuali.kfs.module.tem.report.annotations.Parameter;
import org.kuali.kfs.module.tem.report.annotations.SubReport;
import org.kuali.kfs.module.tem.report.annotations.Summary;
import org.kuali.kfs.module.tem.report.service.TravelReportFactoryService;
import org.kuali.kfs.sys.report.ReportInfo;

public class TravelReportFactoryServiceImpl
implements TravelReportFactoryService {
    public static Logger LOG = Logger.getLogger(TravelReportFactoryServiceImpl.class);
    private static final int MARGIN = 10;
    private static final int PAGEHEADER_HEIGHT = 25;
    private static final int REPORT_HEIGHT = 832;
    private static final int TITLE_HEIGHT = 93;
    private static final int DETAIL_HEIGHT = 739;
    private static final int SUMMARY_HEIGHT = 172;
    private static final int SUBREPORT_HEIGHT = 189;
    private static final int COLHEADER_HEIGHT = 20;
    private static final int PAGEFOOTER_HEIGHT = 17;
    private static final int COLFOOTER_HEIGHT = 16;
    private static final int CT_HEADER_WIDTH = 175;
    private static final int CELL_WIDTH = 50;
    private static final int CELL_HEIGHT = 18;
    private static final int GROUP_HEIGHT = 246;
    protected Map<String, RTextStyle> styles;

    @Override
    public RString h1(String str) {
        return this.applyStyle(str);
    }

    @Override
    public RString h2(String str) {
        return this.applyStyle(str);
    }

    @Override
    public RString h3(String str) {
        return this.applyStyle(str);
    }

    @Override
    public RString h4(String str) {
        return this.applyStyle(str);
    }

    @Override
    public RString h5(String str) {
        return this.applyStyle(str);
    }

    public RString normal(String str) {
        return this.applyStyle(str);
    }

    protected RString applyStyle(String str) {
        String styleName = new Throwable().getStackTrace()[1].getMethodName();
        return new RString(str, this.getStyles().get(styleName));
    }

    public JRBand createTitle(ReportInfo report, String title) throws Exception {
        JRDesignBand retval = new JRDesignBand();
        retval.setHeight(93);
        JRDesignTextField headerLine1 = this.h1("$P{report}.getInstitution()").toTextField();
        this.addDesignElementTo((JRDesignElementGroup)retval, (JRDesignTextElement)headerLine1, 0, 0, 356, 30);
        JRDesignStaticText headerLine2 = this.h5(title + " for # ").toStaticText();
        this.addDesignElementTo((JRDesignElementGroup)retval, (JRDesignTextElement)headerLine2, 0, 31, 426, 24);
        JRDesignTextField headerLine3 = this.h5("$P{report}.getTripId()").toTextField();
        this.addDesignElementTo((JRDesignElementGroup)retval, (JRDesignTextElement)headerLine3, 275, 31, 146, 24);
        JRDesignStaticText headerLine4 = this.h5("Purpose: ").toStaticText();
        this.addDesignElementTo((JRDesignElementGroup)retval, (JRDesignTextElement)headerLine4, 0, 52, 100, 20);
        JRDesignStaticText headerLine5 = this.h5("Dates: ").toStaticText();
        this.addDesignElementTo((JRDesignElementGroup)retval, (JRDesignTextElement)headerLine5, 0, 72, 100, 20);
        JRDesignTextField headerLine4Field1 = this.h5("$P{report}.getPurpose()").toTextField();
        this.addDesignElementTo((JRDesignElementGroup)retval, (JRDesignTextElement)headerLine4Field1, 65, 52, 472, 20);
        JRDesignTextField headerLine5Field1 = this.h5("$P{report}.getBeginDate()").toTextField(Date.class);
        this.addDesignElementTo((JRDesignElementGroup)retval, (JRDesignTextElement)headerLine5Field1, 45, 72, 75, 20);
        JRDesignTextField headerLine5Field2 = this.h5("$P{report}.getEndDate()").toTextField(Date.class);
        this.addDesignElementTo((JRDesignElementGroup)retval, (JRDesignTextElement)headerLine5Field2, 150, 72, 75, 20);
        return retval;
    }

    protected Collection<String> getCrosstabNames(ReportInfo report) {
        ArrayList<String> retval = new ArrayList<String>();
        for (Field f : report.getClass().getDeclaredFields()) {
            if (f.getAnnotation(Crosstab.class) == null) continue;
            retval.add(f.getName());
        }
        return retval;
    }

    protected Collection<String> getCrosstabNames(ReportInfo report, Class ... annotations) {
        ArrayList<String> retval = new ArrayList<String>();
        for (Field f : report.getClass().getDeclaredFields()) {
            boolean valid = false;
            valid |= f.getAnnotation(Crosstab.class) != null;
            if (annotations != null && annotations.length > 0) {
                for (Class annotation : annotations) {
                    valid &= f.getAnnotation(annotation) != null;
                }
            }
            if (!valid) continue;
            retval.add(f.getName());
        }
        return retval;
    }

    protected boolean hasSubreport(ReportInfo report) {
        return this.hasFieldWithAnnotations(report, SubReport.class);
    }

    @Override
    public boolean hasSummary(ReportInfo report) {
        return this.hasFieldWithAnnotations(report, Summary.class);
    }

    protected boolean hasDetail(ReportInfo report) {
        return this.hasFieldWithAnnotations(report, DetailSection.class) || this.hasGroup(report);
    }

    protected boolean hasPageHeader(ReportInfo report) {
        return this.hasFieldWithAnnotations(report, PageHeader.class);
    }

    protected boolean hasPageFooter(ReportInfo report) {
        return this.hasFieldWithAnnotations(report, PageFooter.class);
    }

    protected boolean hasColumnHeader(ReportInfo report) {
        return this.hasFieldWithAnnotations(report, ColumnHeader.class);
    }

    protected boolean hasColumnFooter(ReportInfo report) {
        return this.hasFieldWithAnnotations(report, ColumnFooter.class);
    }

    protected boolean hasFieldWithAnnotation(ReportInfo report, Class annotation) {
        for (Field field : report.getClass().getDeclaredFields()) {
            if (field.getAnnotation(annotation) == null) continue;
            return true;
        }
        return false;
    }

    public JRBand createDetail(Field subReport) throws Exception {
        JRDesignBand retval = new JRDesignBand();
        retval.setHeight(164);
        LOG.debug((Object)("Subreport Detail band has height of " + retval.getHeight()));
        LOG.debug((Object)("Checking if " + subReport + " is a crosstab " + this.isCrosstab(subReport)));
        if (this.isCrosstab(subReport)) {
            JRDesignCrosstab crosstab = this.createCrosstab();
            LOG.debug((Object)("Got crosstab of height " + crosstab.getHeight() + " and width " + crosstab.getWidth() + " adding to design of height " + retval.getHeight()));
            retval.addElement((JRDesignElement)crosstab);
        }
        return retval;
    }

    public JRBand createSummary(Field subReport) throws Exception {
        JRDesignBand retval = new JRDesignBand();
        retval.setHeight(189);
        LOG.debug((Object)("Summary band has height of " + retval.getHeight()));
        LOG.debug((Object)("Checking if " + subReport + " is a crosstab " + this.isCrosstab(subReport)));
        if (this.isCrosstab(subReport)) {
            JRDesignCrosstab crosstab = this.createCrosstab();
            LOG.debug((Object)("Got crosstab of height " + crosstab.getHeight() + " and width " + crosstab.getWidth() + " adding to design of height " + retval.getHeight()));
            retval.addElement((JRDesignElement)crosstab);
        }
        return retval;
    }

    protected JRBand createDetailForSummary(ReportInfo report) throws Exception {
        JRDesignBand retval = new JRDesignBand();
        int maxHeight = 739;
        LOG.debug((Object)"Summary: Initial height is 739");
        retval.setHeight(23);
        LOG.debug((Object)("Summary: Detail band has height of " + maxHeight));
        int y = 0;
        LOG.info((Object)"Summary: Adding fields for detail");
        Field summaryField = this.getFieldWithAnnotation(report, Summary.class);
        if (this.isCrosstab(summaryField)) {
            Collection<JRChild> elements = this.processFields(report, Summary.class, Crosstab.class);
            for (JRChild element : elements) {
                JRDesignCrosstab crosstab = (JRDesignCrosstab)element;
                LOG.debug((Object)("Adding crosstab to summary " + crosstab + " with height " + crosstab.getHeight()));
                crosstab.setY(y);
                retval.addElement((JRDesignElement)crosstab);
                retval.setHeight(y += crosstab.getHeight() + 25);
            }
        } else {
            JRDesignTextField nameField = this.normal("$F{name}").toTextField();
            this.addDesignElementTo((JRDesignElementGroup)retval, (JRDesignTextElement)nameField, 0, 0, 150, 18);
            JRDesignTextField amountField = this.normal("$F{amount}").toTextField(BigDecimal.class);
            this.addDesignElementTo((JRDesignElementGroup)retval, (JRDesignTextElement)amountField, 155, 0, 150, 18);
        }
        return retval;
    }

    public JRBand createDetail(ReportInfo report, Integer reportIndex) throws Exception {
        JRDesignBand retval = new JRDesignBand();
        if (!this.hasDetail(report) && !this.hasSubreport(report)) {
            LOG.info((Object)"No detail for this report");
            LOG.debug((Object)("Has detail " + this.hasDetail(report)));
            LOG.debug((Object)("Has Subreport " + this.hasSubreport(report)));
            if (reportIndex > 0) {
                return null;
            }
            retval.setHeight(0);
            return retval;
        }
        int maxHeight = 739;
        LOG.debug((Object)"Initial height is 739");
        retval.setHeight(0);
        LOG.info((Object)"Determining maximum detail space size");
        if (this.hasPageHeader(report)) {
            maxHeight -= 25;
        }
        if (this.hasPageFooter(report)) {
            maxHeight -= 17;
        }
        if (this.hasColumnHeader(report)) {
            maxHeight -= 20;
        }
        if (this.hasColumnFooter(report)) {
            maxHeight -= 16;
        }
        LOG.debug((Object)("Detail band has height of " + maxHeight));
        if (this.hasDetail(report)) {
            LOG.info((Object)"Adding fields for detail");
            JRDesignTextField nameField = this.normal("$F{name}").toTextField();
            this.addDesignElementTo((JRDesignElementGroup)retval, (JRDesignTextElement)nameField, 0, 0, 150, 18);
            JRDesignTextField dateField = this.normal("$F{date}").toTextField();
            this.addDesignElementTo((JRDesignElementGroup)retval, (JRDesignTextElement)dateField, 155, 0, 150, 18);
            JRDesignTextField amountField = this.normal("$F{amount}").toTextField(BigDecimal.class);
            this.addDesignElementTo((JRDesignElementGroup)retval, (JRDesignTextElement)amountField, 310, 0, 150, 18);
        }
        int y = 0;
        int pageidx = 0;
        int upperBound = 19;
        Collection<JRChild> elements = this.processFields(report, SubReport.class);
        LOG.debug((Object)("Building report detail starting at position " + y));
        LOG.debug((Object)("Adding " + elements.size() + " elements to the report"));
        for (JRChild obj : elements) {
            if (obj == null || !(obj instanceof JRDesignElement)) continue;
            JRDesignElement element = (JRDesignElement)obj;
            if (y + element.getHeight() >= maxHeight) {
                ++pageidx;
                y = 0;
            }
            if (element instanceof JRDesignCrosstab) {
                JRDesignCrosstab crosstab = (JRDesignCrosstab)element;
                String crosstabName = crosstab.getDataset().getDatasetRun().getDatasetName();
                JRDesignStaticText headerLine4 = this.h4(crosstabName).toStaticText();
                if (pageidx == reportIndex) {
                    this.addDesignElementTo((JRDesignElementGroup)retval, (JRDesignTextElement)headerLine4, 0, y, 356, 22);
                }
                y += 25;
            }
            LOG.debug((Object)("Adding element to detail " + element.getClass() + " " + element + " with height " + element.getHeight() + " at y = " + y));
            LOG.debug((Object)("pageIdx = " + pageidx));
            LOG.debug((Object)("reportIndex = " + reportIndex));
            if (pageidx == reportIndex) {
                element.setY(y);
                retval.addElement(element);
            }
            upperBound = Math.max(upperBound, y += element.getHeight() + 30);
            LOG.debug((Object)("upperbound = " + upperBound));
        }
        if (this.hasCrosstabs(report) && this.subReportCount((JRBand)retval) == 0) {
            return null;
        }
        if (this.hasGroup(report) && reportIndex > 0) {
            return null;
        }
        LOG.debug((Object)("Setting height to " + upperBound));
        retval.setHeight(upperBound);
        return retval;
    }

    protected JRDesignCrosstabMeasure measure(String name) {
        JRDesignCrosstabMeasure retval = new JRDesignCrosstabMeasure();
        JRDesignExpression expression = new JRDesignExpression();
        expression.setValueClass(BigDecimal.class);
        expression.setText("$F{" + name + "}");
        retval.setValueExpression((JRExpression)expression);
        retval.setName(name + "Measure");
        retval.setValueClassName("java.math.BigDecimal");
        retval.setCalculation((byte)2);
        return retval;
    }

    protected JRDesignCrosstabBucket bucket(String text, Class valueClass) {
        JRDesignCrosstabBucket retval = new JRDesignCrosstabBucket();
        JRDesignExpression expression = new JRDesignExpression();
        expression.setValueClass(valueClass);
        expression.setText(text);
        retval.setExpression(expression);
        return retval;
    }

    protected void addDesignElementTo(JRDesignElementGroup band, JRDesignTextElement toAdd, int x, int y, int width, int height) {
        toAdd.setX(x);
        toAdd.setY(y);
        toAdd.setWidth(width);
        toAdd.setHeight(height);
        band.addElement((JRDesignElement)toAdd);
    }

    protected String getReportTitle(ReportInfo report) {
        if (report.getReportTitle() != null) {
            return report.getReportTitle();
        }
        String className = report.getClass().getSimpleName();
        return this.splitByUpperCase(className.substring(0, className.indexOf("Report")));
    }

    protected String initialCaps(String toCapitalize) {
        char[] str_arr = toCapitalize.toCharArray();
        str_arr[0] = Character.toUpperCase(str_arr[0]);
        for (int i = 1; i < str_arr.length; ++i) {
            if (str_arr[i] != ' ' || i + 1 >= str_arr.length) continue;
            str_arr[i + 1] = Character.toUpperCase(str_arr[i + 1]);
        }
        return new String(str_arr);
    }

    protected String splitByUpperCase(String toSplit) {
        StringBuilder retval = new StringBuilder(toSplit);
        char[] str_arr = toSplit.toCharArray();
        int inc = 0;
        for (int i = 1; i < str_arr.length; ++i) {
            if (str_arr[i] < 'A' || str_arr[i] > 'Z') continue;
            retval.insert(i + inc, ' ');
            ++inc;
        }
        return retval.toString();
    }

    protected void addGroupsFor(ReportInfo report, JasperDesign designObj) throws Exception {
        for (Field field : report.getClass().getDeclaredFields()) {
            if (!this.isGroup(field)) continue;
            LOG.info((Object)("Adding a group for field " + field.getName()));
            JRDesignGroup group = this.createGroup(report, field);
            designObj.addGroup(group);
        }
    }

    protected void addReportParametersFor(ReportInfo report, JasperDesign designObj) throws Exception {
        for (Field field : report.getClass().getDeclaredFields()) {
            JRDesignParameter designParameter;
            if (this.isParameter(field)) {
                designParameter = new JRDesignParameter();
                designParameter.setName(field.getName());
                designParameter.setValueClass(field.getType());
                designObj.addParameter((JRParameter)designParameter);
                LOG.debug((Object)("Added parameter " + designParameter.getName()));
            }
            if (this.isSubreport(field)) {
                designParameter = new JRDesignParameter();
                designParameter.setName(field.getName() + "Subreport");
                designParameter.setValueClass(JasperReport.class);
                designObj.addParameter((JRParameter)designParameter);
                LOG.debug((Object)("Added parameter " + designParameter.getName()));
                continue;
            }
            if (!this.isCrosstab(field)) continue;
            JRDesignDataset dataset = new JRDesignDataset(false);
            this.addReportFieldsFor(report, dataset);
            dataset.setName(this.initialCaps(field.getName()));
            designObj.addDataset(dataset);
        }
        JRDesignParameter designParameter = new JRDesignParameter();
        designParameter.setName("report");
        designParameter.setValueClass(report.getClass());
        designObj.addParameter((JRParameter)designParameter);
        LOG.debug((Object)("Added parameter " + designParameter.getName()));
    }

    protected void addReportFieldsFor(ReportInfo report, JasperDesign designObj) throws Exception {
        Class dataClass = this.findDataClassFor(report);
        LOG.debug((Object)("Found data class " + dataClass));
        for (Field field : dataClass.getDeclaredFields()) {
            JRDesignField designField = new JRDesignField();
            LOG.debug((Object)("Adding field " + field.getName()));
            designField.setName(field.getName());
            designField.setValueClass(field.getType());
            designObj.addField((JRField)designField);
        }
    }

    protected void addReportFieldsFor(ReportInfo report, JRDesignDataset dataset) throws Exception {
        Class dataClass = this.findDataClassFor(report);
        LOG.debug((Object)("Found data class " + dataClass));
        for (Field field : dataClass.getDeclaredFields()) {
            JRDesignField designField = new JRDesignField();
            designField.setName(field.getName());
            designField.setValueClass(field.getType());
            dataset.addField((JRField)designField);
        }
    }

    protected Class findDataClassFor(ReportInfo report) throws Exception {
        Class<?> reportClass = report.getClass();
        for (Field field : reportClass.getDeclaredFields()) {
            LOG.debug((Object)("Examinine field " + field + " with type " + field.getType()));
            if (!field.getType().equals(JRDataSource.class)) continue;
            String setterName = "set" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
            Method setter = reportClass.getMethod(setterName, Collection.class);
            LOG.debug((Object)("Determining what that data class should be. Found dataset setter method " + setter.getName()));
            ParameterizedType methodParamType = (ParameterizedType)setter.getGenericParameterTypes()[0];
            return (Class)methodParamType.getActualTypeArguments()[0];
        }
        return null;
    }

    public JasperDesign designReport(ReportInfo report, Field field) throws Exception {
        LOG.info((Object)("Designing a subreport for field " + field.getName()));
        LOG.debug((Object)("Checking the " + field.getName() + " for data"));
        try {
            field.setAccessible(true);
            if (field.get(report) == null) {
                return null;
            }
            LOG.debug((Object)"Subreport has data. Proceeding to design subreport.");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        JasperDesign designObj = new JasperDesign();
        designObj.setName(field.getName());
        designObj.setTitle(this.createTitle(report, this.getReportTitle(report)));
        this.addReportParametersFor(report, designObj);
        designObj.addImport(report.getClass().getName());
        this.addReportFieldsFor(report, designObj);
        JRDesignBand titleBand = new JRDesignBand();
        titleBand.setHeight(23);
        JRDesignStaticText headerLine4 = this.h4(this.initialCaps(field.getName())).toStaticText();
        this.addDesignElementTo((JRDesignElementGroup)titleBand, (JRDesignTextElement)headerLine4, 0, 0, 356, 22);
        designObj.setPageHeader((JRBand)titleBand);
        designObj.setPageWidth(595);
        designObj.setPageHeight(832);
        designObj.setLeftMargin(10);
        designObj.setRightMargin(10);
        designObj.setTopMargin(10);
        designObj.setBottomMargin(10);
        if (this.hasDetail(report)) {
            LOG.debug((Object)"Creating detail for subreport");
            designObj.setDetail(this.createDetail(report, 0));
        } else {
            LOG.debug((Object)"Creating summary for subreport");
            designObj.setSummary(this.createSummary(field));
        }
        return designObj;
    }

    @Override
    public JasperDesign designSummary(ReportInfo report) throws Exception {
        JasperDesign designObj = new JasperDesign();
        String reportTitle = this.getReportTitle(report);
        designObj.setName(reportTitle);
        designObj.setTitle(this.createTitle(report, reportTitle));
        LOG.info((Object)"Summary: Loading report parameters");
        this.addReportParametersFor(report, designObj);
        designObj.addImport(report.getClass().getName());
        LOG.info((Object)"Summary: Loading report fields");
        this.addReportFieldsFor(report, designObj);
        LOG.info((Object)"Summary: Setting report dimensions");
        designObj.setPageWidth(595);
        designObj.setPageHeight(832);
        designObj.setLeftMargin(10);
        designObj.setRightMargin(10);
        designObj.setTopMargin(10);
        designObj.setBottomMargin(10);
        LOG.info((Object)"Summary: Adding header and footer");
        JRDesignBand header = new JRDesignBand();
        JRDesignStaticText headerLine4 = this.h4("Summary").toStaticText();
        this.addDesignElementTo((JRDesignElementGroup)header, (JRDesignTextElement)headerLine4, 0, 25, 356, 22);
        header.setHeight(50);
        designObj.setPageHeader((JRBand)header);
        LOG.info((Object)"Creating report detail");
        Field summaryField = this.getFieldWithAnnotation(report, Summary.class);
        JRBand summary = this.createSummary(summaryField);
        if (summary != null) {
            designObj.setSummary(summary);
            return designObj;
        }
        return null;
    }

    @Override
    public JasperDesign designReport(ReportInfo report, Integer reportIndex) throws Exception {
        JasperDesign designObj = new JasperDesign();
        String reportTitle = this.getReportTitle(report);
        designObj.setName(reportTitle);
        if (reportIndex < 1) {
            designObj.setTitle(this.createTitle(report, reportTitle));
        }
        LOG.info((Object)"Loading report parameters");
        this.addReportParametersFor(report, designObj);
        designObj.addImport(report.getClass().getName());
        LOG.info((Object)"Loading report fields");
        this.addReportFieldsFor(report, designObj);
        LOG.info((Object)"Setting report dimensions");
        designObj.setPageWidth(595);
        designObj.setPageHeight(832);
        designObj.setLeftMargin(10);
        designObj.setRightMargin(10);
        designObj.setTopMargin(10);
        designObj.setBottomMargin(10);
        LOG.info((Object)"Handling groups");
        this.addGroupsFor(report, designObj);
        LOG.info((Object)"Creating report detail");
        JRBand detail = this.createDetail(report, reportIndex);
        if (detail == null) {
            return null;
        }
        designObj.setDetail(detail);
        return designObj;
    }

    protected JRChild createElementForField(ReportInfo report, Field field) throws Exception {
        LOG.info((Object)("Processing field " + field.getName()));
        if (this.isSubreport(field)) {
            LOG.debug((Object)("Creating a report element from field " + field.getName()));
            return this.createSubreport(report, field);
        }
        if (this.isCrosstab(field)) {
            LOG.debug((Object)("Creating a crosstab from field " + field.getName()));
            JRDesignCrosstab crosstab = this.createCrosstab(report, field);
            JRDesignCrosstabDataset dataset = new JRDesignCrosstabDataset();
            JRDesignDatasetRun dsRun = new JRDesignDatasetRun();
            JRDesignExpression dsExpression = new JRDesignExpression();
            String getterName = "get" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
            dsExpression.setText("$P{report}." + getterName + "()");
            dsExpression.setValueClass(JRDataSource.class);
            dsRun.setDatasetName(this.initialCaps(field.getName()));
            dsRun.setDataSourceExpression((JRExpression)dsExpression);
            dataset.setDatasetRun((JRDatasetRun)dsRun);
            dataset.setDataPreSorted(true);
            crosstab.setDataset(dataset);
            return crosstab;
        }
        if (this.isSummary(field)) {
            LOG.debug((Object)"Building Summary JRDesignBand");
            JRDesignBand summary = new JRDesignBand();
            Class dataClass = this.findDataClassFor(report);
            JRDesignStaticText header = this.h3("Summary").toStaticText();
            this.addDesignElementTo((JRDesignElementGroup)summary, (JRDesignTextElement)header, 0, 0, 175, 25);
            int fieldIdx = 0;
            for (Field dataField : dataClass.getDeclaredFields()) {
                JRDesignStaticText headerField = this.h5(dataField.getName()).toStaticText();
                this.addDesignElementTo((JRDesignElementGroup)summary, (JRDesignTextElement)headerField, 155 * fieldIdx, 25, 100, 18);
                JRDesignTextField textElement = this.normal("$F{" + dataField.getName() + "}").toTextField(dataField.getType());
                LOG.debug((Object)("Adding summary field " + dataField.getName() + " at (" + 55 * fieldIdx + "+ 0"));
                this.addDesignElementTo((JRDesignElementGroup)summary, (JRDesignTextElement)textElement, 155 * fieldIdx, 43, 150, 18);
                ++fieldIdx;
            }
            summary.setHeight(172);
            return summary;
        }
        return null;
    }

    @Override
    public Collection<Field> getSubreportFieldsFrom(ReportInfo report) throws Exception {
        ArrayList<Field> retval = new ArrayList<Field>();
        for (Field field : report.getClass().getDeclaredFields()) {
            if (field.getAnnotation(SubReport.class) == null) continue;
            retval.add(field);
        }
        return retval;
    }

    protected JRDesignSubreport createSubreport(ReportInfo report, Field field) throws Exception {
        JRDesignSubreport retval = new JRDesignSubreport((JRDefaultStyleProvider)new JasperDesign());
        JRDesignExpression dsExpression = new JRDesignExpression();
        String getterName = "get" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
        dsExpression.setText("$P{report}." + getterName + "()");
        dsExpression.setValueClass(JRDataSource.class);
        retval.setDataSourceExpression((JRExpression)dsExpression);
        JRDesignExpression expression = new JRDesignExpression();
        expression.setValueClass(JasperReport.class);
        expression.setText("$P{" + field.getName() + "Subreport}");
        retval.setExpression((JRExpression)expression);
        retval.setHeight(189);
        return retval;
    }

    @Override
    public JasperReport processReportForField(ReportInfo report, Field field) throws Exception {
        JasperDesign design = this.designReport(report, field);
        if (design == null) {
            return null;
        }
        JasperReport retval = JasperCompileManager.compileReport((JasperDesign)design);
        retval.setWhenNoDataType((byte)3);
        return retval;
    }

    protected JRBand createGroupHeader(ReportInfo report) {
        JRDesignBand retval = new JRDesignBand();
        retval.setHeight(100);
        JRDesignTextField expenseType = this.h4("$F{expenseType}").toTextField();
        this.addDesignElementTo((JRDesignElementGroup)retval, (JRDesignTextElement)expenseType, 0, 25, 175, 28);
        JRDesignStaticText nameField = this.h5("Expense").toStaticText();
        this.addDesignElementTo((JRDesignElementGroup)retval, (JRDesignTextElement)nameField, 0, 68, 150, 18);
        JRDesignStaticText dateField = this.h5("Date").toStaticText();
        this.addDesignElementTo((JRDesignElementGroup)retval, (JRDesignTextElement)dateField, 155, 68, 150, 18);
        JRDesignStaticText amountField = this.h5("Amount").toStaticText();
        this.addDesignElementTo((JRDesignElementGroup)retval, (JRDesignTextElement)amountField, 310, 68, 150, 18);
        return retval;
    }

    protected JRBand createGroupFooter(ReportInfo report) {
        JRDesignBand band = new JRDesignBand();
        band.setSplitAllowed(true);
        return band;
    }

    protected String getGroupFieldFrom(Field field) {
        Group group = field.getAnnotation(Group.class);
        if (group == null) {
            throw new IllegalArgumentException(field + " is not grouped!");
        }
        return group.value();
    }

    protected JRDesignGroup createGroup(ReportInfo report, Field field) {
        JRDesignGroup group = new JRDesignGroup();
        String groupFieldName = this.getGroupFieldFrom(field);
        JRDesignExpression expression = new JRDesignExpression();
        expression.setValueClass(String.class);
        expression.setText("$F{" + groupFieldName + "}");
        group.setExpression((JRExpression)expression);
        group.setName(groupFieldName);
        group.setGroupHeader(this.createGroupHeader(report));
        group.setGroupFooter(this.createGroupFooter(report));
        return group;
    }

    protected boolean hasGroup(ReportInfo report) {
        return this.groupCount(report) > 0;
    }

    protected int groupCount(ReportInfo report) {
        int retval = 0;
        try {
            for (Field field : report.getClass().getDeclaredFields()) {
                if (field.getAnnotation(Group.class) == null) continue;
                ++retval;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Unable to get group count");
        }
        return retval;
    }

    protected int subReportCount(JRBand design) {
        int retval = 0;
        for (JRElement obj : design.getElements()) {
            if (!(obj instanceof JRDesignSubreport)) continue;
            ++retval;
        }
        return retval;
    }

    protected int subReportCount(ReportInfo report) {
        int retval = 0;
        try {
            for (Field field : report.getClass().getDeclaredFields()) {
                if (field.getAnnotation(SubReport.class) == null) continue;
                ++retval;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Unable to get subreport count");
        }
        return retval;
    }

    protected int groupTotalHeight(ReportInfo report) {
        return this.groupCount(report) + 246;
    }

    protected Collection<JRChild> processFields(ReportInfo report) throws Exception {
        return this.processFields(report, new Class[0]);
    }

    protected Collection<JRChild> processFields(ReportInfo report, Class ... annotations) throws Exception {
        ArrayList<JRChild> retval = new ArrayList<JRChild>();
        for (Field field : report.getClass().getDeclaredFields()) {
            boolean valid = true;
            if (!(valid &= this.hasAnnotations(field, annotations) && !this.hasAnnotations(field, Summary.class, SubReport.class))) continue;
            retval.add(this.createElementForField(report, field));
        }
        return retval;
    }

    protected JRDesignCrosstabCell crosstabCell(Class type, String value, String rowGroup) {
        return this.crosstabCell(type, value, rowGroup, null);
    }

    protected JRDesignCrosstabCell crosstabCell(Class type, String value, String rowGroup, String colGroup) {
        LOG.debug((Object)("Creating cell with row group = " + rowGroup + " and column group = " + colGroup));
        JRDesignCrosstabCell retval = new JRDesignCrosstabCell();
        JRDesignCellContents contents = new JRDesignCellContents();
        JRDesignTextField field = this.normal(value).toTextField(type);
        this.addDesignElementTo((JRDesignElementGroup)contents, (JRDesignTextElement)field, 0, 0, 50, 18);
        contents.setMode(Byte.valueOf((byte)1));
        contents.setBackcolor(Color.LIGHT_GRAY);
        JRDesignFrame frame = new JRDesignFrame();
        frame.copyBox((JRLineBox)new TravelReportLineBox((JRBoxContainer)contents));
        contents.setBox((JRBox)frame);
        retval.setWidth(Integer.valueOf(50));
        retval.setHeight(Integer.valueOf(18));
        retval.setContents(contents);
        retval.setRowTotalGroup(rowGroup);
        retval.setColumnTotalGroup(colGroup);
        return retval;
    }

    protected JRDesignCrosstabCell crosstabCell(Class type, String value) {
        return this.crosstabCell(type, value, null, null);
    }

    protected JRDesignCrosstab createCrosstab(ReportInfo report, Field field) throws Exception {
        JRDesignCrosstab crosstab = new JRDesignCrosstab();
        LOG.debug((Object)"<crosstab>");
        LOG.debug((Object)"<reportElement width=\"400\" height=\"147\" />");
        crosstab.setWidth(595);
        crosstab.setHeight(0);
        JRDesignCellContents nodataCell = new JRDesignCellContents();
        nodataCell.setBackcolor(Color.LIGHT_GRAY);
        nodataCell.setMode(Byte.valueOf((byte)1));
        JRDesignFrame frame = new JRDesignFrame();
        frame.copyBox((JRLineBox)new TravelReportLineBox((JRBoxContainer)nodataCell));
        nodataCell.setBox((JRBox)frame);
        LOG.debug((Object)"<crosstabHeaderCell/>");
        crosstab.setHeaderCell(nodataCell);
        JRDesignCrosstabRowGroup rowGroup = new JRDesignCrosstabRowGroup();
        JRDesignCellContents rowHeader = new JRDesignCellContents();
        JRDesignCellContents rowTotalHeader = new JRDesignCellContents();
        rowHeader.setMode(Byte.valueOf((byte)1));
        rowHeader.setBackcolor(Color.LIGHT_GRAY);
        JRDesignFrame rowFrame = new JRDesignFrame();
        rowFrame.copyBox((JRLineBox)new TravelReportLineBox((JRBoxContainer)rowHeader));
        rowHeader.setBox((JRBox)rowFrame);
        JRDesignStaticText rowTotalText = this.h3("Daily Total").toStaticText();
        this.addDesignElementTo((JRDesignElementGroup)rowTotalHeader, (JRDesignTextElement)rowTotalText, 0, 0, 50, 18);
        JRDesignTextField rowHeaderField = this.normal("$V{Expenses}").toTextField();
        this.addDesignElementTo((JRDesignElementGroup)rowHeader, (JRDesignTextElement)rowHeaderField, 0, 0, 175, 18);
        rowGroup.setName("Expenses");
        rowGroup.setWidth(175);
        rowGroup.setHeader(rowHeader);
        rowGroup.setTotalHeader(rowTotalHeader);
        rowGroup.setBucket(this.bucket("$F{name}", String.class));
        JRDesignCrosstabColumnGroup columnGroup = new JRDesignCrosstabColumnGroup();
        JRDesignCellContents columnHeader = new JRDesignCellContents();
        JRDesignCellContents columnTotalHeader = new JRDesignCellContents();
        columnHeader.setMode(Byte.valueOf((byte)1));
        columnHeader.setBackcolor(Color.LIGHT_GRAY);
        JRDesignFrame columnFrame = new JRDesignFrame();
        columnFrame.copyBox((JRLineBox)new TravelReportLineBox((JRBoxContainer)columnHeader));
        columnHeader.setBox((JRBox)columnFrame);
        JRDesignStaticText columnTotalText = this.h3("Expense Totals").toStaticText();
        this.addDesignElementTo((JRDesignElementGroup)columnTotalHeader, (JRDesignTextElement)columnTotalText, 0, 0, 50, 18);
        JRDesignTextField columnHeaderField = this.normal("$V{Days}").toTextField();
        this.addDesignElementTo((JRDesignElementGroup)columnHeader, (JRDesignTextElement)columnHeaderField, 0, 0, 50, 18);
        columnGroup.setName("Days");
        columnGroup.setHeight(18);
        columnGroup.setHeader(columnHeader);
        columnGroup.setTotalHeader(columnTotalHeader);
        columnGroup.setBucket(this.bucket("$F{date}", String.class));
        LOG.debug((Object)"<rowGroup name=\"Expenses\" width=\"400\">");
        crosstab.addRowGroup(rowGroup);
        crosstab.addColumnGroup(columnGroup);
        crosstab.addMeasure(this.measure("amount"));
        crosstab.addCell(this.crosstabCell(BigDecimal.class, "$V{amountMeasure}"));
        crosstab.addCell(this.crosstabCell(BigDecimal.class, "$V{amountMeasure}", "Expenses"));
        crosstab.addCell(this.crosstabCell(BigDecimal.class, "$V{amountMeasure}", null, "Days"));
        crosstab.addCell(this.crosstabCell(BigDecimal.class, "$V{amountMeasure}", "Expenses", "Days"));
        return crosstab;
    }

    protected JRDesignCrosstab createCrosstab() throws Exception {
        JRDesignCrosstab crosstab = new JRDesignCrosstab();
        crosstab.setRunDirection((byte)0);
        crosstab.setWidth(595);
        crosstab.setHeight(0);
        JRDesignCellContents nodataCell = new JRDesignCellContents();
        nodataCell.setBackcolor(Color.LIGHT_GRAY);
        nodataCell.setMode(Byte.valueOf((byte)1));
        JRDesignFrame frame = new JRDesignFrame();
        frame.copyBox((JRLineBox)new TravelReportLineBox((JRBoxContainer)nodataCell));
        nodataCell.setBox((JRBox)frame);
        JRDesignCrosstabRowGroup rowGroup = new JRDesignCrosstabRowGroup();
        JRDesignCellContents rowHeader = new JRDesignCellContents();
        JRDesignCellContents rowTotalHeader = new JRDesignCellContents();
        rowHeader.setMode(Byte.valueOf((byte)1));
        rowHeader.setBackcolor(Color.LIGHT_GRAY);
        JRDesignFrame rowFrame = new JRDesignFrame();
        rowFrame.copyBox((JRLineBox)new TravelReportLineBox((JRBoxContainer)rowHeader));
        rowHeader.setBox((JRBox)rowFrame);
        JRDesignStaticText rowTotalText = this.h3("Daily Total").toStaticText();
        this.addDesignElementTo((JRDesignElementGroup)rowTotalHeader, (JRDesignTextElement)rowTotalText, 0, 0, 50, 18);
        JRDesignTextField rowHeaderField = this.normal("$V{Expenses}").toTextField();
        this.addDesignElementTo((JRDesignElementGroup)rowHeader, (JRDesignTextElement)rowHeaderField, 0, 0, 175, 18);
        rowGroup.setPosition((byte)1);
        rowGroup.setName("Expenses");
        rowGroup.setWidth(175);
        rowGroup.setHeader(rowHeader);
        rowGroup.setTotalHeader(rowTotalHeader);
        rowGroup.setBucket(this.bucket("$F{name}", String.class));
        JRDesignCrosstabColumnGroup columnGroup = new JRDesignCrosstabColumnGroup();
        JRDesignCellContents columnHeader = new JRDesignCellContents();
        JRDesignCellContents columnTotalHeader = new JRDesignCellContents();
        columnHeader.setMode(Byte.valueOf((byte)1));
        columnHeader.setBackcolor(Color.LIGHT_GRAY);
        JRDesignFrame columnFrame = new JRDesignFrame();
        columnFrame.copyBox((JRLineBox)new TravelReportLineBox((JRBoxContainer)columnHeader));
        JRDesignStaticText columnTotalText = this.h3("Expense Totals").toStaticText();
        this.addDesignElementTo((JRDesignElementGroup)columnTotalHeader, (JRDesignTextElement)columnTotalText, 0, 0, 50, 18);
        JRDesignTextField columnHeaderField = this.normal("$V{Days}").toTextField();
        this.addDesignElementTo((JRDesignElementGroup)columnHeader, (JRDesignTextElement)columnHeaderField, 0, 0, 50, 18);
        columnGroup.setPosition((byte)1);
        columnGroup.setName("Days");
        columnGroup.setHeight(18);
        columnGroup.setHeader(columnHeader);
        columnGroup.setTotalHeader(columnTotalHeader);
        columnGroup.setBucket(this.bucket("$F{date}", String.class));
        crosstab.addRowGroup(rowGroup);
        crosstab.addColumnGroup(columnGroup);
        crosstab.addMeasure(this.measure("amount"));
        crosstab.addCell(this.crosstabCell(BigDecimal.class, "$V{amountMeasure}"));
        crosstab.addCell(this.crosstabCell(BigDecimal.class, "$V{amountMeasure}", "Expenses"));
        crosstab.addCell(this.crosstabCell(BigDecimal.class, "$V{amountMeasure}", null, "Days"));
        crosstab.addCell(this.crosstabCell(BigDecimal.class, "$V{amountMeasure}", "Expenses", "Days"));
        return crosstab;
    }

    protected boolean hasCrosstabs(ReportInfo report) {
        for (Field field : report.getClass().getDeclaredFields()) {
            if (!this.isCrosstab(field)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasFieldWithAnnotations(ReportInfo report, Class ... annotations) {
        return this.hasFieldWithAnnotations(report.getClass(), annotations);
    }

    protected boolean hasFieldWithAnnotations(Class reportClass, Class ... annotations) {
        for (Field field : reportClass.getDeclaredFields()) {
            if (!this.hasAnnotations(field, annotations)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Field getFieldWithAnnotation(ReportInfo report, Class ... annotations) {
        return this.getFieldsWithAnnotation(report.getClass(), annotations).iterator().next();
    }

    protected Field getFieldWithAnnotation(Class searchClass, Class ... annotations) {
        return this.getFieldsWithAnnotation(searchClass, annotations).iterator().next();
    }

    protected Collection<Field> getFieldsWithAnnotation(Class searchClass, Class ... annotations) {
        ArrayList<Field> retval = new ArrayList<Field>();
        for (Field field : searchClass.getDeclaredFields()) {
            if (!this.hasAnnotations(field, annotations)) continue;
            retval.add(field);
        }
        return retval;
    }

    protected boolean hasAnnotations(Field field, Class ... annotations) {
        for (Class annotation : annotations) {
            LOG.debug((Object)("Checking if field " + field.getName() + " has annotation " + annotation.getSimpleName()));
            if (field.getAnnotation(annotation) != null) continue;
            return false;
        }
        return true;
    }

    protected boolean isSubreport(Field field) {
        return field.getAnnotation(SubReport.class) != null;
    }

    @Override
    public boolean isSummary(Field field) {
        return field.getAnnotation(Summary.class) != null;
    }

    protected boolean isCrosstab(Field field) {
        for (Annotation annotation : field.getDeclaredAnnotations()) {
            if (!(annotation instanceof Crosstab)) continue;
            return true;
        }
        return false;
    }

    protected boolean isGroup(Field field) {
        for (Annotation annotation : field.getDeclaredAnnotations()) {
            if (!(annotation instanceof Group)) continue;
            return true;
        }
        return false;
    }

    protected boolean isParameter(Field field) {
        for (Annotation annotation : field.getDeclaredAnnotations()) {
            if (!(annotation instanceof Parameter)) continue;
            return true;
        }
        return false;
    }

    public Map<String, RTextStyle> getStyles() {
        return this.styles;
    }

    public void setStyles(Map<String, RTextStyle> styles) {
        this.styles = styles;
    }

    private static class TravelReportLineBox
    extends JRBaseLineBox {
        protected TravelReportLineBox(JRBoxContainer container) {
            super(container);
            JRBaseBoxPen pen = new JRBaseBoxPen((JRLineBox)this){

                public Color getLineColor() {
                    return Color.BLACK;
                }

                public Byte getLineStyle() {
                    return (byte)0;
                }

                public Float getLineWidth() {
                    return Float.valueOf(0.5f);
                }
            };
            this.pen = pen;
        }
    }
}

