/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.report.service.impl;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.tem.report.DetailedReport;
import org.kuali.kfs.module.tem.report.annotations.ReportStyle;
import org.kuali.kfs.module.tem.report.service.TravelReportFactoryService;
import org.kuali.kfs.module.tem.report.service.TravelReportService;
import org.kuali.kfs.sys.report.ReportInfo;
import org.kuali.kfs.sys.service.ReportGenerationService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class TravelReportServiceImpl
implements TravelReportService {
    public static Logger LOG = Logger.getLogger(TravelReportServiceImpl.class);
    protected ReportGenerationService reportGenerationService;
    protected TravelReportFactoryService reportFactoryService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteArrayOutputStream buildReport(ReportInfo report) throws Exception {
        ArrayList reportSet = new ArrayList();
        HashMap<String, ReportInfo> reportData = new HashMap<String, ReportInfo>();
        reportData.put("report", report);
        ArrayList<JasperPrint> printObjs = new ArrayList<JasperPrint>();
        Collection<Field> subreportFields = this.getReportFactoryService().getSubreportFieldsFrom(report);
        if (subreportFields.size() > 0) {
            LOG.info((Object)"######################################################################");
            LOG.info((Object)"# BEGINNING PROCESSING SUBREPORTS                                    #");
            LOG.info((Object)"######################################################################");
        }
        for (Field subreportField : subreportFields) {
            subreportField.setAccessible(true);
            JasperReport reportObj = this.getReportFactoryService().processReportForField(report, subreportField);
            if (reportObj == null) continue;
            reportObj.setWhenNoDataType((byte)4);
            printObjs.add(JasperFillManager.fillReport((JasperReport)reportObj, reportData, (JRDataSource)((JRDataSource)subreportField.get(report))));
        }
        if (subreportFields.size() > 0) {
            LOG.info((Object)"######################################################################");
            LOG.info((Object)"# FINISHED PROCESSING SUBREPORTS                                     #");
            LOG.info((Object)"######################################################################");
        }
        boolean addMoreReports = true;
        int i = 0;
        while (addMoreReports) {
            JasperDesign designObj = this.getReportFactoryService().designReport(report, i);
            if (designObj != null) {
                JasperReport reportObj = JasperCompileManager.compileReport((JasperDesign)designObj);
                reportObj.setWhenNoDataType((byte)4);
                if (report instanceof DetailedReport) {
                    printObjs.add(JasperFillManager.fillReport((JasperReport)reportObj, reportData, (JRDataSource)((DetailedReport)report).getData()));
                }
            } else {
                addMoreReports = false;
            }
            ++i;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JRPdfExporter exporter = new JRPdfExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, printObjs);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
        try {
            exporter.exportReport();
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        finally {
            LOG.info((Object)"######################################################################");
            LOG.info((Object)"# FINISHED PROCESSING REPORT                                         #");
            LOG.info((Object)"######################################################################");
        }
        return baos;
    }

    public void setReportGenerationService(ReportGenerationService reportGenerationService) {
        this.reportGenerationService = reportGenerationService;
    }

    public ReportGenerationService getReportGenerationService() {
        return this.reportGenerationService;
    }

    protected boolean isCrosstabReport(ReportInfo report) {
        return this.isCrosstabReport(report.getClass());
    }

    protected boolean isCrosstabReport(Class reportClass) {
        if (reportClass.getAnnotation(ReportStyle.class) != null) {
            // empty if block
        }
        return true;
    }

    public TravelReportFactoryService getReportFactoryService() {
        return this.reportFactoryService;
    }

    public void setReportFactoryService(TravelReportFactoryService reportFactoryService) {
        this.reportFactoryService = reportFactoryService;
    }
}

