/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.report.util;

import java.awt.image.BufferedImage;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.impl.code128.Code128Bean;
import org.krysalis.barcode4j.impl.code39.Code39Bean;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;
import org.krysalis.barcode4j.tools.UnitConv;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;

public class BarcodeHelper {
    public static final String BARCODE_39 = "39";
    public static final String BARCODE_128 = "128";
    public static final int DPI = 150;
    private static final String MIME = "image/gif";
    private static final String BARCODE_GIF = "barcode.gif";

    public BufferedImage generateBarcodeImage(String documentNumber) {
        String barcodeStyle = BarcodeHelper.getParameterService().getParameterValueAsString(TravelReimbursementDocument.class, "BARCODE_STYLE");
        BufferedImage image = null;
        if (barcodeStyle.equals(BARCODE_39)) {
            Code39Bean bean = new Code39Bean();
            bean.setModuleWidth(UnitConv.in2mm((double)0.006666666828095913));
            bean.setWideFactor(3.0);
            bean.doQuietZone(false);
            image = this.getBufferedBarcodeImage(documentNumber, (BarcodeGenerator)bean);
        } else if (barcodeStyle.equals(BARCODE_128)) {
            Code128Bean bean = new Code128Bean();
            bean.setModuleWidth(UnitConv.in2mm((double)0.006666666828095913));
            bean.doQuietZone(false);
            image = this.getBufferedBarcodeImage(documentNumber, (BarcodeGenerator)bean);
        }
        return image;
    }

    private synchronized BufferedImage getBufferedBarcodeImage(String documentNumber, BarcodeGenerator bean) {
        try {
            BitmapCanvasProvider canvas = new BitmapCanvasProvider(150, 12, false, 0);
            bean.generateBarcode((CanvasProvider)canvas, documentNumber);
            BufferedImage image = canvas.getBufferedImage();
            canvas.finish();
            return image;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ParameterService getParameterService() {
        return (ParameterService)SpringContext.getBean(ParameterService.class);
    }

    public static ConfigurationService getConfigurationService() {
        return (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
    }
}

