/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.AccountingDistribution;
import org.kuali.kfs.module.tem.businessobject.TemExpense;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.MileageRateService;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.service.TemExpenseService;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public abstract class ExpenseServiceBase
implements TemExpenseService {
    @Override
    public Map<String, AccountingDistribution> getAccountingDistribution(TravelDocument document) {
        HashMap<String, AccountingDistribution> distributionMap = new HashMap<String, AccountingDistribution>();
        this.calculateDistributionTotals(document, distributionMap, this.getExpenseDetails(document));
        return distributionMap;
    }

    @Override
    public abstract void calculateDistributionTotals(TravelDocument var1, Map<String, AccountingDistribution> var2, List<? extends TemExpense> var3);

    @Override
    public abstract List<? extends TemExpense> getExpenseDetails(TravelDocument var1);

    public ObjectCodeService getObjectCodeService() {
        return (ObjectCodeService)SpringContext.getBean(ObjectCodeService.class);
    }

    public ParameterService getParameterService() {
        return (ParameterService)SpringContext.getBean(ParameterService.class);
    }

    protected TravelDocumentService getTravelDocumentService() {
        return (TravelDocumentService)SpringContext.getBean(TravelDocumentService.class);
    }

    protected MileageRateService getMileageRateService() {
        return (MileageRateService)SpringContext.getBean(MileageRateService.class);
    }

    public BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    }

    @Override
    public KualiDecimal getAllExpenseTotal(TravelDocument document, boolean includeNonReimbursable) {
        KualiDecimal total = KualiDecimal.ZERO;
        total = includeNonReimbursable ? this.calculateTotals(total, this.getExpenseDetails(document), "A") : this.calculateTotals(total, this.getExpenseDetails(document), "R");
        return total;
    }

    @Override
    public KualiDecimal getNonReimbursableExpenseTotal(TravelDocument document) {
        KualiDecimal total = KualiDecimal.ZERO;
        total = this.calculateTotals(total, this.getExpenseDetails(document), "N");
        return total;
    }

    private KualiDecimal calculateTotals(KualiDecimal total, List<? extends TemExpense> expenses, String code) {
        for (TemExpense temExpense : expenses) {
            if (!this.validateExpenseCalculation(temExpense)) continue;
            if (temExpense.getExpenseDetails() != null && temExpense.getExpenseDetails().size() > 0) {
                total = this.calculateTotals(total, temExpense.getExpenseDetails(), code);
                continue;
            }
            if ("A".equals(code)) {
                total = (KualiDecimal)total.add((AbstractKualiDecimal)temExpense.getConvertedAmount());
                continue;
            }
            if ("N".equals(code)) {
                if ((temExpense.getExpenseTypeObjectCode() == null || !temExpense.getExpenseTypeObjectCode().getExpenseType().isPrepaidExpense()) && !temExpense.getNonReimbursable().booleanValue()) continue;
                total = (KualiDecimal)total.add((AbstractKualiDecimal)temExpense.getConvertedAmount());
                continue;
            }
            if (!"R".equals(code) || (ObjectUtils.isNull((Object)((Object)temExpense.getExpenseTypeObjectCode())) || temExpense.getExpenseTypeObjectCode().getExpenseType().isPrepaidExpense()) && !ObjectUtils.isNull((Object)((Object)temExpense.getExpenseTypeObjectCode())) || temExpense.getNonReimbursable().booleanValue()) continue;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)temExpense.getConvertedAmount());
        }
        return total;
    }

    @Override
    public boolean validateExpenseCalculation(TemExpense expense) {
        return true;
    }

    @Override
    public abstract void processExpense(TravelDocument var1, GeneralLedgerPendingEntrySequenceHelper var2);

    @Override
    public abstract void updateExpense(TravelDocument var1);
}

