/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.fp.document.DistributionOfIncomeAndExpenseDocument;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.batch.service.ImportedExpensePendingEntryService;
import org.kuali.kfs.module.tem.businessobject.AccountingDistribution;
import org.kuali.kfs.module.tem.businessobject.ExpenseType;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeObjectCode;
import org.kuali.kfs.module.tem.businessobject.HistoricalExpenseAsTemExpenseWrapper;
import org.kuali.kfs.module.tem.businessobject.HistoricalTravelExpense;
import org.kuali.kfs.module.tem.businessobject.ImportedExpense;
import org.kuali.kfs.module.tem.businessobject.TemExpense;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLine;
import org.kuali.kfs.module.tem.businessobject.TripAccountingInformation;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.service.TemExpenseService;
import org.kuali.kfs.module.tem.service.TravelExpenseService;
import org.kuali.kfs.module.tem.service.impl.ExpenseServiceBase;
import org.kuali.kfs.module.tem.util.ExpenseUtils;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class ImportedCTSExpenseServiceImpl
extends ExpenseServiceBase
implements TemExpenseService {
    private static Logger LOG = Logger.getLogger(ImportedCTSExpenseServiceImpl.class);
    protected ImportedExpensePendingEntryService importedExpensePendingEntryService;
    protected TravelExpenseService travelExpenseService;
    protected DataDictionaryService dataDictionaryService;

    @Override
    public void calculateDistributionTotals(TravelDocument document, Map<String, AccountingDistribution> distributionMap, List<? extends TemExpense> expenses) {
        String defaultChartCode = ExpenseUtils.getDefaultChartCode(document);
        for (TemExpense temExpense : expenses) {
            ImportedExpense expense;
            String cardType;
            if (!(temExpense instanceof ImportedExpense) || (cardType = (expense = (ImportedExpense)temExpense).getCardType()) == null || !cardType.equals("CTS") || expense.getNonReimbursable().booleanValue()) continue;
            expense.refreshReferenceObject("expenseTypeObjectCode");
            String financialObjectCode = "";
            expense.getExpenseTypeObjectCode();
            if (expense.getExpenseTypeObjectCode().getExpenseTypeCode().equals("A")) {
                financialObjectCode = this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_ALL.class, "TRAVEL_CREDIT_CARD_AIRFARE_OBJECT_CODE");
            } else if (expense.getExpenseTypeObjectCode().getExpenseTypeCode().equals("L")) {
                financialObjectCode = this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_ALL.class, "TRAVEL_CREDIT_CARD_LODGING_OBJECT_CODE");
            } else if (expense.getExpenseTypeObjectCode().getExpenseTypeCode().equals("R")) {
                financialObjectCode = this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_ALL.class, "TRAVEL_CREDIT_CARD_RENTAL_CAR_OBJECT_CODE");
            }
            LOG.debug((Object)("Refreshed importedExpense with expense type code " + expense.getExpenseTypeObjectCode().getExpenseTypeCode() + " and financialObjectCode " + financialObjectCode));
            ObjectCode objCode = this.getObjectCodeService().getByPrimaryIdForCurrentYear(defaultChartCode, expense.getExpenseTypeObjectCode().getFinancialObjectCode());
            if (objCode == null || expense.getExpenseTypeObjectCode() == null || expense.getExpenseTypeObjectCode().getExpenseType().isPrepaidExpense()) continue;
            AccountingDistribution distribution = null;
            String key = objCode.getCode() + "-" + "CTS";
            if (distributionMap.containsKey(key)) {
                distributionMap.get(key).setSubTotal((KualiDecimal)distributionMap.get(key).getSubTotal().add((AbstractKualiDecimal)expense.getConvertedAmount()));
                distributionMap.get(key).setRemainingAmount((KualiDecimal)distributionMap.get(key).getRemainingAmount().add((AbstractKualiDecimal)expense.getConvertedAmount()));
                continue;
            }
            distribution = new AccountingDistribution();
            distribution.setObjectCode(objCode.getCode());
            distribution.setObjectCodeName(objCode.getName());
            distribution.setCardType(cardType);
            distribution.setRemainingAmount(expense.getConvertedAmount());
            distribution.setSubTotal(expense.getConvertedAmount());
            distributionMap.put(key, distribution);
        }
    }

    @Override
    public List<? extends TemExpense> getExpenseDetails(TravelDocument document) {
        List<ImportedExpense> importedExpenses = document.getImportedExpenses();
        HashSet<Long> importedHistoricalExpenseIds = new HashSet<Long>();
        ArrayList<TemExpense> ctsExpenses = new ArrayList<TemExpense>();
        for (ImportedExpense expense : importedExpenses) {
            if (!StringUtils.equals((String)expense.getCardType(), (String)"CTS")) continue;
            ctsExpenses.add(expense);
            importedHistoricalExpenseIds.add(expense.getHistoricalTravelExpenseId());
        }
        List<HistoricalTravelExpense> hungExpenses = document.getHistoricalTravelExpenses();
        for (HistoricalTravelExpense expense : hungExpenses) {
            if (!StringUtils.equals((String)expense.getCreditCardAgency().getTravelCardTypeCode(), (String)"CTS") || importedHistoricalExpenseIds.contains(expense.getId())) continue;
            ctsExpenses.add(new HistoricalExpenseAsTemExpenseWrapper(expense));
        }
        return ctsExpenses;
    }

    @Override
    public boolean validateExpenseCalculation(TemExpense expense) {
        return expense instanceof ImportedExpense && StringUtils.defaultString((String)((ImportedExpense)expense).getCardType()).equals("CTS") || expense instanceof HistoricalExpenseAsTemExpenseWrapper && StringUtils.equals((String)((HistoricalExpenseAsTemExpenseWrapper)expense).getCardType(), (String)"CTS");
    }

    @Override
    public void processExpense(TravelDocument travelDocument, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        String distributionIncomeAndExpenseDocumentType = this.getDataDictionaryService().getDocumentTypeNameByClass(DistributionOfIncomeAndExpenseDocument.class);
        List lines = travelDocument.getSourceAccountingLines();
        HashMap<AccountingInfoKey, KualiDecimal> accountingLineMap = new HashMap<AccountingInfoKey, KualiDecimal>();
        for (TemSourceAccountingLine line : lines) {
            if (!line.getCardType().equals("CTS")) continue;
            AccountingInfoKey key = new AccountingInfoKey(line);
            Object amount = line.getAmount();
            if (accountingLineMap.containsKey(key)) {
                amount = (KualiDecimal)((KualiDecimal)accountingLineMap.get(key)).add((AbstractKualiDecimal)line.getAmount());
            }
            accountingLineMap.put(key, (KualiDecimal)amount);
        }
        HashMap<AccountingInfoKey, KualiDecimal> tripAccountMap = new HashMap<AccountingInfoKey, KualiDecimal>();
        for (HistoricalTravelExpense historicalTravelExpense : travelDocument.getHistoricalTravelExpenses()) {
            if (!travelDocument.getDocumentNumber().equals(historicalTravelExpense.getDocumentNumber()) || historicalTravelExpense.getAgencyStagingData() == null || !historicalTravelExpense.getReconciled().equals("N")) continue;
            for (TripAccountingInformation tripAccountingInformation : historicalTravelExpense.getAgencyStagingData().getTripAccountingInformation()) {
                AccountingInfoKey key = new AccountingInfoKey(tripAccountingInformation, historicalTravelExpense);
                KualiDecimal amount = tripAccountingInformation.getAmount();
                if (amount == null) {
                    amount = (KualiDecimal)historicalTravelExpense.getAmount().divide((AbstractKualiDecimal)new KualiDecimal(historicalTravelExpense.getAgencyStagingData().getTripAccountingInformation().size()));
                }
                if (tripAccountMap.containsKey(key)) {
                    amount = (KualiDecimal)((KualiDecimal)tripAccountMap.get(key)).add((AbstractKualiDecimal)amount);
                }
                tripAccountMap.put(key, amount);
            }
        }
        for (AccountingInfoKey key : tripAccountMap.keySet()) {
            if (accountingLineMap.containsKey(key) && !((KualiDecimal)accountingLineMap.get(key)).isLessThan((AbstractKualiDecimal)tripAccountMap.get(key))) continue;
            TemSourceAccountingLine creditLine = new TemSourceAccountingLine();
            creditLine.setChartOfAccountsCode(key.getChartOfAccountsCode());
            creditLine.setAccountNumber(key.getAccountNumber());
            creditLine.setSubAccountNumber(key.getSubAccountNumber());
            ExpenseTypeObjectCode expenseTypeObjectCode = this.getExpenseTypeObjectCode(travelDocument, key.getHistoricalTravelExpense());
            creditLine.setFinancialObjectCode(expenseTypeObjectCode.getFinancialObjectCode());
            creditLine.setProjectCode(key.getProjectCode());
            creditLine.setOrganizationReferenceId(key.getOrganizationReferenceId());
            KualiDecimal amount = accountingLineMap.get(key) == null ? (KualiDecimal)tripAccountMap.get(key) : (KualiDecimal)((KualiDecimal)tripAccountMap.get(key)).subtract((AbstractKualiDecimal)accountingLineMap.get(key));
            creditLine.setAmount(amount);
            creditLine.setReferenceOriginCode("01");
            this.importedExpensePendingEntryService.generateDocumentImportedExpenseGeneralLedgerPendingEntries(travelDocument, (GeneralLedgerPendingEntrySourceDetail)creditLine, sequenceHelper, true, distributionIncomeAndExpenseDocumentType);
            accountingLineMap.remove(key);
        }
        for (AccountingInfoKey key : accountingLineMap.keySet()) {
            TemSourceAccountingLine debitLine = new TemSourceAccountingLine();
            debitLine.setChartOfAccountsCode(key.getChartOfAccountsCode());
            debitLine.setAccountNumber(key.getAccountNumber());
            debitLine.setSubAccountNumber(key.getSubAccountNumber());
            debitLine.setFinancialObjectCode(key.getFinancialObjectCode());
            debitLine.setFinancialSubObjectCode(key.getFinancialSubObjectCode());
            debitLine.setProjectCode(key.getProjectCode());
            debitLine.setOrganizationReferenceId(key.getOrganizationReferenceId());
            debitLine.setAmount((KualiDecimal)accountingLineMap.get(key));
            debitLine.setReferenceOriginCode("01");
            this.importedExpensePendingEntryService.generateDocumentImportedExpenseGeneralLedgerPendingEntries(travelDocument, (GeneralLedgerPendingEntrySourceDetail)debitLine, sequenceHelper, false, distributionIncomeAndExpenseDocumentType);
        }
        for (ImportedExpense importedExpense : travelDocument.getImportedExpenses()) {
            if (!StringUtils.equals((String)importedExpense.getCardType(), (String)"CTS")) continue;
            List<GeneralLedgerPendingEntry> creditEntries = this.importedExpensePendingEntryService.buildDistributionEntriesForCTSExpense(importedExpense, sequenceHelper, travelDocument.getTravelDocumentIdentifier());
            for (GeneralLedgerPendingEntry glpe : creditEntries) {
                travelDocument.addPendingEntry(glpe);
            }
        }
    }

    protected ExpenseTypeObjectCode getExpenseTypeObjectCode(TravelDocument document, HistoricalTravelExpense expense) {
        TemConstants.ExpenseTypeMetaCategory expenseTypeCategory = expense.getAgencyStagingData().getExpenseTypeCategory();
        ExpenseType expenseType = this.getTravelExpenseService().getDefaultExpenseTypeForCategory(expenseTypeCategory);
        String documentType = document.getDocumentTypeName();
        String tripType = StringUtils.isBlank((String)document.getTripTypeCode()) ? "All" : document.getTripTypeCode();
        String travelerType = ObjectUtils.isNull((Object)((Object)document.getTraveler())) || StringUtils.isBlank((String)document.getTraveler().getTravelerTypeCode()) ? "All" : document.getTraveler().getTravelerTypeCode();
        ExpenseTypeObjectCode expenseTypeObjectCode = this.getTravelExpenseService().getExpenseType(expenseType.getCode(), documentType, tripType, travelerType);
        return expenseTypeObjectCode;
    }

    @Override
    public void updateExpense(TravelDocument travelDocument) {
        List<HistoricalTravelExpense> historicalTravelExpenses = travelDocument.getHistoricalTravelExpenses();
        for (HistoricalTravelExpense historicalTravelExpense : historicalTravelExpenses) {
            if (historicalTravelExpense.getAgencyStagingDataId() == null || !StringUtils.isBlank((String)historicalTravelExpense.getReconciled()) && !StringUtils.equals((String)historicalTravelExpense.getReconciled(), (String)"N")) continue;
            long time = new java.util.Date().getTime();
            historicalTravelExpense.setReconciliationDate(new Date(time));
            historicalTravelExpense.setReconciled("R");
        }
        this.getBusinessObjectService().save(historicalTravelExpenses);
    }

    public void setImportedExpensePendingEntryService(ImportedExpensePendingEntryService importedExpensePendingEntryService) {
        this.importedExpensePendingEntryService = importedExpensePendingEntryService;
    }

    public TravelExpenseService getTravelExpenseService() {
        return this.travelExpenseService;
    }

    public void setTravelExpenseService(TravelExpenseService travelExpenseService) {
        this.travelExpenseService = travelExpenseService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    class AccountingInfoKey {
        protected String chartOfAccountsCode;
        protected String accountNumber;
        protected String subAccountNumber;
        protected String financialObjectCode;
        protected String financialSubObjectCode;
        protected String projectCode;
        protected String organizationReferenceId;
        protected HistoricalTravelExpense historicalTravelExpense;

        public AccountingInfoKey(TripAccountingInformation info, HistoricalTravelExpense expense) {
            this.chartOfAccountsCode = info.getTripChartCode();
            this.accountNumber = info.getTripAccountNumber();
            this.subAccountNumber = info.getTripSubAccountNumber();
            this.projectCode = info.getProjectCode();
            this.organizationReferenceId = info.getOrganizationReference();
            this.historicalTravelExpense = expense;
        }

        public AccountingInfoKey(TemSourceAccountingLine accountingLine) {
            this.chartOfAccountsCode = accountingLine.getChartOfAccountsCode();
            this.accountNumber = accountingLine.getAccountNumber();
            this.subAccountNumber = accountingLine.getSubAccountNumber();
            this.financialObjectCode = accountingLine.getFinancialObjectCode();
            this.financialSubObjectCode = accountingLine.getFinancialSubObjectCode();
            this.projectCode = accountingLine.getProjectCode();
            this.organizationReferenceId = accountingLine.getOrganizationReferenceId();
        }

        public String getChartOfAccountsCode() {
            return this.chartOfAccountsCode;
        }

        public String getAccountNumber() {
            return this.accountNumber;
        }

        public String getSubAccountNumber() {
            if (this.subAccountNumber == null) {
                return "";
            }
            return this.subAccountNumber;
        }

        public String getFinancialObjectCode() {
            return this.financialObjectCode;
        }

        public String getFinancialSubObjectCode() {
            if (this.financialSubObjectCode == null) {
                return "";
            }
            return this.financialSubObjectCode;
        }

        public String getProjectCode() {
            if (this.projectCode == null) {
                return "";
            }
            return this.projectCode;
        }

        public String getOrganizationReferenceId() {
            if (this.organizationReferenceId == null) {
                return "";
            }
            return this.organizationReferenceId;
        }

        public HistoricalTravelExpense getHistoricalTravelExpense() {
            return this.historicalTravelExpense;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof AccountingInfoKey)) {
                return false;
            }
            AccountingInfoKey key = (AccountingInfoKey)o;
            EqualsBuilder equalsBuilder = new EqualsBuilder();
            equalsBuilder.append((Object)this.getChartOfAccountsCode(), (Object)key.getChartOfAccountsCode());
            equalsBuilder.append((Object)this.getAccountNumber(), (Object)key.getAccountNumber());
            equalsBuilder.append((Object)this.getSubAccountNumber(), (Object)key.getSubAccountNumber());
            equalsBuilder.append((Object)this.getProjectCode(), (Object)key.getProjectCode());
            equalsBuilder.append((Object)this.getOrganizationReferenceId(), (Object)key.getOrganizationReferenceId());
            return equalsBuilder.isEquals();
        }

        public int hashCode() {
            HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
            hashCodeBuilder.append((Object)this.getChartOfAccountsCode());
            hashCodeBuilder.append((Object)this.getAccountNumber());
            hashCodeBuilder.append((Object)this.getSubAccountNumber());
            hashCodeBuilder.append((Object)this.getProjectCode());
            hashCodeBuilder.append((Object)this.getOrganizationReferenceId());
            return hashCodeBuilder.toHashCode();
        }
    }
}

