/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.math.BigDecimal;
import java.sql.Date;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.validation.impl.ActualExpenseDetailValidation;
import org.kuali.kfs.module.tem.document.validation.impl.TemDocumentExpenseLineValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.krad.bo.BusinessObject;

public class TravelDocumentActualExpenseDetailLineValidation
extends TemDocumentExpenseLineValidation
implements ActualExpenseDetailValidation {
    protected ActualExpense actualExpenseForValidation;
    protected ActualExpense actualExpenseDetailForValidation;
    protected DataDictionaryService dataDictionaryService;

    public boolean validate(AttributedDocumentEvent event) {
        TravelDocument travelDocument = (TravelDocument)event.getDocument();
        boolean success = this.validateDetail(travelDocument);
        return success;
    }

    public boolean validateDetail(TravelDocument travelDocument) {
        boolean success = this.getDictionaryValidationService().isBusinessObjectValid((BusinessObject)this.getActualExpenseDetailForValidation(), "");
        if (success) {
            success &= this.validateMileageRules(travelDocument);
            success &= this.validateLodgingRules(travelDocument);
            if (this.getActualExpenseDetailForValidation().getExpenseAmount().isNegative()) {
                GlobalVariables.getMessageMap().putError("expenseAmount", "error.document.detail.less.than.zero", new String[0]);
                success = false;
            }
            if (!this.getActualExpenseDetailForValidation().isMileage() && this.getActualExpenseForValidation().getExpenseAmount().isLessThan((AbstractKualiDecimal)this.getActualExpenseForValidation().getTotalDetailExpenseAmount())) {
                GlobalVariables.getMessageMap().putError("expenseAmount", "error.document.detail.greater.than.expense", new String[0]);
                success = false;
            }
        }
        if (success && !this.getActualExpenseDetailForValidation().getCurrencyRate().equals(BigDecimal.ONE)) {
            GlobalVariables.getMessageMap().putInfo("expenseAmount", "info.document.tem.travel.import.currency.conversion", new String[0]);
        }
        return success;
    }

    protected boolean validateMileageRules(TravelDocument document) {
        boolean valid = true;
        if (this.getActualExpenseDetailForValidation().isMileage()) {
            Date effectiveDate = document.getEffectiveDateForMileageRate(this.getActualExpenseDetailForValidation());
            boolean bl = valid = ObjectUtils.isNotNull((Object)this.getActualExpenseDetailForValidation().getMiles()) && this.getActualExpenseDetailForValidation().getMiles() > 0 && (ObjectUtils.isNotNull((Object)((Object)this.getActualExpenseDetailForValidation().getMileageRate(effectiveDate))) || ObjectUtils.isNotNull((Object)this.getActualExpenseDetailForValidation().getMileageOtherRate()) && this.getActualExpenseDetailForValidation().getMileageOtherRate().compareTo(BigDecimal.ZERO) > 0);
            if (valid) {
                if (ObjectUtils.isNotNull((Object)this.getActualExpenseDetailForValidation().getMileageOtherRate())) {
                    BigDecimal maxMileageRate = this.getMaxMileageRate();
                    if (this.getActualExpenseDetailForValidation().getMileageOtherRate().compareTo(maxMileageRate) > 0) {
                        GlobalVariables.getMessageMap().putError("miles", "error.document.tem.actualexpense.mileagerateexceed", new String[]{this.getActualExpenseDetailForValidation().getMileageOtherRate().toString(), maxMileageRate.toString()});
                        valid = false;
                    }
                }
            } else {
                String label = this.getDataDictionaryService().getAttributeLabel(ActualExpense.class, "miles") + ", " + this.getDataDictionaryService().getAttributeLabel(ActualExpense.class, "mileageRateId") + " or " + this.getDataDictionaryService().getAttributeLabel(ActualExpense.class, "mileageOtherRate");
                GlobalVariables.getMessageMap().putError("miles", "error.required", new String[]{label});
            }
            if (this.isPerDiemMileageEntered(this.getActualExpenseDetailForValidation().getExpenseDate(), document.getPerDiemExpenses())) {
                valid &= this.addPerDiemError(TemConstants.PerDiemType.mileage, false);
            }
        }
        return valid;
    }

    protected boolean validateLodgingRules(TravelDocument document) {
        boolean valid = true;
        if (this.getActualExpenseDetailForValidation().isLodging() && this.isPerDiemLodgingEntered(this.getActualExpenseDetailForValidation().getExpenseDate(), document.getPerDiemExpenses())) {
            valid &= this.addPerDiemError(TemConstants.PerDiemType.lodging, false);
        }
        return valid;
    }

    public ActualExpense getActualExpenseForValidation() {
        return this.actualExpenseForValidation;
    }

    @Override
    public void setActualExpenseForValidation(ActualExpense actualExpenseForValidation) {
        this.actualExpenseForValidation = actualExpenseForValidation;
    }

    public ActualExpense getActualExpenseDetailForValidation() {
        return this.actualExpenseDetailForValidation;
    }

    @Override
    public void setActualExpenseDetailForValidation(ActualExpense actualExpenseDetailForValidation) {
        this.actualExpenseDetailForValidation = actualExpenseDetailForValidation;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

