/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.dao.DocumentDao;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.AccountingDocumentRelationship;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.document.TravelAuthorizationAmendmentDocument;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.AccountingDocumentRelationshipService;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.document.web.struts.Inquisitive;
import org.kuali.kfs.module.tem.document.web.struts.QuestionHandler;
import org.kuali.kfs.module.tem.document.web.struts.StrutsInquisitor;
import org.kuali.kfs.module.tem.document.web.struts.TravelAuthorizationForm;
import org.kuali.kfs.module.tem.service.TravelExpenseService;
import org.kuali.kfs.module.tem.service.TravelService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeIndexingQueue;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class AmendQuestionHandler
implements QuestionHandler<TravelDocument> {
    protected ConfigurationService ConfigurationService;
    protected DataDictionaryService dataDictionaryService;
    protected TravelService travelService;
    protected TravelDocumentService travelDocumentService;
    protected TravelExpenseService travelExpenseService;
    protected DocumentService documentService;
    protected DocumentDao documentDao;
    protected AccountingDocumentRelationshipService accountingDocumentRelationshipService;
    protected NoteService noteService;

    @Override
    public <T> T handleResponse(Inquisitive<TravelDocument, ?> asker) throws Exception {
        if (asker.denied("AmendmentTa")) {
            return (T)asker.back();
        }
        if (asker.confirmed("ConfirmAmendment")) {
            return (T)asker.end();
        }
        TravelDocument document = asker.getDocument();
        String note = this.createNote(asker.getReason(), document.getDocumentNumber());
        StringBuilder noteText = new StringBuilder(note);
        int noteTextLength = noteText.length();
        int noteTextMaxLength = this.getDataDictionaryService().getAttributeMaxLength(Note.class, "noteText");
        if (StringUtils.isBlank((String)asker.getReason()) || noteTextLength > noteTextMaxLength) {
            int reasonLimit = noteTextMaxLength - noteTextLength;
            reasonLimit = reasonLimit < 0 ? reasonLimit * -1 : reasonLimit;
            String message = this.getMessageFrom("travelAuthorization.question.text");
            String question = StringUtils.replace((String)message, (String)"{0}", (String)"Amend");
            if (StringUtils.isBlank((String)asker.getReason())) {
                return (T)asker.confirm("AmendmentTa", question, true, "error.travelAuthorization.reasonRequired", "reason", "Amend");
            }
            return (T)asker.confirm("AmendmentTa", question, true, "error.travelAuthorization.reason.pastLimit", "reason", new Integer(reasonLimit).toString());
        }
        Object previousDocumentId = null;
        ActionForward returnActionForward = null;
        returnActionForward = ((StrutsInquisitor)asker).getMapping().findForward("basic");
        Note newNote = this.getDocumentService().createNoteFromDocument((Document)document, noteText.toString());
        newNote.setNoteText(noteText.toString());
        this.getNoteService().save(newNote);
        document.updateAndSaveAppDocStatus("Pending Amendment");
        TravelAuthorizationAmendmentDocument taaDocument = ((TravelAuthorizationDocument)document).toCopyTAA();
        Note secondNote = this.getDocumentService().createNoteFromDocument((Document)document, this.getMessageFrom("travelAuthorization.message.amend.text"));
        Principal systemUser = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("kfs");
        secondNote.setAuthorUniversalIdentifier(systemUser.getPrincipalId());
        document.addNote(secondNote);
        DocumentAttributeIndexingQueue documentAttributeIndexingQueue = KewApiServiceLocator.getDocumentAttributeIndexingQueue();
        documentAttributeIndexingQueue.indexDocument(document.getDocumentNumber());
        TravelAuthorizationForm form = (TravelAuthorizationForm)((StrutsInquisitor)asker).getForm();
        form.setDocTypeName("TAA");
        form.setDocument((Document)taaDocument);
        this.addActualExpenseNewDetailLines(form);
        taaDocument.setApplicationDocumentStatus("Change In Process");
        this.getDocumentService().saveDocument((Document)taaDocument);
        String documentType = document instanceof TravelAuthorizationAmendmentDocument ? "TAA" : "TA";
        String relationDescription = documentType + " - " + "TAA";
        this.accountingDocumentRelationshipService.save(new AccountingDocumentRelationship(document.getDocumentNumber(), taaDocument.getDocumentNumber(), relationDescription));
        if (documentType.equals("TAA")) {
            relationDescription = "TA - TAA";
            List<Document> travelAuthDocs = this.travelDocumentService.getDocumentsRelatedTo(document, "TA");
            this.accountingDocumentRelationshipService.save(new AccountingDocumentRelationship(travelAuthDocs.get(0).getDocumentNumber(), taaDocument.getDocumentNumber(), relationDescription));
        }
        if (ObjectUtils.isNotNull((Object)returnActionForward)) {
            return (T)returnActionForward;
        }
        String message = this.getMessageFrom("travelAuthorization.question.text");
        String question = StringUtils.replace((String)message, (String)"{0}", (String)"Amend");
        return (T)asker.confirm("AmendmentTa", question, true, "temSingleConfirmationQuestion", "AmendmentTa", "");
    }

    protected String createNote(String reason, String documentNumber) {
        String introNoteMessage = "Note entered while amending a Travel Authorization :  ";
        String suffix = StringUtils.replace((String)"(Previous Document Id is {0})", (String)"{0}", (String)documentNumber);
        return introNoteMessage + reason + " " + suffix;
    }

    @Override
    public <T> T askQuestion(Inquisitive<TravelDocument, ?> asker) throws Exception {
        String key = this.getMessageFrom("travelAuthorization.question.text");
        String question = StringUtils.replace((String)key, (String)"{0}", (String)"Amend");
        Object retval = asker.confirm("AmendmentTa", question, true, new String[0]);
        return (T)retval;
    }

    public String getReturnToFiscalOfficerQuestion(String operation) {
        String message = "";
        String key = this.getConfigurationService().getPropertyValueAsString("travelAuthorization.question.text");
        message = StringUtils.replace((String)key, (String)"{0}", (String)operation);
        return message;
    }

    public String getMessageFrom(String messageType) {
        return this.getConfigurationService().getPropertyValueAsString(messageType);
    }

    public String getReturnToFiscalOfficerNote(String notePrefix, String reason) {
        String noteText = "";
        String introNoteMessage = notePrefix + " ";
        noteText = introNoteMessage + reason;
        int noteTextLength = noteText.length();
        int noteTextMaxLength = this.getDataDictionaryService().getAttributeMaxLength(Note.class, "noteText");
        if (StringUtils.isBlank((String)reason) || noteTextLength > noteTextMaxLength) {
            int reasonLimit = noteTextMaxLength - noteTextLength;
            if (ObjectUtils.isNull((Object)reason)) {
                reason = "";
            }
        }
        return noteText;
    }

    protected void addActualExpenseNewDetailLines(TravelAuthorizationForm form) {
        form.setNewActualExpenseLines(new ArrayList<ActualExpense>());
        for (ActualExpense actualExpense : form.getTravelAuthorizationDocument().getActualExpenses()) {
            ActualExpense detail = this.getTravelExpenseService().createNewDetailForActualExpense(actualExpense);
            form.getNewActualExpenseLines().add(detail);
        }
    }

    public void setConfigurationService(ConfigurationService ConfigurationService2) {
        this.ConfigurationService = ConfigurationService2;
    }

    protected ConfigurationService getConfigurationService() {
        return this.ConfigurationService;
    }

    public void setTravelService(TravelService travelService) {
        this.travelService = travelService;
    }

    protected TravelService getTravelService() {
        return this.travelService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    protected DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public DocumentDao getDocumentDao() {
        return this.documentDao;
    }

    public void setDocumentDao(DocumentDao documentDao) {
        this.documentDao = documentDao;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected DocumentService getDocumentService() {
        return (DocumentService)SpringContext.getBean(DocumentService.class);
    }

    public AccountingDocumentRelationshipService getAccountingDocumentRelationshipService() {
        return this.accountingDocumentRelationshipService;
    }

    public void setAccountingDocumentRelationshipService(AccountingDocumentRelationshipService accountingDocumentRelationshipService) {
        this.accountingDocumentRelationshipService = accountingDocumentRelationshipService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }

    public NoteService getNoteService() {
        return this.noteService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    public TravelExpenseService getTravelExpenseService() {
        return this.travelExpenseService;
    }

    public void setTravelExpenseService(TravelExpenseService travelExpenseService) {
        this.travelExpenseService = travelExpenseService;
    }
}

