/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.kns.web.ui.ExtraButton;
import org.kuali.kfs.kns.web.ui.HeaderField;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.document.CardApplicationDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.web.struts.FinancialSystemTransactionalDocumentFormBase;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.identity.Person;

public class TemCardApplicationForm
extends FinancialSystemTransactionalDocumentFormBase {
    ConfigurationService ConfigurationService;
    private boolean fiscalOfficer = false;
    private boolean travelManager = false;
    private boolean appliedToBank = false;
    private boolean initiator = false;
    private boolean emptyAccount = false;
    private boolean emptyProfile = false;
    private boolean multipleApplications = false;

    public List<ExtraButton> getExtraButtons() {
        List extraButtons = super.getExtraButtons();
        if (this.isTravelManager()) {
            String documentStatus = this.getDocument().getDocumentHeader().getWorkflowDocument().getApplicationDocumentStatus();
            if ("Pending Bank Application".equals(documentStatus) || "Travel Office Review".equals(documentStatus)) {
                this.getDocumentActions().remove("canApprove");
            }
            String applyToBankButtonURL = this.getConfigurationService().getPropertyValueAsString("externalizable.images.url");
            String submitButtonURL = this.getConfigurationService().getPropertyValueAsString("kr.externalizable.images.url");
            if ("Pending Bank Application".equals(documentStatus)) {
                this.addExtraButton("methodToCall.applyToBank", applyToBankButtonURL + "buttonsmall_applytobank.gif", "Apply To Bank");
            } else if ("Travel Office Review".equals(documentStatus)) {
                this.addExtraButton("methodToCall.submit", submitButtonURL + "buttonsmall_submit.gif", "Submit");
            }
        }
        return extraButtons;
    }

    public ConfigurationService getConfigurationService() {
        if (this.ConfigurationService == null) {
            this.ConfigurationService = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        }
        return this.ConfigurationService;
    }

    protected void addExtraButton(String property, String source, String altText) {
        ExtraButton newButton = new ExtraButton();
        newButton.setExtraButtonProperty(property);
        newButton.setExtraButtonSource(source);
        newButton.setExtraButtonAltText(altText);
        this.extraButtons.add(newButton);
    }

    public boolean isFiscalOfficer() {
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        CardApplicationDocument document = (CardApplicationDocument)this.getDocument();
        TemProfile profile = document.getTemProfile();
        if (profile != null) {
            Account account = null;
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("chartOfAccountsCode", profile.getDefaultChartCode());
            fieldValues.put("accountNumber", profile.getDefaultAccount());
            account = (Account)this.getBusinessObjectService().findByPrimaryKey(Account.class, fieldValues);
            return currentUser.getPrincipalId().equals(account.getAccountFiscalOfficerSystemIdentifier());
        }
        return false;
    }

    public boolean isTravelManager() {
        Person currentUser = GlobalVariables.getUserSession().getPerson();
        return ((TravelDocumentService)SpringContext.getBean(TravelDocumentService.class)).isTravelManager(currentUser);
    }

    public boolean isAppliedToBank() {
        CardApplicationDocument document = (CardApplicationDocument)this.getDocument();
        if ("Applied To Bank".equals(document.getDocumentHeader().getWorkflowDocument().getApplicationDocumentStatus()) || "Approved".equals(document.getDocumentHeader().getWorkflowDocument().getApplicationDocumentStatus()) || "Approved By Bank".equals(document.getDocumentHeader().getWorkflowDocument().getApplicationDocumentStatus()) || "Declined".equals(document.getDocumentHeader().getWorkflowDocument().getApplicationDocumentStatus())) {
            this.setAppliedToBank(true);
        }
        return this.appliedToBank;
    }

    public void setAppliedToBank(boolean appliedToBank) {
        this.appliedToBank = appliedToBank;
    }

    public boolean isInitiator() {
        return this.initiator;
    }

    public void setInitiator(boolean initiator) {
        this.initiator = initiator;
    }

    public boolean isEmptyAccount() {
        return this.emptyAccount;
    }

    public void setEmptyAccount(boolean emptyAccount) {
        this.emptyAccount = emptyAccount;
    }

    public boolean isEmptyProfile() {
        return this.emptyProfile;
    }

    public boolean isMultipleApplications() {
        return this.multipleApplications;
    }

    public void setMultipleApplications(boolean multipleApplications) {
        this.multipleApplications = multipleApplications;
    }

    public void setEmptyProfile(boolean emptyProfile) {
        this.emptyProfile = emptyProfile;
    }

    protected String getStatusCodeFieldName() {
        return "dummyAppDocStatus";
    }

    public void populateHeaderFields(WorkflowDocument workflowDocument) {
        super.populateHeaderFields(workflowDocument);
        CardApplicationDocument document = (CardApplicationDocument)this.getDocument();
        String status = "Application";
        String appDocStatus = document.getDocumentHeader().getWorkflowDocument().getApplicationDocumentStatus();
        this.getDocInfo().add(new HeaderField(this.getDataDictionaryAttributeName(this.getStatusCodeFieldName()), StringUtils.isBlank((String)appDocStatus) ? status : appDocStatus));
    }

    protected String getDataDictionaryAttributeName(String attrName) {
        return "DataDictionary." + this.getDocument().getClass().getSimpleName() + ".attributes." + attrName;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    }
}

