/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.web.struts;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.AccountingDistribution;
import org.kuali.kfs.module.tem.businessobject.AccountingDocumentRelationship;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.PerDiemExpense;
import org.kuali.kfs.module.tem.businessobject.SpecialCircumstances;
import org.kuali.kfs.module.tem.document.TravelAuthorizationCloseDocument;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelDocumentBase;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.document.authorization.TravelReimbursementAuthorizer;
import org.kuali.kfs.module.tem.document.service.TravelAuthorizationService;
import org.kuali.kfs.module.tem.document.service.TravelReimbursementService;
import org.kuali.kfs.module.tem.document.web.bean.TravelReimbursementMvcWrapperBean;
import org.kuali.kfs.module.tem.document.web.struts.HistoryValueObject;
import org.kuali.kfs.module.tem.document.web.struts.TravelActionBase;
import org.kuali.kfs.module.tem.document.web.struts.TravelFormBase;
import org.kuali.kfs.module.tem.document.web.struts.TravelReimbursementForm;
import org.kuali.kfs.module.tem.pdf.Coversheet;
import org.kuali.kfs.module.tem.report.ExpenseSummaryReport;
import org.kuali.kfs.module.tem.report.NonEmployeeCertificationReport;
import org.kuali.kfs.module.tem.report.SummaryByDayReport;
import org.kuali.kfs.module.tem.report.service.ExpenseSummaryReportService;
import org.kuali.kfs.module.tem.report.service.NonEmployeeCertificationReportService;
import org.kuali.kfs.module.tem.report.service.SummaryByDayReportService;
import org.kuali.kfs.module.tem.report.util.BarcodeHelper;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.report.ReportInfo;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class TravelReimbursementAction
extends TravelActionBase {
    public static Logger LOG = Logger.getLogger(TravelReimbursementAction.class);

    @Override
    protected void loadDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.loadDocument(kualiDocumentFormBase);
        TravelReimbursementForm reimbForm = (TravelReimbursementForm)kualiDocumentFormBase;
        TravelReimbursementDocument document = reimbForm.getTravelReimbursementDocument();
        this.refreshCollectionsFor(document);
        this.initializeAssignAccounts(reimbForm);
        reimbForm.setDistribution(this.getAccountingDistributionService().buildDistributionFrom(document));
    }

    protected void refreshCollectionsFor(TravelReimbursementDocument reimbursement) {
        if (!reimbursement.getDocumentHeader().getWorkflowDocument().isInitiated()) {
            LOG.debug((Object)"Refreshing objects in reimbursement");
            reimbursement.refreshReferenceObject("perDiemExpenses");
            reimbursement.refreshReferenceObject("traveler");
            reimbursement.refreshReferenceObject("tripType");
            reimbursement.refreshReferenceObject("actualExpenses");
            reimbursement.refreshReferenceObject("primaryDestination");
            reimbursement.refreshReferenceObject("specialCircumstances");
        }
    }

    protected void setButtonPermissions(TravelReimbursementForm form) {
        this.canSave(form);
        this.setCanReturnToFisicalOfficer(form);
        this.setCanCertify(form);
        this.setCanCalculate(form);
    }

    protected void canSave(TravelReimbursementForm reqForm) {
        boolean can;
        boolean bl = can = !this.isFinal(reqForm) && !this.isProcessed(reqForm);
        if (can) {
            TravelReimbursementAuthorizer documentAuthorizer = (TravelReimbursementAuthorizer)this.getDocumentAuthorizer((KualiDocumentFormBase)reqForm);
            can = documentAuthorizer.canSave((Document)reqForm.getTravelDocument(), GlobalVariables.getUserSession().getPerson());
        }
        if (!can) {
            boolean isDelinquent;
            TravelReimbursementDocument tr = (TravelReimbursementDocument)reqForm.getDocument();
            boolean isTravelManager = this.getTravelDocumentService().isTravelManager(GlobalVariables.getUserSession().getPerson());
            boolean bl2 = isDelinquent = tr.getDelinquentAction() != null;
            if (isTravelManager && isDelinquent) {
                can = true;
            }
        }
        if (can) {
            reqForm.getDocumentActions().put("canSave", true);
        } else {
            reqForm.getDocumentActions().remove("canSave");
        }
    }

    protected void setCanCertify(TravelReimbursementForm form) {
        TravelReimbursementAuthorizer authorizer = (TravelReimbursementAuthorizer)this.getDocumentAuthorizer((KualiDocumentFormBase)form);
        form.setCanCertify(authorizer.canCertify(form.getTravelReimbursementDocument(), GlobalVariables.getUserSession().getPerson()));
    }

    public ActionForward printCoversheet(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelReimbursementForm reimbForm = (TravelReimbursementForm)form;
        String documentNumber = request.getParameter("documentNumber");
        if (documentNumber != null && !documentNumber.isEmpty()) {
            reimbForm.setDocument((Document)this.getTravelReimbursementService().find(documentNumber));
        }
        TravelReimbursementDocument reimbursement = reimbForm.getTravelReimbursementDocument();
        Coversheet cover = this.getTravelReimbursementService().generateCoversheetFor(reimbursement);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        cover.print(stream);
        WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)stream, (String)String.format("%s_cover_sheet.pdf", reimbursement.getTravelDocumentIdentifier()));
        return null;
    }

    public ActionForward viewExpenseSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelReimbursementForm reimbForm = (TravelReimbursementForm)form;
        reimbForm.setDocument((Document)this.getTravelReimbursementService().find(request.getParameter("documentNumber")));
        TravelReimbursementDocument reimbursement = reimbForm.getTravelReimbursementDocument();
        ExpenseSummaryReport report = this.getExpenseSummaryReportService().buildReport(reimbursement);
        ByteArrayOutputStream baos = this.getTravelReportService().buildReport((ReportInfo)report);
        WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)baos, (String)String.format("%s_Expense_Summary", reimbursement.getTravelDocumentIdentifier()));
        return null;
    }

    public ActionForward viewSummaryByDay(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelReimbursementForm reimbForm = (TravelReimbursementForm)form;
        reimbForm.setDocument((Document)this.getTravelReimbursementService().find(request.getParameter("documentNumber")));
        TravelReimbursementDocument reimbursement = reimbForm.getTravelReimbursementDocument();
        SummaryByDayReport report = this.getSummaryByDayReportService().buildReport(reimbursement);
        ByteArrayOutputStream baos = this.getTravelReportService().buildReport((ReportInfo)report);
        WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)baos, (String)String.format("%s_Summary_By_Day", reimbursement.getTravelDocumentIdentifier()));
        return null;
    }

    public ActionForward viewNonEmployeeForms(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelReimbursementForm reimbForm = (TravelReimbursementForm)form;
        reimbForm.setDocument((Document)this.getTravelReimbursementService().find(request.getParameter("documentNumber")));
        TravelReimbursementDocument reimbursement = reimbForm.getTravelReimbursementDocument();
        NonEmployeeCertificationReport report = this.getNonEmployeeCertificationReportService().buildReport(reimbursement);
        BarcodeHelper barcode = new BarcodeHelper();
        report.setBarcodeImage(barcode.generateBarcodeImage(reimbursement.getDocumentNumber()));
        File reportFile = this.getNonEmployeeCertificationReportService().generateReport(report);
        StringBuilder fileName = new StringBuilder();
        fileName.append(reimbursement.getTravelDocumentIdentifier());
        fileName.append("_Non_Employee_Certification");
        fileName.append(".pdf");
        if (reportFile.length() == 0L) {
            return mapping.findForward("basic");
        }
        this.displayPDF(request, response, reportFile, fileName);
        return null;
    }

    protected void initializePerDiem(TravelReimbursementDocument reimbursement, TravelAuthorizationDocument authorization) {
        for (PerDiemExpense estimate : authorization.getPerDiemExpenses()) {
            PerDiemExpense mileage = this.getTravelDocumentService().copyPerDiemExpense(estimate);
            mileage.setDocumentNumber(reimbursement.getDocumentNumber());
            if (StringUtils.isBlank((String)mileage.getMileageRateExpenseTypeCode())) continue;
            LOG.debug((Object)("Adding mileage for estimate with date " + estimate.getMileageDate()));
            reimbursement.getPerDiemExpenses().add(mileage);
        }
    }

    @Override
    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelReimbursementForm reimbForm = (TravelReimbursementForm)form;
        ActionForward actionAfterPrimaryDestinationLookup = this.refreshAfterPrimaryDestinationLookup(mapping, reimbForm, request);
        if (actionAfterPrimaryDestinationLookup != null) {
            return actionAfterPrimaryDestinationLookup;
        }
        return super.refresh(mapping, form, request, response);
    }

    @Override
    protected void performRequesterRefresh(TravelDocument document, TravelFormBase travelForm, HttpServletRequest request) {
        String travelerTypeCode = request.getParameter("document.traveler.travelerTypeCode");
        if (StringUtils.isNotEmpty((String)travelerTypeCode)) {
            document.getTraveler().setTravelerTypeCode(travelerTypeCode);
        }
        document.getTraveler().refreshReferenceObject("travelerType");
        ((TravelReimbursementDocument)document).updatePayeeTypeForReimbursable();
        this.updateAccountsWithNewProfile(travelForm, document.getTemProfile());
    }

    protected Integer getPerDiemActionLineNumber(HttpServletRequest request) {
        for (String parameterKey : request.getParameterMap().keySet()) {
            if (!StringUtils.containsIgnoreCase((String)parameterKey, (String)"perDiemExpenses")) continue;
            return this.getLineNumberFromParameter(parameterKey);
        }
        return -1;
    }

    protected PerDiemExpense getPerDiemActionLine(HttpServletRequest request, TravelReimbursementDocument reimbursement) {
        int lineNum = this.getPerDiemActionLineNumber(request);
        if (lineNum < 0) {
            return null;
        }
        return reimbursement.getPerDiemExpenses().get(lineNum);
    }

    protected TravelAuthorizationDocument getTravelAuthorization(String travelDocumentIdentifier) {
        Collection<TravelAuthorizationDocument> taList = this.getTravelAuthorizationService().find(travelDocumentIdentifier);
        if (ObjectUtils.isNotNull(taList) && taList.iterator().hasNext()) {
            return taList.iterator().next();
        }
        return null;
    }

    public ActionForward addOtherExpenseDetailLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelReimbursementForm reimbForm = (TravelReimbursementForm)form;
        TravelReimbursementMvcWrapperBean mvcWrapper = (TravelReimbursementMvcWrapperBean)this.newMvcDelegate(form);
        reimbForm.getObservable().notifyObservers(new Object[]{mvcWrapper, this.getSelectedLine(request)});
        KualiDecimal totalRemaining = KualiDecimal.ZERO;
        for (AccountingDistribution dist : reimbForm.getDistribution()) {
            totalRemaining = (KualiDecimal)totalRemaining.add((AbstractKualiDecimal)dist.getRemainingAmount());
        }
        request.setAttribute("remainingDistribution", (Object)totalRemaining);
        return mapping.findForward("basic");
    }

    public ActionForward deleteOtherExpenseDetailLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelReimbursementForm reimbForm = (TravelReimbursementForm)form;
        TravelReimbursementDocument document = (TravelReimbursementDocument)reimbForm.getDocument();
        TravelReimbursementMvcWrapperBean mvcWrapper = (TravelReimbursementMvcWrapperBean)this.newMvcDelegate(form);
        reimbForm.getObservable().notifyObservers(new Object[]{mvcWrapper, this.getSelectedOtherExpenseIndex(request, document), this.getSelectedLine(request)});
        return mapping.findForward("basic");
    }

    protected Class getMvcWrapperInterface() {
        return TravelReimbursementMvcWrapperBean.class;
    }

    @Override
    protected void createDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.createDocument(kualiDocumentFormBase);
        TravelReimbursementForm travelForm = (TravelReimbursementForm)kualiDocumentFormBase;
        TravelReimbursementDocument document = (TravelReimbursementDocument)travelForm.getDocument();
        this.getTravelReimbursementService().addListenersTo(document);
        document.addContactInformation();
        if (!StringUtils.isBlank((String)travelForm.getTravelDocumentIdentifier())) {
            LOG.debug((Object)("Creating reimbursement for document number " + travelForm.getTravelDocumentIdentifier()));
            document.setTravelDocumentIdentifier(travelForm.getTravelDocumentIdentifier());
            TravelDocument rootDocument = this.getTravelDocumentService().findRootForTravelReimbursement(document.getTravelDocumentIdentifier());
            if (ObjectUtils.isNull((Object)rootDocument)) {
                String errorMsg = "Retrieved null TravelDocument when searching by travelDocumentIdentifier: " + document.getTravelDocumentIdentifier() + " Cannot create a new document";
                LOG.error((Object)errorMsg);
                throw new RuntimeException(errorMsg);
            }
            LOG.debug((Object)("Setting traveler with id " + rootDocument.getTravelerDetailId()));
            document.setTravelerDetailId(rootDocument.getTravelerDetailId());
            document.refreshReferenceObject("traveler");
            LOG.debug((Object)("Traveler is " + (Object)((Object)document.getTraveler()) + " with customer number " + document.getTraveler().getCustomerNumber()));
            if (document.getTraveler().getPrincipalId() != null) {
                document.getTraveler().setPrincipalName(this.getPersonService().getPerson(document.getTraveler().getPrincipalId()).getPrincipalName());
            }
            document.updatePayeeTypeForReimbursable();
            document.setPrimaryDestinationId(rootDocument.getPrimaryDestinationId());
            document.setPrimaryDestination(rootDocument.getPrimaryDestination());
            document.setTripDescription(rootDocument.getTripDescription());
            document.setTripType(rootDocument.getTripType());
            document.setTripTypeCode(rootDocument.getTripTypeCode());
            document.setPrimaryDestination(rootDocument.getPrimaryDestination());
            document.setTripBegin(rootDocument.getTripBegin());
            document.setTripEnd(rootDocument.getTripEnd());
            document.setPrimaryDestinationName(rootDocument.getPrimaryDestinationName());
            document.setPrimaryDestinationCounty(rootDocument.getPrimaryDestinationCounty());
            document.setPrimaryDestinationCountryState(rootDocument.getPrimaryDestinationCountryState());
            document.setGroupTravelers(this.getTravelDocumentService().copyGroupTravelers(rootDocument.getGroupTravelers(), document.getDocumentNumber()));
            document.setDelinquentTRException(rootDocument.getDelinquentTRException());
            document.setBlanketTravel(rootDocument.getBlanketTravel());
            document.setMealWithoutLodgingReason(rootDocument.getMealWithoutLodgingReason());
            document.configureTraveler(rootDocument.getTemProfileId(), rootDocument.getTraveler());
            document.setExpenseLimit(rootDocument.getExpenseLimit());
            document.setPerDiemAdjustment(rootDocument.getPerDiemAdjustment());
            document.getDocumentHeader().setOrganizationDocumentNumber(rootDocument.getDocumentHeader().getOrganizationDocumentNumber());
            if (document.getPrimaryDestinationId() != null && document.getPrimaryDestinationId() == Integer.MAX_VALUE) {
                document.getPrimaryDestination().setPrimaryDestinationName(document.getPrimaryDestinationName());
                document.getPrimaryDestination().setCounty(document.getPrimaryDestinationCounty());
                document.getPrimaryDestination().getRegion().setRegionName(document.getPrimaryDestinationCountryState());
                document.setPrimaryDestinationIndicator(true);
            }
            for (SpecialCircumstances rootSpecialCircumstances : rootDocument.getSpecialCircumstances()) {
                for (SpecialCircumstances circumstances : document.getSpecialCircumstances()) {
                    if (!circumstances.getQuestionId().equals(rootSpecialCircumstances.getQuestionId())) continue;
                    circumstances.setText(rootSpecialCircumstances.getText());
                }
            }
            if (rootDocument instanceof TravelAuthorizationDocument && this.isCopyPerDiemAndExpenses(document)) {
                this.initializePerDiem(document, (TravelAuthorizationDocument)rootDocument);
                document.setActualExpenses(this.getTravelDocumentService().copyActualExpenses(rootDocument.getActualExpenses(), document.getDocumentNumber()));
                if (document.getActualExpenses() != null && !document.getActualExpenses().isEmpty()) {
                    for (int i = 0; i < document.getActualExpenses().size(); ++i) {
                        travelForm.getNewActualExpenseLines().add(new ActualExpense());
                    }
                }
            }
            AccountingDocumentRelationship relationship = this.buildRelationshipToProgenitorDocument(rootDocument, document);
            this.getBusinessObjectService().save((PersistableBusinessObject)relationship);
        } else {
            document.setTripBegin(null);
            document.setTripEnd(null);
            document.setTripProgenitor(true);
        }
        travelForm.setDistribution(this.getAccountingDistributionService().buildDistributionFrom(travelForm.getTravelDocument()));
        this.initializeAssignAccounts(travelForm);
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelAuthorizationDocument authorization;
        ActionForward retval = super.execute(mapping, form, request, response);
        TravelReimbursementForm reimbForm = (TravelReimbursementForm)form;
        TravelReimbursementDocument document = ((TravelReimbursementForm)form).getTravelReimbursementDocument();
        String travelIdentifier = document.getTravelDocumentIdentifier();
        if (!StringUtils.isBlank((String)document.getTripTypeCode())) {
            if (ObjectUtils.isNull((Object)((Object)document.getTripType())) || !StringUtils.equals((String)document.getTripType().getCode(), (String)document.getTripTypeCode())) {
                document.refreshReferenceObject("tripType");
            }
        } else {
            document.setTripType(null);
        }
        this.setButtonPermissions(reimbForm);
        LOG.debug((Object)("Found " + document.getActualExpenses().size() + " other expenses"));
        if (reimbForm.getHistory() == null) {
            LOG.debug((Object)("Looking up history for TEM document number " + travelIdentifier));
            ArrayList<Serializable> history = new ArrayList<Serializable>();
            List<TravelReimbursementDocument> docs = this.getTravelReimbursementService().findByTravelId(travelIdentifier);
            LOG.debug((Object)("Got history of size " + docs.size()));
            for (TravelReimbursementDocument found : docs) {
                LOG.debug((Object)("Creating history object for document " + found));
                LOG.debug((Object)("Using header " + found.getDocumentHeader()));
                history.add(new HistoryValueObject(found));
            }
            reimbForm.setHistory(history);
        }
        if ((authorization = this.getTravelDocumentService().findCurrentTravelAuthorization(document)) instanceof TravelAuthorizationCloseDocument) {
            request.setAttribute("isClose", (Object)true);
        }
        this.disablePerDiemExpenes(document);
        if (ObjectUtils.isNotNull(document.getActualExpenses())) {
            document.enableExpenseTypeSpecificFields(document.getActualExpenses());
        }
        this.refreshRelatedDocuments(reimbForm);
        if (!reimbForm.getMethodToCall().equalsIgnoreCase("dochandler") && document.getTripType() != null) {
            KualiDecimal totalRemaining = KualiDecimal.ZERO;
            for (AccountingDistribution dist : reimbForm.getDistribution()) {
                totalRemaining = (KualiDecimal)totalRemaining.add((AbstractKualiDecimal)dist.getRemainingAmount());
            }
            request.setAttribute("remainingDistribution", (Object)totalRemaining);
        }
        this.showAccountDistribution(request, (Document)document);
        request.setAttribute("showReports", (Object)(!document.getDocumentHeader().getWorkflowDocument().isInitiated() ? 1 : 0));
        request.setAttribute("certificationStatement", (Object)this.getCertificationStatement(document));
        request.setAttribute("isEmployee", (Object)this.isEmployee(document.getTraveler()));
        request.setAttribute("delinquent", (Object)document.getDelinquentAction());
        LOG.debug((Object)("Found " + document.getActualExpenses().size() + " other expenses"));
        boolean showAdvances = this.getParameterService().getParameterValueAsBoolean(TravelReimbursementDocument.class, "DISPLAY_ADVANCES_IN_REIMBURSEMENT_TOTAL_IND");
        request.setAttribute("showAdvances", (Object)showAdvances);
        boolean showEncumbrance = this.getParameterService().getParameterValueAsBoolean(TravelReimbursementDocument.class, "DISPLAY_ENCUMBRANCE_IND");
        request.setAttribute("showEncumbrance", (Object)showEncumbrance);
        if (!this.getCalculateIgnoreList().contains(reimbForm.getMethodToCall())) {
            this.recalculateTripDetailTotalOnly(mapping, form, request, response);
        }
        this.getTravelDocumentService().showNoTravelAuthorizationError(document);
        KualiDecimal paymentTotal = document.getPaymentAmount();
        if (paymentTotal != null && !ObjectUtils.isNull((Object)((Object)document.getTravelPayment())) && paymentTotal.isGreaterEqual((AbstractKualiDecimal)KualiDecimal.ZERO)) {
            document.getTravelPayment().setCheckTotalAmount(paymentTotal);
        }
        if (reimbForm.getNewSourceLine() != null) {
            String objectCode = this.getObjectCodeForNewSourceAccountingLine(reimbForm);
            reimbForm.getNewSourceLine().setFinancialObjectCode(objectCode);
        }
        if (reimbForm.getAccountDistributionsourceAccountingLines() == null || reimbForm.getAccountDistributionsourceAccountingLines().isEmpty()) {
            this.initializeAssignAccounts(reimbForm);
        }
        return retval;
    }

    public ActionForward clearPerDiem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelReimbursementDocument reimbursement = ((TravelReimbursementForm)form).getTravelReimbursementDocument();
        reimbursement.setPerDiemExpenses(new ArrayList<PerDiemExpense>());
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward clearPerDiemExpenses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase reqForm = (TravelFormBase)form;
        TravelDocument document = reqForm.getTravelDocument();
        document.setPerDiemExpenses(new ArrayList<PerDiemExpense>());
        this.getTravelReimbursementService().enableDuplicateExpenses((TravelReimbursementDocument)document, null);
        return mapping.findForward("basic");
    }

    protected ActualExpense getSelectedOtherExpense(HttpServletRequest request, TravelReimbursementDocument document) {
        ActualExpense retval = null;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            int lineNumber = Integer.parseInt(StringUtils.substringBetween((String)parameterName, (String)"actualExpenses[", (String)"]."));
            retval = document.getActualExpenses().get(lineNumber);
        }
        return retval;
    }

    protected ActionForward returnToPreviousPage(ActionMapping mapping, KualiDocumentFormBase kualiDocumentFormBase) {
        return mapping.findForward("basic");
    }

    public ActionForward recalculate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelFormBase travelReqForm = (TravelFormBase)form;
        TravelDocumentBase travelReqDoc = (TravelDocumentBase)travelReqForm.getDocument();
        if (travelReqForm.getDocument() instanceof TravelReimbursementDocument) {
            boolean showAdvances = this.getParameterService().getParameterValueAsBoolean(TravelReimbursementDocument.class, "DISPLAY_ADVANCES_IN_REIMBURSEMENT_TOTAL_IND");
            request.setAttribute("showAdvances", (Object)showAdvances);
        }
        return this.recalculateTripDetailTotal(mapping, form, request, response);
    }

    @Override
    public ActionForward approve(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getTravelDocumentService().showNoTravelAuthorizationError(((TravelReimbursementForm)form).getTravelReimbursementDocument());
        return super.approve(mapping, form, request, response);
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.addAccountingDocumentRelationship(form);
        return super.save(mapping, form, request, response);
    }

    private void addAccountingDocumentRelationship(ActionForm form) throws WorkflowException {
        TravelDocument rootDocument;
        TravelReimbursementForm reqForm = (TravelReimbursementForm)form;
        TravelReimbursementDocument trDoc = reqForm.getTravelReimbursementDocument();
        String travelDocumentIdentifier = trDoc.getTravelDocumentIdentifier();
        if (ObjectUtils.isNotNull((Object)travelDocumentIdentifier) && ObjectUtils.isNotNull((Object)(rootDocument = this.getTravelDocumentService().findRootForTravelReimbursement(travelDocumentIdentifier)))) {
            String relationshipDescription = rootDocument.getDocumentTypeName() + " - " + trDoc.getDocumentTypeName();
            this.getAccountingDocumentRelationshipService().save(new AccountingDocumentRelationship(rootDocument.getDocumentNumber(), trDoc.getDocumentNumber(), relationshipDescription));
        }
    }

    protected int getSelectedOtherExpenseIndex(HttpServletRequest request, TravelReimbursementDocument document) {
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        LOG.debug((Object)("Getting selected other expense index from " + parameterName));
        if (StringUtils.isNotBlank((String)parameterName)) {
            return Integer.parseInt(StringUtils.substringBetween((String)parameterName, (String)"actualExpenses[", (String)"]."));
        }
        return -1;
    }

    @Override
    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getTravelDocumentService().showNoTravelAuthorizationError(((TravelReimbursementForm)form).getTravelReimbursementDocument());
        boolean showAccountDistribution = this.getParameterService().getParameterValueAsBoolean(TravelReimbursementDocument.class, "DISPLAY_ACCOUNTING_DISTRIBUTION_TAB_IND");
        request.setAttribute("accountDistribution", (Object)showAccountDistribution);
        ActionForward forward = super.route(mapping, form, request, response);
        if (!StringUtils.isBlank((String)forward.getPath()) && forward.getPath().indexOf("questionPrompt.do") < 0) {
            this.addDateChangedNote(form);
            this.addAccountingDocumentRelationship(form);
        }
        return forward;
    }

    @Override
    public ActionForward blanketApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getTravelDocumentService().showNoTravelAuthorizationError(((TravelReimbursementForm)form).getTravelReimbursementDocument());
        ActionForward forward = super.blanketApprove(mapping, form, request, response);
        if (!StringUtils.isBlank((String)forward.getPath()) && forward.getPath().indexOf("questionPrompt.do") < 0) {
            this.addDateChangedNote(form);
            this.addAccountingDocumentRelationship(form);
        }
        return forward;
    }

    protected void addDateChangedNote(ActionForm form) throws Exception {
        TravelAuthorizationDocument taDoc;
        TravelReimbursementForm reqForm = (TravelReimbursementForm)form;
        TravelReimbursementDocument travelReqDoc = reqForm.getTravelReimbursementDocument();
        String docId = travelReqDoc.getTravelDocumentIdentifier();
        if (ObjectUtils.isNotNull((Object)docId) && ObjectUtils.isNotNull((Object)(taDoc = this.getTravelDocumentService().findCurrentTravelAuthorization(travelReqDoc)))) {
            this.getTravelReimbursementService().addDateChangedNote(travelReqDoc, taDoc);
        }
    }

    protected String getObjectCodeForNewSourceAccountingLine(TravelReimbursementForm form) {
        if (form.getDistribution() != null && !form.getDistribution().isEmpty()) {
            if (form.getDistribution().size() == 1) {
                return form.getDistribution().get(0).getObjectCode();
            }
            HashSet<String> nonUsedDistributionObjectCodes = new HashSet<String>();
            Set<String> usedObjectCodes = this.getAccountingLineObjectCodes(form);
            for (AccountingDistribution dist : form.getDistribution()) {
                if (usedObjectCodes.contains(dist.getObjectCode()) || dist.getSubTotal().equals((Object)KualiDecimal.ZERO)) continue;
                nonUsedDistributionObjectCodes.add(dist.getObjectCode());
            }
            if (nonUsedDistributionObjectCodes.size() == 1) {
                String objectCode = null;
                Iterator iterator = nonUsedDistributionObjectCodes.iterator();
                while (iterator.hasNext()) {
                    String objCode;
                    objectCode = objCode = (String)iterator.next();
                }
                return objectCode;
            }
        }
        return "";
    }

    protected Set<String> getAccountingLineObjectCodes(TravelReimbursementForm form) {
        HashSet<String> codes = new HashSet<String>();
        for (AccountingLine line : form.getTravelDocument().getSourceAccountingLines()) {
            codes.add(line.getFinancialObjectCode());
        }
        return codes;
    }

    protected boolean isCopyPerDiemAndExpenses(TravelReimbursementDocument newReimbursementDocument) {
        List<TravelReimbursementDocument> reimbursementDocuments = this.getTravelDocumentService().findReimbursementDocuments(newReimbursementDocument.getTravelDocumentIdentifier());
        if (!reimbursementDocuments.isEmpty()) {
            for (TravelReimbursementDocument reimbursementDocument : reimbursementDocuments) {
                if (!reimbursementDocument.getDocumentHeader().getWorkflowDocument().isFinal() && !reimbursementDocument.getDocumentHeader().getWorkflowDocument().isProcessed()) continue;
                return false;
            }
        }
        return true;
    }

    public ActionForward copy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelReimbursementForm reimbForm = (TravelReimbursementForm)form;
        reimbForm.setTravelDocumentIdentifier(null);
        reimbForm.setHistory(new ArrayList<Serializable>());
        return super.copy(mapping, form, request, response);
    }

    public ActionForward newReimbursement(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TravelReimbursementDocument travelReimb = ((TravelReimbursementForm)form).getTravelReimbursementDocument();
        return new ActionForward(this.buildNewReimbursementUrl(travelReimb), true);
    }

    protected TravelReimbursementService getTravelReimbursementService() {
        return (TravelReimbursementService)SpringContext.getBean(TravelReimbursementService.class);
    }

    protected TravelAuthorizationService getTravelAuthorizationService() {
        return (TravelAuthorizationService)SpringContext.getBean(TravelAuthorizationService.class);
    }

    protected ExpenseSummaryReportService getExpenseSummaryReportService() {
        return (ExpenseSummaryReportService)SpringContext.getBean(ExpenseSummaryReportService.class);
    }

    protected SummaryByDayReportService getSummaryByDayReportService() {
        return (SummaryByDayReportService)SpringContext.getBean(SummaryByDayReportService.class);
    }

    protected NonEmployeeCertificationReportService getNonEmployeeCertificationReportService() {
        return (NonEmployeeCertificationReportService)SpringContext.getBean(NonEmployeeCertificationReportService.class);
    }

    protected DateTimeService getDateTimeService() {
        return (DateTimeService)SpringContext.getBean(DateTimeService.class);
    }
}

