/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.workflow;

import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.document.authorization.DocumentAuthorizer;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.workflow.SensitiveDataSecurityAttribute;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.Person;

public class TEMSecurityAttribute
extends SensitiveDataSecurityAttribute {
    private static final Logger LOG = Logger.getLogger(TEMSecurityAttribute.class);
    private DocumentHelperService documentHelperService;
    private DocumentService documentService;
    protected IdentityService identityService;

    public boolean isAuthorizedForDocument(String principalId, final org.kuali.rice.kew.api.document.Document document) {
        boolean authorized = false;
        authorized = super.isAuthorizedForDocument(principalId, document);
        if (authorized) {
            try {
                String principalName = this.getIdentityService().getPrincipal(principalId).getPrincipalName();
                Boolean canOpen = (Boolean)GlobalVariables.doInNewGlobalVariables((UserSession)new UserSession(principalName), (Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return TEMSecurityAttribute.this.canOpen(GlobalVariables.getUserSession().getPerson(), document.getDocumentTypeName(), document.getDocumentId());
                    }
                });
                return ObjectUtils.isNotNull((Object)canOpen) && canOpen != false;
            }
            catch (Exception ex) {
                LOG.error((Object)("Exception while testing if user can open document: document.getDocumentId()=" + document.getDocumentId()), (Throwable)ex);
                return false;
            }
        }
        return authorized;
    }

    public Boolean canOpen(Person currentUser, String docTypeName, String documentId) {
        DocumentAuthorizer docAuthorizer = this.getDocumentHelperService().getDocumentAuthorizer(docTypeName);
        TravelDocument doc = this.getDocument(documentId);
        if (ObjectUtils.isNull((Object)doc)) {
            LOG.error((Object)("KFS document is null but exists in rice, returning false from isAuthorizedForDocument. documentId=" + documentId));
            return false;
        }
        return docAuthorizer.canOpen((Document)doc, currentUser);
    }

    public TravelDocument getDocument(String documentNumber) {
        TravelDocument document = null;
        try {
            document = (TravelDocument)this.getDocumentService().getByDocumentHeaderIdSessionless(documentNumber);
        }
        catch (WorkflowException ex) {
            throw new RuntimeException(ex);
        }
        return document;
    }

    public DocumentHelperService getDocumentHelperService() {
        return (DocumentHelperService)SpringContext.getBean(DocumentHelperService.class);
    }

    public DocumentService getDocumentService() {
        return (DocumentService)SpringContext.getBean(DocumentService.class);
    }

    protected IdentityService getIdentityService() {
        if (this.identityService == null) {
            this.identityService = (IdentityService)SpringContext.getBean(IdentityService.class);
        }
        return this.identityService;
    }
}

