/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.report.service.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.PerDiemExpense;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.report.SummaryByDayReport;
import org.kuali.kfs.module.tem.report.service.SummaryByDayReportService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.kfs.sys.util.KfsDateUtils;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.api.identity.PersonService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class SummaryByDayReportServiceImpl
implements SummaryByDayReportService {
    public static Logger LOG = Logger.getLogger(SummaryByDayReportServiceImpl.class);
    protected ConfigurationService configurationService;
    protected ParameterService parameterService;
    protected PersonService personService;
    protected TravelDocumentService travelDocumentService;
    protected SimpleDateFormat monthDay = new SimpleDateFormat("MM/dd");

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService ConfigurationService2) {
        this.configurationService = ConfigurationService2;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    @Override
    public SummaryByDayReport buildReport(TravelDocument travelDocument) {
        SummaryByDayReport.Detail detail;
        String expenseDate;
        LOG.debug((Object)("Building a " + SummaryByDayReport.class + " report for trip id " + travelDocument.getTravelDocumentIdentifier()));
        SummaryByDayReport retval = new SummaryByDayReport();
        retval.setBeginDate(travelDocument.getTripBegin() != null ? KfsDateUtils.clearTimeFields((Date)travelDocument.getTripBegin()) : new Date());
        retval.setEndDate(travelDocument.getTripEnd() != null ? KfsDateUtils.clearTimeFields((Date)travelDocument.getTripEnd()) : new Date());
        retval.setTripId(travelDocument.getTravelDocumentIdentifier().toString());
        retval.setPurpose(travelDocument.getReportPurpose() == null ? "" : travelDocument.getReportPurpose());
        retval.setInstitution(this.getParameterService().getParameterValueAsString(KfsParameterConstants.FINANCIAL_SYSTEM_ALL.class, "INSTITUTION_NAME"));
        travelDocument.refreshReferenceObject("actualExpenses");
        ArrayList<SummaryByDayReport.Detail> transportation = new ArrayList<SummaryByDayReport.Detail>();
        ArrayList<SummaryByDayReport.Detail> other = new ArrayList<SummaryByDayReport.Detail>();
        ArrayList<SummaryByDayReport.Detail> lodging = new ArrayList<SummaryByDayReport.Detail>();
        ArrayList<SummaryByDayReport.Detail> meals = new ArrayList<SummaryByDayReport.Detail>();
        ArrayList<SummaryByDayReport.Detail> summary = new ArrayList<SummaryByDayReport.Detail>();
        ArrayList<SummaryByDayReport.Detail> perDiemWeeklyTotal = new ArrayList<SummaryByDayReport.Detail>();
        TreeMap<String, KualiDecimal> summaryData = new TreeMap<String, KualiDecimal>();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(retval.getBeginDate());
        int weekCount = 1;
        KualiDecimal milageWeekTotal = KualiDecimal.ZERO;
        KualiDecimal lodgingWeekTotal = KualiDecimal.ZERO;
        KualiDecimal mealWeekTotal = KualiDecimal.ZERO;
        GregorianCalendar firstDayOfWeek = new GregorianCalendar();
        firstDayOfWeek.setTime(retval.getBeginDate());
        ((Calendar)firstDayOfWeek).add(7, 2 - cal.get(7));
        GregorianCalendar lastDayOfWeek = new GregorianCalendar();
        lastDayOfWeek.setTime(firstDayOfWeek.getTime());
        ((Calendar)lastDayOfWeek).add(7, 6);
        ((Calendar)firstDayOfWeek).add(14, -1);
        ((Calendar)lastDayOfWeek).add(14, 1);
        int perDiemExpensesSize = travelDocument.getPerDiemExpenses().size();
        for (PerDiemExpense perDiemExpense : travelDocument.getPerDiemExpenses()) {
            if (!perDiemExpense.getMileageDate().after(firstDayOfWeek.getTime()) || !perDiemExpense.getMileageDate().before(lastDayOfWeek.getTime()) || --perDiemExpensesSize <= 0) {
                String weekCountFormat = weekCount < 10 ? "0" + weekCount : "" + weekCount;
                SummaryByDayReport.Detail perDiemMilageWeekTotal = new SummaryByDayReport.Detail("Per Diem Milage", milageWeekTotal, "week " + weekCountFormat);
                perDiemWeeklyTotal.add(perDiemMilageWeekTotal);
                SummaryByDayReport.Detail perDiemLodgingWeekTotal = new SummaryByDayReport.Detail("Per Diem Lodging", lodgingWeekTotal, "week " + weekCountFormat);
                perDiemWeeklyTotal.add(perDiemLodgingWeekTotal);
                SummaryByDayReport.Detail perDiemMealWeekTotal = new SummaryByDayReport.Detail("Per Diem Meals & Incidentals", mealWeekTotal, "week " + weekCountFormat);
                perDiemWeeklyTotal.add(perDiemMealWeekTotal);
                ((Calendar)firstDayOfWeek).add(7, 7);
                ((Calendar)lastDayOfWeek).add(7, 7);
                ++weekCount;
                milageWeekTotal = KualiDecimal.ZERO;
                lodgingWeekTotal = KualiDecimal.ZERO;
                mealWeekTotal = KualiDecimal.ZERO;
            }
            expenseDate = this.monthDay.format(cal.getTime());
            SummaryByDayReport.Detail perDiemMilage = new SummaryByDayReport.Detail("Per Diem Milage", perDiemExpense.getMileageTotal(), expenseDate);
            transportation.add(perDiemMilage);
            SummaryByDayReport.Detail perDiemLodging = new SummaryByDayReport.Detail("Per Diem Lodging", perDiemExpense.getLodgingTotal(), expenseDate);
            lodging.add(perDiemLodging);
            SummaryByDayReport.Detail perDiemMeal = new SummaryByDayReport.Detail("Per Diem Meals & Incidentals", perDiemExpense.getMealsAndIncidentals(), expenseDate);
            meals.add(perDiemMeal);
            milageWeekTotal = (KualiDecimal)milageWeekTotal.add((AbstractKualiDecimal)perDiemExpense.getMileageTotal());
            lodgingWeekTotal = (KualiDecimal)lodgingWeekTotal.add((AbstractKualiDecimal)perDiemExpense.getLodgingTotal());
            mealWeekTotal = (KualiDecimal)mealWeekTotal.add((AbstractKualiDecimal)perDiemExpense.getMealsAndIncidentals());
            this.incrementSummary(summaryData, expenseDate, perDiemExpense.getDailyTotal());
            ((Calendar)cal).add(6, 1);
        }
        for (ActualExpense expense : travelDocument.getActualExpenses()) {
            expense.refreshReferenceObject("expenseTypeObjectCode");
            expenseDate = this.monthDay.format(expense.getExpenseDate());
            detail = new SummaryByDayReport.Detail(expense.getExpenseTypeObjectCode().getExpenseType().getName() == null ? "" : expense.getExpenseTypeObjectCode().getExpenseType().getName(), new KualiDecimal(expense.getExpenseAmount().bigDecimalValue().multiply(expense.getCurrencyRate())), expenseDate);
            if (this.isTransportationExpense(expense)) {
                transportation.add(detail);
            } else if (this.isLodgingExpense(expense)) {
                lodging.add(detail);
            } else if (this.isMealsExpense(expense)) {
                meals.add(detail);
            } else {
                other.add(detail);
            }
            this.incrementSummary(summaryData, expenseDate, new KualiDecimal(expense.getExpenseAmount().bigDecimalValue().multiply(expense.getCurrencyRate())));
        }
        for (String expenseDate2 : summaryData.keySet()) {
            KualiDecimal expenseAmount = (KualiDecimal)summaryData.get(expenseDate2);
            detail = new SummaryByDayReport.Detail("TOTAL of all above expenses", expenseAmount, expenseDate2);
            summary.add(detail);
        }
        if (perDiemWeeklyTotal.size() > 0) {
            LOG.debug((Object)("Adding " + perDiemWeeklyTotal.size() + " per diem weekly total"));
            retval.setWeeklyTotal(perDiemWeeklyTotal);
        }
        if (other.size() > 0) {
            LOG.debug((Object)("Adding " + other.size() + " other expenses"));
            retval.setOtherExpenses(other);
        }
        if (transportation.size() > 0) {
            LOG.debug((Object)("Adding " + transportation.size() + " transportation expenses"));
            retval.setTransportation(transportation);
        }
        if (lodging.size() > 0) {
            LOG.debug((Object)("Adding " + lodging.size() + " lodging expenses"));
            retval.setLodging(lodging);
        }
        if (meals.size() > 0) {
            LOG.debug((Object)("Adding " + meals.size() + " meals expenses"));
            retval.setMeals(meals);
        }
        if (summary.size() > 0) {
            LOG.debug((Object)("Adding " + summary.size() + " summary"));
            retval.setSummary(summary);
        }
        return retval;
    }

    protected void incrementSummary(Map<String, KualiDecimal> summaryData, String expenseDate, KualiDecimal expense) {
        KualiDecimal summaryAmount = summaryData.get(expenseDate);
        if (summaryAmount == null) {
            summaryAmount = KualiDecimal.ZERO;
        }
        summaryAmount = (KualiDecimal)summaryAmount.add((AbstractKualiDecimal)expense);
        LOG.debug((Object)("Adding " + summaryAmount + " for " + expenseDate + " to summary data"));
        summaryData.put(expenseDate, summaryAmount);
    }

    protected boolean isTransportationExpense(ActualExpense expense) {
        LOG.debug((Object)("Checking if " + expense + " is a transportation "));
        return this.expenseTypeCodeMatchesParameter(expense.getExpenseTypeCode(), "TRANSPORTATION_TYPE_CODES");
    }

    protected boolean isLodgingExpense(ActualExpense expense) {
        LOG.debug((Object)("Checking if " + expense + " is a lodging "));
        return this.expenseTypeCodeMatchesParameter(expense.getExpenseTypeCode(), "LODGING_TYPE_CODES");
    }

    protected boolean isMealsExpense(ActualExpense expense) {
        LOG.debug((Object)("Checking if " + expense + " is a meal "));
        return this.getTravelDocumentService().isHostedMeal(expense);
    }

    protected boolean expenseTypeCodeMatchesParameter(String expenseTypeCode, String parameter) {
        return this.getParameterService().getParameterValuesAsString(TravelReimbursementDocument.class, parameter).contains(expenseTypeCode);
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public TravelDocumentService getTravelDocumentService() {
        return this.travelDocumentService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }
}

