/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

module.exports = {
  parser: '@babel/eslint-parser',
  root: true,
  extends: [
    'semistandard',
    'standard-jsx',
    'standard-react',
    'plugin:react-hooks/recommended',
    'plugin:testing-library/react',
    'plugin:vitest-globals/recommended'
  ],
  env: {
    'vitest-globals/env': true,
    browser: true,
    node: true,
    jquery: true
  },
  rules: {
    'sort-imports': [
      'warn',
      {
        ignoreCase: true,
        ignoreMemberSort: false,
        memberSyntaxSortOrder: ['none', 'all', 'single', 'multiple']
      }
    ],
    // Adding this to ignore list. This has become necessary due to something else under the hood, and the plan
    // is to maybe move away from jest so this problem will hopefully go away in the nearish future
    'testing-library/no-unnecessary-act': 'off'
  },
  globals: {
    vi: true,
    stayOnPage: true,
    dwr: true,
    wrapError: true,
    setRecipientValue: true,
    clearRecipients: true,
    valueChanged: true,
    findElPrefix: true,
    getElementValue: true,
    setElementValue: true,
    divSuffix: true,
    kualiElements: true
  }
};
