<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2017 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<%@ attribute name="documentTypeName" required="true" description="The name of the document type this document page is rendering." %>

<%@ attribute name="showDocumentInfo" required="false" description="Boolean value of whether to display the Document Type name and document type help on the page." %>
<%@ attribute name="headerMenuBar" required="false" description="HTML text for menu bar to display at the top of the page." %>
<%@ attribute name="headerTitle" required="false" description="The title of this page which will be displayed in the browser's header bar.  If left blank, docTitle will be used instead." %>
<%@ attribute name="htmlFormAction" required="false" description="The URL that the HTML form rendered on this page will be posted to." %>
<%@ attribute name="renderMultipart" required="false" description="Boolean value of whether the HTML form rendred on this page will be encoded to accept multipart - ie, uploaded attachment - input." %>
<%@ attribute name="showTabButtons" required="false" description="Whether to show the show/hide all tabs buttons." %>
<%@ attribute name="extraTopButtons" required="false" type="java.util.List" %>
<%@ attribute name="headerDispatch" required="false" description="A List of org.kuali.kfs.kns.web.ui.ExtraButton objects to display at the top of the page." %>
<%@ attribute name="headerTabActive" required="false" description="The name of the active header tab, if header navigation is used." %>
<%@ attribute name="feedbackKey" required="false" description="application resources key that contains feedback contact address only used when lookup attribute is false" %>
<%@ attribute name="auditCount" required="false" description="The number of audit errors displayed on this page." %>
<%@ attribute name="docTitle" required="false" %>
<%@ attribute name="alternativeHelp" required="false"%>

<%@ variable name-given="documentEntry" scope="NESTED" %>
<c:set var="documentEntry" value="${DataDictionary[documentTypeName]}" />
<c:set var="sessionDocument" value="${documentEntry.sessionDocument}" />
<c:set var="additionalScriptFiles" value="${KualiForm.additionalScriptFiles}" />

<c:choose>
	<c:when test="${docTitle != null}">
		<c:set var="documentTitle" value="${docTitle}" />
	</c:when>
	<c:otherwise>
		<c:set var="documentTitle" value="${documentEntry.label}" />
	</c:otherwise>
</c:choose>
<!--  pass documentTypeName into htmlControlAttribute -->
<!-- Do not remove session check here. Since it used by other pages (not MD or TD) -->
<c:if test="${KualiForm.document.sessionDocument || sessionDocument}">
    <% request.setAttribute("sessionDoc", Boolean.TRUE); %>
</c:if>

<kul:page
        docTitle="${documentTitle}"
        transactionalDocument="${documentEntry.transactionalDocument}"
        headerMenuBar="${headerMenuBar}"
        showDocumentInfo="${showDocumentInfo}"
        headerTitle="${headerTitle}"
        htmlFormAction="${htmlFormAction}"
        alternativeHelp="${alternativeHelp}"
        renderMultipart="${renderMultipart}"
        showTabButtons="${showTabButtons}"
        extraTopButtons="${extraTopButtons}"
        headerDispatch="${headerDispatch}"
        headerTabActive="${headerTabActive}"
        feedbackKey="${feedbackKey}"
        auditCount="${auditCount}"
        additionalScriptFiles="${additionalScriptFiles}">

    <jsp:doBody/>
</kul:page>
