/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import React from 'react';
import {curry, isEqual, pluck} from 'lodash';
import KfsUtils from '../../sys/utils.js';
import {addFavoriteButton, addHeading, buildDisplayLinks, determineSublinkClass} from '../../sys/sidebar_utils.js';

var LinkGroupSublinks = React.createClass({
    shouldComponentUpdate(nextProps) {
      const buildCompare = props => ({
        label: props.group.label,
        expanded: props.expandedLinkGroup === props.group.label,
        activities: {
          labels: pluck(props.group.links.activities, 'label'),
          favorites: pluck(props.group.links.activities, 'favorite')
        },
        reference: {
          labels: pluck(props.group.links.reference, 'label'),
          favorites: pluck(props.group.links.reference, 'favorite')
        },
        administration: {
          labels: pluck(props.group.links.administration, 'label'),
          favorites: pluck(props.group.links.administration, 'favorite')
        }                        
      })
      return !(isEqual(buildCompare(this.props), buildCompare(nextProps)) &&
        isEqual(this.props.checkedLinkFilters, nextProps.checkedLinkFilters));
    },
    render() {
        let label = this.props.group.label;
        let id = KfsUtils.buildKeyFromLabel(label);
        let addFavoriteButtonWrapper = curry(addFavoriteButton)(this.props.group, this.props.addFavorite, this.props.removeFavorite);

        let activitiesLinks = buildDisplayLinks(this.props.group.links, 'activities', this.props.checkedLinkFilters, this.props.backdoorId, addFavoriteButtonWrapper);
        let referenceLinks = buildDisplayLinks(this.props.group.links, 'reference', this.props.checkedLinkFilters, this.props.backdoorId, addFavoriteButtonWrapper);
        let administrationLinks = buildDisplayLinks(this.props.group.links, 'administration', this.props.checkedLinkFilters, this.props.backdoorId, addFavoriteButtonWrapper);

        let links = addHeading(activitiesLinks, 'Activities');
        links = links.concat(addHeading(referenceLinks, 'Reference'));
        links = links.concat(addHeading(administrationLinks, 'Administration'));

        let headingCount = links.length - (activitiesLinks.length + referenceLinks.length + administrationLinks.length);
        if (headingCount > 0) {
            headingCount--;
        }

        let sublinksClass = determineSublinkClass(links, headingCount, this.props.expandedLinkGroup === label);

        if (links.length > 0) {
            return (
                <div id={id + "-menu"} className={sublinksClass}>
                    <h3>{label}</h3>
                    <div className="links-container">
                        {links}
                    </div>
                    <button type="button" aria-label="close submenu" className="close" onClick={this.props.handleClick.bind(null, label, id + '-menu')}><span aria-hidden="true">&times;</span></button>
                </div>
            )
        } else {
            return null
        }
    }
});

export default LinkGroupSublinks;
