# Kuali Common

This package contains the common components used in core. It is published in our private npm registry under the name `@kuali/common`

Please see each of the components `README.md` files for usage.

## Usage

### CSS

You'll need to include a CSS file for many of these components to work. This should be included once, at the root of your project. This is just a normal css file; no need to transpile css modules.

```javascript
import '@kuali/common/style.css'
```

Make sure your module bundler knows how to load css files. Here's an example of how you might set that up in webpack:

```javascript
loaders: [
  {
    test: /\.css$/,
    loader: 'style!css',
    include: [/node_modules/]
  }
]
```

### JS

This library is set up in a way that allows you to destructure out any component:

```javascript
import { Icon, KualiTopBar } from '@kuali/common'
```

If you care about having a smaller bundle size, we instead recommend importing just the modules you need:

```javascript
import Icon from '@kuali/common/icon'
import KualiTopBar from '@kuali/common/kuali-top-bar'
```

## Development

### Licensing

Pre-commit hooks are set up to check that all source code has our pre release license. If your commit fails because of a missing license, run the following command and git add the changes that come from it:

`./node_modules/.bin/kuali-utils license`
