'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RawKualiTopBar = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _lodash = require('lodash');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Buttons = require('react-md/lib/Buttons');

var _Buttons2 = _interopRequireDefault(_Buttons);

var _ListItem = require('react-md/lib/Lists/ListItem');

var _ListItem2 = _interopRequireDefault(_ListItem);

var _Menu = require('react-md/lib/Menus/Menu');

var _Menu2 = _interopRequireDefault(_Menu);

var _MenuButton = require('react-md/lib/Menus/MenuButton');

var _MenuButton2 = _interopRequireDefault(_MenuButton);

var _appMenu = require('./parts/app-menu');

var _appMenu2 = _interopRequireDefault(_appMenu);

var _booleanState = require('./parts/boolean-state');

var _booleanState2 = _interopRequireDefault(_booleanState);

var _topBarLink = require('./parts/top-bar-link');

var _topBarLink2 = _interopRequireDefault(_topBarLink);

var _style = require('./style.css');

var _style2 = _interopRequireDefault(_style);

var _mediaQuery = require('../media-query');

var _mediaQuery2 = _interopRequireDefault(_mediaQuery);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var RawKualiTopBar = exports.RawKualiTopBar = function (_Component) {
  _inherits(RawKualiTopBar, _Component);

  function RawKualiTopBar() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, RawKualiTopBar);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = RawKualiTopBar.__proto__ || Object.getPrototypeOf(RawKualiTopBar)).call.apply(_ref, [this].concat(args))), _this), _this.getLinks = function (small) {
      var links = [{
        to: '/actions/#/list',
        title: 'Action List',
        imgSrc: 'action_list'
      }, {
        hide: small,
        el: _this.getProfileTrigger(_this.props.user, small)
      }, {
        hide: !small,
        to: '/users/#/' + _this.props.user.id + '/details/view',
        title: 'User Settings',
        imgSrc: 'profile'
      }, {
        hide: !small,
        to: '/auth/signout',
        title: 'Sign Out',
        imgSrc: 'sign-out'
      }];
      return (0, _lodash.compact)((0, _lodash.map)(links, function (link) {
        var hide = link.hide;
        var el = link.el;

        var linkData = (0, _lodash.omit)(link, ['hide', 'el']);
        if (hide) return null;
        return el || _react2.default.createElement(_topBarLink2.default, _extends({ key: linkData.to, small: small }, linkData));
      }));
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(RawKualiTopBar, [{
    key: 'getProfileTrigger',
    value: function getProfileTrigger(user, small) {
      var title = user.displayName || 'Profile';
      var props = { small: small, title: title, imgSrc: 'profile' };
      var userUrl = '/users/#/' + user.id + '/details/view';
      return _react2.default.createElement(
        _MenuButton2.default,
        {
          buttonChildren: _react2.default.createElement(_topBarLink2.default, props),
          className: _style2.default.userSettingsBtn,
          flat: true,
          id: 'user-settings-menu',
          key: 'user-settings-menu',
          position: _Menu2.default.Positions.BELOW
        },
        _react2.default.createElement(_ListItem2.default, { component: 'a', href: userUrl, primaryText: 'User Settings' }),
        _react2.default.createElement(_ListItem2.default, { component: 'a', href: '/auth/signout', primaryText: 'Sign Out' })
      );
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props;
      var mq = _props.mq;
      var handleMenuClick = _props.handleMenuClick;
      var user = _props.user;
      var logo = _props.logo;
      var title = _props.title;

      var small = mq === 'small';
      var renderedLinks = this.getLinks(small);
      var wrapperStyle = (0, _classnames2.default)('navigation', _style2.default.wrapper, _defineProperty({}, _style2.default.small, small));
      var logoImg = _react2.default.createElement('img', {
        className: _style2.default.logoImg,
        role: 'presentation',
        src: logo
      });
      return _react2.default.createElement(
        _booleanState2.default,
        null,
        function (open, toggle) {
          return _react2.default.createElement(
            'nav',
            { className: wrapperStyle },
            _react2.default.createElement(
              'div',
              { className: _style2.default.nav },
              small && handleMenuClick && _react2.default.createElement(
                _Buttons2.default,
                { icon: true, onClick: handleMenuClick },
                'menu'
              ),
              _react2.default.createElement(
                'div',
                { className: _style2.default.leftContent },
                small && _react2.default.createElement(
                  _MenuButton2.default,
                  {
                    buttonChildren: logoImg,
                    className: _style2.default.appMenuBtn,
                    flat: true,
                    id: 'apps-menu'
                  },
                  _react2.default.createElement(_appMenu2.default, { small: small, user: user })
                ),
                !small && _react2.default.createElement(
                  'div',
                  { style: { display: 'flex', alignItems: 'center' } },
                  _react2.default.createElement('img', { role: 'presentation', src: logo, className: _style2.default.logo }),
                  _react2.default.createElement('div', { style: { backgroundColor: '#d4d5d7', width: 1, height: 20 } }),
                  _react2.default.createElement(
                    'div',
                    { style: { fontSize: 20, marginLeft: 30, marginRight: 10 } },
                    _react2.default.createElement(
                      'span',
                      { style: { fontWeight: 100 } },
                      title
                    )
                  ),
                  _react2.default.createElement(
                    _MenuButton2.default,
                    { icon: true, id: 'apps-menu', buttonChildren: 'apps', position: 'below' },
                    _react2.default.createElement(_appMenu2.default, { small: small, user: user })
                  )
                )
              ),
              !small && renderedLinks,
              small && _react2.default.createElement(
                _Buttons2.default,
                { icon: true, onClick: toggle },
                'menu'
              )
            ),
            open && small && _react2.default.createElement(
              'div',
              { className: _style2.default.dropdown },
              renderedLinks
            )
          );
        }
      );
    }
  }]);

  return RawKualiTopBar;
}(_react.Component);

RawKualiTopBar.displayName = 'KualiTopBar';
RawKualiTopBar.propTypes = {
  handleMenuClick: _propTypes2.default.func,
  logo: _propTypes2.default.string.isRequired,
  mq: _propTypes2.default.oneOf(['small', 'medium', 'large', 'huge']).isRequired,
  title: _propTypes2.default.string.isRequired,
  user: _propTypes2.default.shape({
    displayName: _propTypes2.default.string.isRequired,
    id: _propTypes2.default.string.isRequired,
    role: _propTypes2.default.oneOf(['admin', 'user']).isRequired
  }).isRequired
};
exports.default = (0, _mediaQuery2.default)(RawKualiTopBar);