'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AppMenuLink;

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

function AppMenuLink(_ref) {
  var app = _ref.app;
  var name = _ref.name;
  var to = _ref.to;

  return _react2.default.createElement(
    'a',
    { href: to || '/' + app },
    _react2.default.createElement('img', { role: 'presentation', src: '/img/v1/top-bar/apps/' + app + '.svg' }),
    _react2.default.createElement(
      'div',
      null,
      name
    )
  );
}

AppMenuLink.displayName = 'AppMenuLink';

AppMenuLink.propTypes = {
  app: _propTypes2.default.string.isRequired,
  name: _propTypes2.default.string.isRequired,
  to: _propTypes2.default.string
};