'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _lodash = require('lodash');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

function errorDecorator(_ref) {
  var context = _ref.context,
      template = _ref.template,
      formKey = _ref.formKey;

  return {
    gadget: function gadget(_gadget) {
      var error = (0, _lodash.get)(context, ['errors', formKey]);
      if (error) {
        return _react2.default.cloneElement(_gadget, {
          error: error
        });
      }
      return _gadget;
    },
    gadgetChildren: function gadgetChildren(rows) {
      var errors = (0, _lodash.get)(context, ['errors', template.formKey], []);
      return rows.map(function (row) {
        var cloneRow = false;

        // the original index (independent of sorting) has been passed down in the id prop
        var index = row.props['data-index'];

        // children of rows are gadgets containing label, desc, and gadget
        var children = _react2.default.Children.map(row.props.children, function (child) {
          if (!child) {
            return child;
          }
          // iterate over grandchildren looking for the gadget itself
          // i.e TextEdit to set the error prop
          var cloneChild = false;
          var grandChildren = _react2.default.Children.map(child.props.children, function (grandChild) {
            var formKey = (0, _lodash.get)(grandChild, ['props', 'formKey']);
            var error = (0, _lodash.get)(errors, [index, formKey]);
            if (error) {
              cloneChild = true;
              cloneRow = true;
              return _react2.default.cloneElement(grandChild, {
                error: error
              });
            }
            return grandChild;
          });
          return cloneChild ? _react2.default.cloneElement(child, child.props, grandChildren) : child;
        });
        return cloneRow ? _react2.default.cloneElement(row, row.props, children) : row;
      });
    }
  };
}
exports.default = errorDecorator;