'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DownloadButton = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _axios = require('axios');

var _axios2 = _interopRequireDefault(_axios);

var _cookiesJs = require('cookies-js');

var _cookiesJs2 = _interopRequireDefault(_cookiesJs);

var _lodash = require('lodash');

var _pdf = require('./pdf');

var _pdf2 = _interopRequireDefault(_pdf);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _kualiUi = require('@kuali/kuali-ui');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2005-2017 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var imageSupportedContentTypes = ['image/jpeg', 'image/png', 'image/gif'];
var pdfSupportedContentTypes = ['application/pdf'];

var DownloadButton = exports.DownloadButton = function DownloadButton(props) {
  var onClick = void 0;
  if (window.navigator && window.navigator.msSaveOrOpenBlob) {
    onClick = function onClick() {
      window.navigator.msSaveOrOpenBlob(props.blob, props.fileName);
    };
  }

  return _react2.default.createElement(
    _kualiUi.FlatButton,
    {
      href: props.url,
      download: props.fileName || true,
      component: 'a',
      label: 'Download',
      labelStyle: { display: 'none' },
      onClick: onClick
    },
    _react2.default.createElement(_kualiUi.Icon, { name: 'file_download' })
  );
};

var AttachmentPreview = function (_React$Component) {
  _inherits(AttachmentPreview, _React$Component);

  function AttachmentPreview(props) {
    _classCallCheck(this, AttachmentPreview);

    var _this = _possibleConstructorReturn(this, (AttachmentPreview.__proto__ || Object.getPrototypeOf(AttachmentPreview)).call(this, props));

    _this.state = { page: 1, scale: 1, pages: 1 };
    return _this;
  }

  _createClass(AttachmentPreview, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      var _this2 = this;

      var url = this.props.url;

      return _axios2.default.get(url, {
        headers: { Authorization: 'Bearer ' + _cookiesJs2.default.get('authToken') },
        responseType: 'blob'
      }).then(function (response) {
        var objectUrl = URL.createObjectURL(response.data); // eslint-disable-line no-undef
        _this2.setState({ url: objectUrl, blob: response.data });
      });
    }
  }, {
    key: 'render',
    value: function render() {
      var url = this.state.url;
      var _props = this.props,
          file = _props.file,
          onClose = _props.onClose;

      var preview = void 0;
      var actions = [];
      if (!url) {
        preview = this.renderLoading();
      } else if ((0, _lodash.includes)(imageSupportedContentTypes, file.contentType)) {
        preview = this.renderImagePreview();
        actions = this.imagePreviewActions();
      } else if ((0, _lodash.includes)(pdfSupportedContentTypes, file.contentType)) {
        preview = this.renderPdfPreview();
        actions = this.pdfPreviewActions();
      } else {
        preview = this.renderUnsupportedPreview();
      }
      actions.push(_react2.default.createElement(
        _kualiUi.FlatButton,
        { onClick: onClose, label: 'Close' },
        _react2.default.createElement(_kualiUi.Icon, { name: 'close', variant: 'warning' })
      ));
      return _react2.default.createElement(
        _kualiUi.Dialog,
        {
          visible: true,
          actions: actions,
          style: { paddingTop: 0 },
          title: file.fileName,
          renderNode: document.body,
          onHide: onClose
        },
        preview
      );
    }
  }, {
    key: 'renderImagePreview',
    value: function renderImagePreview() {
      var url = this.state.url;

      return _react2.default.createElement('img', {
        src: url,
        style: { maxWidth: '100%', height: 'auto', display: 'inline-block' }
      });
    }
  }, {
    key: 'imagePreviewActions',
    value: function imagePreviewActions() {
      var _state = this.state,
          url = _state.url,
          blob = _state.blob;
      var file = this.props.file;

      return [_react2.default.createElement(
        'span',
        { key: 'download' },
        _react2.default.createElement(DownloadButton, { url: url, blob: blob, fileName: file.fileName })
      )];
    }
  }, {
    key: 'renderPdfPreview',
    value: function renderPdfPreview() {
      var _this3 = this;

      var _state2 = this.state,
          page = _state2.page,
          scale = _state2.scale,
          url = _state2.url;

      return _react2.default.createElement(
        'span',
        null,
        _react2.default.createElement(_pdf2.default, {
          file: url,
          page: page,
          scale: scale,
          pdfUrl: this.props.pdfUrl,
          onDocumentComplete: function onDocumentComplete(numPages) {
            return _this3.setState({ pages: numPages });
          },
          onPageComplete: function onPageComplete(newPage) {
            return _this3.setState({ currentPage: newPage });
          }
        })
      );
    }
  }, {
    key: 'pdfPreviewActions',
    value: function pdfPreviewActions() {
      var _this4 = this;

      var _state3 = this.state,
          page = _state3.page,
          pages = _state3.pages,
          scale = _state3.scale,
          url = _state3.url,
          blob = _state3.blob;
      var file = this.props.file;

      return [_react2.default.createElement(
        'span',
        {
          key: 'pages',
          style: { height: '90px !important', minWidth: '375px' }
        },
        _react2.default.createElement(
          _kualiUi.FlatButton,
          {
            onClick: function onClick() {
              return _this4.setState({ page: page - 1 });
            },
            label: 'Previous Page',
            labelStyle: { display: 'none' },
            disabled: page === 1
          },
          _react2.default.createElement(_kualiUi.Icon, { name: 'arrow_back', variant: 'success' })
        ),
        'Page',
        _react2.default.createElement('input', {
          type: 'text',
          size: '2',
          value: page,
          style: { fontSize: 20 },
          onChange: function onChange(e) {
            if (e.target.value && !isNaN(Number(e.target.value))) {
              _this4.setState({ page: Number(e.target.value) });
            }
          }
        }),
        'of ',
        pages,
        _react2.default.createElement(
          _kualiUi.FlatButton,
          {
            onClick: function onClick() {
              return _this4.setState({ page: page + 1 });
            },
            label: 'Next Page',
            labelStyle: { display: 'none' },
            disabled: page >= pages,
            iconBefore: false
          },
          _react2.default.createElement(_kualiUi.Icon, { name: 'arrow_forward', variant: 'success' })
        )
      ), _react2.default.createElement(
        'span',
        { key: 'zoom', style: { minWidth: '250px' } },
        _react2.default.createElement(
          _kualiUi.FlatButton,
          {
            onClick: function onClick() {
              return _this4.setState({ scale: scale + 0.1 });
            },
            label: 'Zoom In',
            labelStyle: { display: 'none' }
          },
          _react2.default.createElement(_kualiUi.Icon, { name: 'add' })
        ),
        _react2.default.createElement(
          _kualiUi.FlatButton,
          {
            onClick: function onClick() {
              return _this4.setState({ scale: scale - 0.1 });
            },
            disabled: scale <= 0.2,
            label: 'Zoom Out',
            labelStyle: { display: 'none' }
          },
          _react2.default.createElement(_kualiUi.Icon, { name: 'remove' })
        )
      ), _react2.default.createElement(
        'span',
        { key: 'download' },
        _react2.default.createElement(DownloadButton, { url: url, blob: blob, fileName: file.fileName })
      )];
    }
  }, {
    key: 'renderUnsupportedPreview',
    value: function renderUnsupportedPreview() {
      var _state4 = this.state,
          url = _state4.url,
          blob = _state4.blob;
      var file = this.props.file;

      return _react2.default.createElement(
        'div',
        null,
        'Unable to preview this attachment',
        _react2.default.createElement(DownloadButton, { url: url, blob: blob, fileName: file.fileName })
      );
    }
  }, {
    key: 'renderLoading',
    value: function renderLoading() {
      return _react2.default.createElement(
        'div',
        null,
        'Loading...'
      );
    }
  }]);

  return AttachmentPreview;
}(_react2.default.Component);

AttachmentPreview.propTypes = {
  file: _react2.default.PropTypes.object.isRequired,
  url: _react2.default.PropTypes.string.isRequired
};

exports.default = AttachmentPreview;