'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _pdfjsDist = require('pdfjs-dist');

var _pdfjsDist2 = _interopRequireDefault(_pdfjsDist);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2005-2017 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var ReactPdf = function (_React$Component) {
  _inherits(ReactPdf, _React$Component);

  function ReactPdf(props) {
    _classCallCheck(this, ReactPdf);

    var _this = _possibleConstructorReturn(this, (ReactPdf.__proto__ || Object.getPrototypeOf(ReactPdf)).call(this, props));

    _initialiseProps.call(_this);

    _this.state = {};
    _pdfjsDist2.default.workerSrc = props.pdfUrl + '/pdf.worker.js';
    return _this;
  }

  _createClass(ReactPdf, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      this._loadPDFDocument(this.props);
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(newProps) {
      if (newProps.file && newProps.file !== this.props.file) {
        this.setState({ page: null });
        this._loadPDFDocument(newProps);
      } else if (this.state.pdf && newProps.page && newProps.page !== this.props.page) {
        this.setState({ page: null });
        this.state.pdf.getPage(newProps.page).then(this._onPageComplete);
      }
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate(prevProps, prevState) {
      if (this.state.page !== prevState.page || this.props.scale !== prevProps.scale) {
        this._renderPdf();
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      return _react2.default.createElement(
        'div',
        { style: { overflow: 'auto' } },
        _react2.default.createElement('canvas', {
          ref: function ref(_ref) {
            _this2.pdfCanvasRef = _ref;
          }
        })
      );
    }
  }]);

  return ReactPdf;
}(_react2.default.Component);

ReactPdf.propTypes = {
  file: _react2.default.PropTypes.string,
  content: _react2.default.PropTypes.string,
  page: _react2.default.PropTypes.number,
  scale: _react2.default.PropTypes.number,
  onDocumentComplete: _react2.default.PropTypes.func,
  onPageComplete: _react2.default.PropTypes.func
};
ReactPdf.defaultProps = {
  page: 1,
  scale: 1.0
};

var _initialiseProps = function _initialiseProps() {
  var _this3 = this;

  this._loadPDFDocument = function (props) {
    if (props.file && typeof props.file === 'string') {
      _pdfjsDist2.default.getDocument(props.file).then(_this3._onDocumentComplete);
    } else {
      console.error('ReactPDF component only works with urls');
    }
  };

  this._onDocumentComplete = function (pdf) {
    _this3.setState({ pdf: pdf });
    if (_this3.props.onDocumentComplete && typeof _this3.props.onDocumentComplete === 'function') {
      _this3.props.onDocumentComplete(pdf.numPages);
    }
    pdf.getPage(_this3.props.page).then(_this3._onPageComplete);
  };

  this._onPageComplete = function (page) {
    _this3.setState({ page: page });

    if (_this3.props.onPageComplete && typeof _this3.props.onPageComplete === 'function') {
      _this3.props.onPageComplete(page.pageIndex + 1);
    }
  };

  this._renderPdf = function () {
    if (_this3.pdfCanvasRef && _this3.state.page) {
      var canvas = _this3.pdfCanvasRef;
      var context = canvas.getContext('2d');
      var scale = _this3.props.scale;
      var viewport = _this3.state.page.getViewport(scale);
      canvas.height = viewport.height;
      canvas.width = viewport.width;
      var renderContext = {
        canvasContext: context,
        viewport: viewport
      };
      _this3.state.page.render(renderContext);
    }
  };
};

exports.default = ReactPdf;