'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _icons = require('@kuali/kuali-ui/lib/icons');

var _icons2 = _interopRequireDefault(_icons);

var _lodash = require('lodash');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _kualiUi = require('@kuali/kuali-ui');

var _reactDropzone = require('react-dropzone');

var _reactDropzone2 = _interopRequireDefault(_reactDropzone);

var _Snackbars = require('react-md/lib/Snackbars');

var _Snackbars2 = _interopRequireDefault(_Snackbars);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2005-2017 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var style = {
  border: '1px dotted #999',
  borderRadius: 0,
  fontSize: 20,
  fontWeight: 'normal',
  textAlign: 'center',
  width: '100%',
  height: 142,
  position: 'relative',
  display: 'flex',
  alignItems: 'center',
  justifyContent: 'center',
  padding: '20px 40px'
};

var activeStyle = {
  backgroundColor: '#1ef'
};

var Dropzone = function (_Component) {
  _inherits(Dropzone, _Component);

  function Dropzone() {
    _classCallCheck(this, Dropzone);

    var _this = _possibleConstructorReturn(this, (Dropzone.__proto__ || Object.getPrototypeOf(Dropzone)).call(this));

    _this.onDrop = function (files) {
      files.forEach(function (file) {
        if (file) {
          if (file.size > (_this.props.maxFileSize || 30 * 1000 * 1000)) {
            _this.setState({
              errors: [].concat(_toConsumableArray(_this.state.errors), [file.name + ' exceeds the file size limit of 30mb'])
            });
          } else {
            _this.props.onChange({
              fileName: file.name,
              contentType: file.type,
              fileSize: file.size,
              newFileAttachmentFile: file
            });
          }
        }
      });
    };

    _this.clearErrors = function () {
      _this.setState({ errors: [] });
    };

    _this.state = {
      errors: []
    };
    return _this;
  }

  _createClass(Dropzone, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          details = _props.details,
          multiple = _props.multiple;


      return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
          _reactDropzone2.default,
          {
            style: style,
            activeStyle: activeStyle,
            disablePreview: true,
            multiple: multiple,
            onDrop: this.onDrop
          },
          _react2.default.createElement(_icons2.default, { name: 'attach_file' }),
          _react2.default.createElement(
            'span',
            { style: { margin: '0 30px 0 30px' } },
            details.dropzoneText
          ),
          _react2.default.createElement(
            _kualiUi.RaisedButton,
            { label: details.buttonText },
            _react2.default.createElement(_icons2.default, { name: 'add', variant: 'success' })
          )
        ),
        !(0, _lodash.isEmpty)(this.state.errors) && _react2.default.createElement(_Snackbars2.default, {
          toasts: [{ text: this.state.errors }],
          onDismiss: this.clearErrors,
          style: { backgroundColor: 'red', zIndex: 999999 }
        })
      );
    }
  }]);

  return Dropzone;
}(_react.Component);

exports.default = Dropzone;


Dropzone.propTypes = {
  onChange: _propTypes2.default.func.isRequired,
  details: _propTypes2.default.object.isRequired,
  multiple: _propTypes2.default.bool.isRequired
};

Dropzone.defaultProps = {
  multiple: false
};