'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.default = function (pdfUrl) {
  var _class, _temp;

  return _temp = _class = function (_Component) {
    _inherits(FileAttachmentEdit, _Component);

    function FileAttachmentEdit(props) {
      _classCallCheck(this, FileAttachmentEdit);

      var _this = _possibleConstructorReturn(this, (FileAttachmentEdit.__proto__ || Object.getPrototypeOf(FileAttachmentEdit)).call(this, props));

      _this.onChange = function (value) {
        _this.setState({ replace: false });
        _this.props.onChange(value);
      };

      _this.renderViewControl = function () {
        var preview = false;
        var _this$props = _this.props,
            value = _this$props.value,
            readOnly = _this$props.readOnly;


        if (_this.state.preview) {
          preview = _this.renderPreview();
        }

        return _react2.default.createElement(
          'div',
          { style: { border: '1px solid #CCC', padding: 15 } },
          _react2.default.createElement(
            'div',
            { style: { marginBottom: 20 } },
            value.fileName
          ),
          _react2.default.createElement(
            'div',
            { style: { display: 'flex' } },
            _this.viewAttachment(),
            !readOnly && _react2.default.createElement(
              'div',
              { className: 'replace' },
              _react2.default.createElement(
                _kualiUi.RaisedButton,
                {
                  label: 'Replace',
                  onClick: function onClick() {
                    return _this.setState({ replace: true });
                  }
                },
                _react2.default.createElement(_kualiUi.Icon, { name: 'sync', variant: 'info' })
              )
            )
          ),
          preview
        );
      };

      _this.viewAttachment = function () {
        return _react2.default.createElement(
          'div',
          { className: 'view-attachment' },
          _react2.default.createElement(
            _kualiUi.RaisedButton,
            {
              style: { marginRight: 10 },
              onClick: function onClick() {
                return _this.setState({ preview: true });
              },
              label: 'View Attachment'
            },
            _react2.default.createElement(_kualiUi.Icon, { name: 'remove_red_eye', variant: 'info' })
          )
        );
      };

      _this.renderPreview = function () {
        var value = _this.props.value;

        return _react2.default.createElement(_attachmentPreview2.default, {
          file: value,
          url: value.url || URL.createObjectURL(value.newFileAttachmentFile) // eslint-disable-line no-undef
          , pdfUrl: pdfUrl,
          onClose: function onClose() {
            return _this.setState({ preview: false });
          }
        });
      };

      _this.state = { replace: false, preview: false };
      return _this;
    }

    _createClass(FileAttachmentEdit, [{
      key: 'render',
      value: function render() {
        var _props = this.props,
            details = _props.details,
            value = _props.value;

        if (value && value.fileName && !this.state.replace) {
          return this.renderViewControl();
        } else {
          return _react2.default.createElement(_dropzone2.default, {
            onChange: this.onChange,
            details: details,
            maxFileSize: this.props.maxFileSize,
            multiple: false
          });
        }
      }
    }]);

    return FileAttachmentEdit;
  }(_react.Component), _class.displayName = 'FileAttachmentEdit', _class.propTypes = {
    details: _propTypes2.default.object.isRequired,
    onChange: _propTypes2.default.func.isRequired,
    value: _propTypes2.default.object,
    context: _propTypes2.default.object.isRequired,
    maxFileSize: _propTypes2.default.number.isRequired
  }, _temp;
};

var _attachmentPreview = require('./attachment-preview');

var _attachmentPreview2 = _interopRequireDefault(_attachmentPreview);

var _dropzone = require('./dropzone');

var _dropzone2 = _interopRequireDefault(_dropzone);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _kualiUi = require('@kuali/kuali-ui');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2005-2017 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */