'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.default = view;

var _attachmentPreview = require('./attachment-preview');

var _attachmentPreview2 = _interopRequireDefault(_attachmentPreview);

var _kualiUi = require('@kuali/kuali-ui');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2005-2017 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

function view(pdfUrl) {
  var _class, _temp;

  return _temp = _class = function (_React$Component) {
    _inherits(FileAttachmentView, _React$Component);

    function FileAttachmentView(props) {
      _classCallCheck(this, FileAttachmentView);

      var _this = _possibleConstructorReturn(this, (FileAttachmentView.__proto__ || Object.getPrototypeOf(FileAttachmentView)).call(this, props));

      _this.preview = function (e) {
        e.stopPropagation();
        _this.setState({ preview: true });
      };

      _this.state = { preview: false };
      return _this;
    }

    _createClass(FileAttachmentView, [{
      key: 'render',
      value: function render() {
        var value = this.props.value;

        var preview = false;
        if (this.state.preview) {
          preview = this.renderPreview();
        }
        return _react2.default.createElement(
          'div',
          null,
          _react2.default.createElement(_kualiUi.FlatButton, {
            style: { textTransform: 'uppercase' },
            onClick: this.preview,
            label: value.fileName
          }),
          preview
        );
      }
    }, {
      key: 'renderPreview',
      value: function renderPreview() {
        var _this2 = this;

        var value = this.props.value;

        return _react2.default.createElement(_attachmentPreview2.default, {
          file: value,
          url: value.url,
          pdfUrl: pdfUrl,
          onClose: function onClose() {
            return _this2.setState({ preview: false });
          }
        });
      }
    }]);

    return FileAttachmentView;
  }(_react2.default.Component), _class.displayName = 'FileAttachmentView', _class.propTypes = {
    details: _propTypes2.default.object.isRequired,
    value: _propTypes2.default.object
  }, _temp;
}