'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _scenario = require('./scenario');

var _scenario2 = _interopRequireDefault(_scenario);

var _kualiUi = require('@kuali/kuali-ui');

var _config = require('./config.css');

var _config2 = _interopRequireDefault(_config);

var _lodash = require('lodash');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var Config = function (_Component) {
  _inherits(Config, _Component);

  function Config(props) {
    _classCallCheck(this, Config);

    var _this = _possibleConstructorReturn(this, (Config.__proto__ || Object.getPrototypeOf(Config)).call(this, props));

    _this.handleReferenceGadgetChange = function (newValue) {
      _this.setState({
        referenceGadget: newValue,
        values: {}
      });
      _this.props.onChange(_extends({}, _this.props.value, { data: _this.state }));
    };

    _this.handleListChange = function (optionKey, newItems) {
      var state = (0, _lodash.cloneDeep)(_this.state);
      state.values[optionKey] = newItems;
      _this.setState(state);
      _this.props.onChange(_extends({}, _this.props.value, { data: state }));
    };

    _this.findGadget = function (formKey) {
      var allGadgetsArray = (0, _lodash.values)(_this.props.gadgets);
      return allGadgetsArray.find(function (gadget) {
        return gadget.formKey === formKey;
      });
    };

    _this.gadgetsOptions = function (gadgetFormKey) {
      var x = (0, _lodash.get)(_this.findGadget(gadgetFormKey), 'details.options', []);

      return x;
    };

    _this.otherGadgetsThatHaveOptions = function () {
      var allGadgetsArray = (0, _lodash.values)(_this.props.gadgets);
      return allGadgetsArray.filter(function (gadget) {
        return (0, _lodash.get)(gadget, 'details.options', []).length > 0;
      });
    };

    _this.state = (0, _lodash.get)(props, 'value.data', {
      referenceGadget: undefined,
      values: {}
    });
    return _this;
  }

  _createClass(Config, [{
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _state = this.state,
          referenceGadget = _state.referenceGadget,
          values = _state.values;

      return _react2.default.createElement(
        'div',
        { className: _config2.default.container },
        _react2.default.createElement(
          'h3',
          null,
          'Options:'
        ),
        _react2.default.createElement(
          'div',
          null,
          'When',
          _react2.default.createElement(_kualiUi.SelectField, {
            className: _config2.default.dropdown,
            id: 'referenceGadget',
            menuItems: this.otherGadgetsThatHaveOptions().map(function (gadget) {
              return {
                label: gadget.label,
                value: gadget.formKey
              };
            }),
            onChange: this.handleReferenceGadgetChange,
            placeholder: '-- Choose a Gadget --',
            position: _kualiUi.SelectField.Positions.BELOW,
            value: referenceGadget
          })
        ),
        this.gadgetsOptions(referenceGadget).map(function (option) {
          return _react2.default.createElement(_scenario2.default, {
            onListChange: _this2.handleListChange,
            key: option.key,
            option: {
              label: option.lbl,
              value: option.key
            },
            values: values[option.key]
          });
        })
      );
    }
  }]);

  return Config;
}(_react.Component);

Config.propTypes = {
  gadgets: _propTypes2.default.object,
  onChange: _propTypes2.default.func.isRequired,
  value: _propTypes2.default.shape({
    placeholder: _propTypes2.default.string
  }).isRequired
};
exports.default = Config;