'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _kualiUi = require('@kuali/kuali-ui');

var _edit = require('./edit.css');

var _edit2 = _interopRequireDefault(_edit);

var _lodash = require('lodash');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function Edit(_ref) {
  var details = _ref.details,
      dependent = _ref.dependent,
      formKey = _ref.formKey,
      _onChange = _ref.onChange,
      value = _ref.value;

  var referenceGadget = (0, _lodash.get)(details, 'data.referenceGadget');
  var dependentData = (0, _lodash.get)(dependent, 'data', {});
  var referenceValue = dependentData[referenceGadget];

  var options = [];
  if (referenceValue) {
    var possibleValuesMap = (0, _lodash.get)(details, 'data.values', {});
    options = (0, _lodash.defaultTo)(possibleValuesMap[referenceValue], []);
  }

  var disabled = (0, _lodash.get)(options, 'length', 0) === 0;
  if (value !== undefined && disabled) {
    setTimeout(function () {
      _onChange(undefined);
    }, 0);
  }

  return _react2.default.createElement(_kualiUi.SelectField, {
    id: formKey,
    className: disabled ? _edit2.default.disabled : '',
    disabled: disabled,
    onChange: function onChange(val) {
      return _onChange(val);
    },
    fullWidth: true,
    value: value,
    menuItems: options,
    itemLabel: 'lbl',
    itemValue: 'key'
  });
} /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
   * You may use and modify this code under the terms of the Kuali, Inc.
   * Pre-Release License Agreement. You may not distribute it.
   *
   * You should have received a copy of the Kuali, Inc. Pre-Release License
   * Agreement with this file. If not, please write to license@kuali.co.
   */

exports.default = Edit;


Edit.displayName = 'FilteredDropdownEdit';

Edit.propTypes = {
  dependent: _propTypes2.default.object,
  details: _propTypes2.default.shape({
    options: _propTypes2.default.arrayOf(_propTypes2.default.shape({
      key: _propTypes2.default.string,
      lbl: _propTypes2.default.string
    }))
  }).isRequired,
  formKey: _propTypes2.default.string.isRequired,
  onChange: _propTypes2.default.func.isRequired,
  value: _propTypes2.default.string
};