'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = View;

var _defaultTo = require('lodash/defaultTo');

var _defaultTo2 = _interopRequireDefault(_defaultTo);

var _lodash = require('lodash');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

function View(_ref) {
  var details = _ref.details,
      dependent = _ref.dependent,
      value = _ref.value;

  var referenceGadget = (0, _lodash.get)(details, 'data.referenceGadget');
  var dependentData = (0, _lodash.get)(dependent, 'data', {});
  var referenceValue = dependentData[referenceGadget];

  if (!referenceValue) {
    return _react2.default.createElement('div', null);
  }
  var possibleValuesMap = (0, _lodash.get)(details, 'data.values', {});
  var matchingOption = (0, _defaultTo2.default)(possibleValuesMap[referenceValue], []).find(function (option) {
    return option.key === value;
  });

  if (!matchingOption) {
    return _react2.default.createElement('div', null);
  }

  return _react2.default.createElement(
    'div',
    null,
    matchingOption.lbl
  );
}

View.displayName = 'FilteredDropdownView';

View.defaultProps = {
  value: ''
};

View.propTypes = {
  dependent: _propTypes2.default.object,
  details: _propTypes2.default.object,
  value: _propTypes2.default.string
};