'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _style = require('./style.css');

var _style2 = _interopRequireDefault(_style);

var _lodash = require('lodash');

var _kualiUi = require('@kuali/kuali-ui');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2005-2017 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var ListConfig = function (_Component) {
  _inherits(ListConfig, _Component);

  function ListConfig() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, ListConfig);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = ListConfig.__proto__ || Object.getPrototypeOf(ListConfig)).call.apply(_ref, [this].concat(args))), _this), _this.typeChanged = function (type) {
      _this.props.onChange(_extends({}, _this.props.value, { type: type }));
    }, _this.fieldChanged = function (summaryFields) {
      var defaultHeaders = (0, _lodash.compact)(summaryFields.split(','));
      _this.props.onChange(_extends({}, _this.props.value, { defaultHeaders: defaultHeaders }));
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(ListConfig, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          gadgets = _props.gadgets,
          id = _props.id,
          value = _props.value;

      var thisGadgetInstance = gadgets[id];
      var childFields = (0, _lodash.get)(thisGadgetInstance, 'children', []).map(function (child) {
        return {
          label: child.label,
          value: child.formKey
        };
      });

      return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
          'h3',
          null,
          'Settings'
        ),
        _react2.default.createElement(
          _kualiUi.Form,
          { showGrid: true },
          _react2.default.createElement(
            _kualiUi.FieldGroup,
            null,
            _react2.default.createElement(
              _kualiUi.FieldCell,
              null,
              _react2.default.createElement(
                _kualiUi.Label,
                { htmlFor: 'listType' },
                'Edit mode'
              ),
              _react2.default.createElement(_kualiUi.SelectionControlGroup, {
                controls: [{
                  label: 'Inline',
                  value: 'inline'
                }, {
                  label: 'Dialog',
                  value: 'dialog'
                }],
                controlClassName: _style2.default['listType-radio'],
                id: 'listType',
                inline: true,
                name: 'listType',
                onChange: this.typeChanged,
                type: 'radio',
                value: (0, _lodash.get)(value, 'type')
              })
            )
          ),
          _react2.default.createElement(
            _kualiUi.FieldGroup,
            null,
            _react2.default.createElement(
              _kualiUi.FieldCell,
              null,
              _react2.default.createElement(
                _kualiUi.Label,
                { htmlFor: 'tableFields' },
                'Default Columns'
              ),
              _react2.default.createElement(_kualiUi.SelectionControlGroup, {
                controls: childFields,
                id: 'tableFields',
                name: 'tableFields',
                onChange: this.fieldChanged,
                type: 'checkbox',
                value: (0, _lodash.get)(value, 'defaultHeaders', childFields.map(function (field) {
                  return field.value;
                })).join(',')
              })
            )
          )
        )
      );
    }
  }]);

  return ListConfig;
}(_react.Component);

ListConfig.displayName = 'ListConfig';
ListConfig.defaultProps = {
  gadgets: []
};
ListConfig.propTypes = {
  onChange: _propTypes2.default.func.isRequired,
  value: _propTypes2.default.object.isRequired
};
exports.default = ListConfig;