'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _dialog = require('./dialog.css');

var _dialog2 = _interopRequireDefault(_dialog);

var _lodash = require('lodash');

var _kualiUi = require('@kuali/kuali-ui');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var ItemDialog = function (_React$Component) {
  _inherits(ItemDialog, _React$Component);

  function ItemDialog(props) {
    _classCallCheck(this, ItemDialog);

    var _this = _possibleConstructorReturn(this, (ItemDialog.__proto__ || Object.getPrototypeOf(ItemDialog)).call(this, props));

    _this.scrollListener = (0, _lodash.throttle)(function () {
      if (!_this.state.bottomOfDialogSeen) {
        var _this$dialogContainer = _this.dialogContainer,
            scrollTop = _this$dialogContainer.scrollTop,
            clientHeight = _this$dialogContainer.clientHeight,
            scrollHeight = _this$dialogContainer.scrollHeight;
        // 50px is meant to show at least some of the smallest possible field
        // keyboard navigation won't always scroll to the absolute bottom of the config

        if (Math.ceil(scrollTop) + Math.ceil(clientHeight) >= Math.floor(scrollHeight) - 50) {
          _this.setState({ bottomOfDialogSeen: true });
        }
      }
    }, 100);

    _this.handleScrollListener = function (morePrompt) {
      if (morePrompt) {
        _this.dialogContainer = morePrompt.parentNode;
        _this.dialogContainer.addEventListener('scroll', _this.scrollListener);
        _this.scrollListener();
      } else {
        _this.dialogContainer.removeEventListener('scroll', _this.scrollListener);
      }
    };

    _this.handleSave = function (_) {
      _this.props.onSave(_this.state.item);
    };

    _this.handleClose = function () {
      if (_this.initialItem) {
        _this.props.onChange(_this.initialItem);
      }
      _this.props.onClose();
    };

    _this.handleChange = function (field, value) {
      var item = _extends({}, _this.state.item, _defineProperty({}, field, value));
      _this.setState({ item: item });
      _this.props.onChange(item);
    };

    _this.dialogButtons = function () {
      if (_this.props.readOnly) {
        return null;
      }

      return [_react2.default.createElement(
        _kualiUi.RaisedButton,
        { label: 'Cancel', onClick: _this.handleClose, variant: 'plain' },
        _react2.default.createElement(_kualiUi.Icon, { variant: 'warning', name: 'close' })
      ), _react2.default.createElement(
        _kualiUi.RaisedButton,
        {
          className: _this.state.bottomOfDialogSeen ? '' : _dialog2.default.disabledButton,
          label: 'Done',
          onClick: _this.state.bottomOfDialogSeen ? _this.handleSave : _lodash.noop,
          tooltipLabel: _this.state.bottomOfDialogSeen ? '' : 'Please view the remainder of this form by scrolling downward',
          tooltipPosition: 'left',
          variant: 'plain'
        },
        _react2.default.createElement(_kualiUi.Icon, {
          variant: _this.state.bottomOfDialogSeen ? 'success' : 'default',
          name: 'done'
        })
      )];
    };

    _this.dialogContent = function () {
      var _this$props = _this.props,
          readOnly = _this$props.readOnly,
          renderRow = _this$props.renderRow,
          headers = _this$props.headers,
          itemIndex = _this$props.itemIndex;
      var item = _this.state.item;


      var templates = headers.map(function (header) {
        return header.template;
      });
      var newRow = renderRow(readOnly ? 'view' : 'edit', templates, item, _this.handleChange, itemIndex);
      return _react2.default.Children.map(newRow, function (child) {
        return _react2.default.cloneElement(child, { className: _dialog2.default['dialog-gadget'] });
      });
    };

    _this.state = {
      item: props.item || {},
      bottomOfDialogSeen: false
    };
    _this.initialItem = (0, _lodash.cloneDeep)(props.item);
    return _this;
  }

  _createClass(ItemDialog, [{
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      if (!(0, _lodash.isEqual)(this.props.item, nextProps.item)) {
        this.setState({
          item: nextProps.item || {}
        });
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var visible = this.props.visible;

      return _react2.default.createElement(
        _kualiUi.Dialog,
        {
          actions: this.dialogButtons(),
          contentClassName: _dialog2.default.dialog,
          id: 'addEditItemDialog',
          lastChild: true,
          modal: true,
          onHide: this.handleClose,
          title: this.title,
          visible: visible,
          focusOnMount: true
        },
        _react2.default.createElement(
          'div',
          {
            className: _dialog2.default.morePrompt,
            ref: this.handleScrollListener,
            style: { display: this.state.bottomOfDialogSeen ? 'none' : 'block' }
          },
          _react2.default.createElement(_kualiUi.Icon, { name: 'chevron_left', className: _dialog2.default.moreIcon }),
          _react2.default.createElement(
            'div',
            null,
            'MORE'
          )
        ),
        this.dialogContent()
      );
    }
  }, {
    key: 'title',
    get: function get() {
      var _props = this.props,
          readOnly = _props.readOnly,
          item = _props.item;

      if (readOnly) {
        return 'Details';
      } else if (!item) {
        // Our parent did not provide us with an item, its new
        return 'Add';
      } else {
        return 'Edit';
      }
    }

    // handlers

  }]);

  return ItemDialog;
}(_react2.default.Component);

ItemDialog.displayName = 'ItemDialog';
ItemDialog.propTypes = {
  readOnly: _propTypes2.default.bool,
  headers: _propTypes2.default.array,
  visible: _propTypes2.default.bool,
  item: _propTypes2.default.object,
  onClose: _propTypes2.default.func,
  onSave: _propTypes2.default.func,
  renderRow: _propTypes2.default.func.isRequired,
  itemIndex: _propTypes2.default.number
};
ItemDialog.defaultProps = {
  headers: [],
  onChange: function onChange() {}
};
exports.default = ItemDialog;