'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                   * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                   * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                   *
                                                                                                                                                                                                                                                                   * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                   * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                   */

exports.customGadgetRenderer = customGadgetRenderer;

var _dialogPrintView = require('./dialog-print-view');

var _dialogPrintView2 = _interopRequireDefault(_dialogPrintView);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _gadgetRenderer = require('@kuali/formbot/dist/lib/gadget-renderer.css');

var _gadgetRenderer2 = _interopRequireDefault(_gadgetRenderer);

var _shortid = require('shortid');

var _shortid2 = _interopRequireDefault(_shortid);

var _table = require('./table.js');

var _table2 = _interopRequireDefault(_table);

var _lodash = require('lodash');

var _contextHelper = require('./context-helper');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function renderRow(Formbot, context, listFormKey, mode, rowTemplates, data, onChange, rowIndex) {
  var additionalContext = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : {};

  // wrap the children in a section so formbot knows what to do with them
  var template = {
    type: 'Section',
    id: 'root',
    children: rowTemplates
  };

  var row = Formbot.render(mode, template, [], data, {
    onChange: onChange,
    context: _extends({}, context, {
      list: true,
      listContext: _extends({
        listFormKey: listFormKey,
        listPath: buildListPath(context, listFormKey, rowIndex),
        rowId: (0, _lodash.get)(data, 'id')
      }, additionalContext)
    })
  });

  // strip the root div
  return (0, _lodash.get)(row, ['props', 'children', 'props', 'children'], []);
}

function buildListPath(context, listFormKey, rowIndex) {
  var parentPath = (0, _lodash.get)(context, 'listContext.listPath', false);
  if (parentPath) {
    return parentPath + '.' + listFormKey + '.' + rowIndex;
  } else {
    return listFormKey + '.' + rowIndex;
  }
}

function createRow(defaultValues) {
  return _extends({}, defaultValues, {
    id: _shortid2.default.generate()
  });
}

function extractValuesFromChildren(Formbot, template, mode, options) {
  var defaultValues = {};
  var headers = options.childrenTemplates.map(function (template) {
    var formKey = template.formKey,
        label = template.label;

    var childGadget = Formbot.getGadget(template.type);

    // ewww side effect
    defaultValues[formKey] = childGadget.defaultValue;

    return {
      key: formKey,
      label: label,
      template: template
    };
  });

  return { defaultValues: defaultValues, headers: headers };
}

function customGadgetRenderer(Formbot, mode, template, options) {
  if (options.value && (0, _lodash.isArray)(options.value)) {
    options.value = options.value.map(function (row) {
      return row.id ? row : createRow(row);
    });
  }

  var context = options.context,
      onChange = options.onChange,
      shouldShow = options.shouldShow;

  var _ref = context || {},
      printableView = _ref.printableView;

  if (!shouldShow) {
    return null;
  }

  var _extractValuesFromChi = extractValuesFromChildren(Formbot, template, mode, options),
      defaultChildValues = _extractValuesFromChi.defaultValues,
      headers = _extractValuesFromChi.headers;

  var value = options.value || [];

  var hiddenColumns = printableView ? [] : (0, _contextHelper.getHiddenColumns)(template.formKey, context);
  if (hiddenColumns.length === 0 && !printableView) {
    var allHeaderKeys = headers.map(function (header) {
      return header.key;
    });
    var defaultHeaders = (0, _lodash.get)(template, 'details.defaultHeaders', []);
    if (defaultHeaders.length > 0) {
      hiddenColumns = (0, _lodash.xor)(allHeaderKeys, defaultHeaders);
    }
  }

  var handleColumnVisibilityChange = (0, _contextHelper.getHiddenColumnsUpdateHandler)(template.formKey, context);

  var decorators = Formbot.getDecorators({ type: template.type, mode: mode });
  var gadgetDef = Formbot.getGadget(template.type);
  var props = {
    context: context,
    template: template,
    mode: mode,
    formKey: template.formKey,
    id: template.id
  };

  var createComponent = function createComponent(_props) {
    var decorate = function decorate(items, createComponent) {
      return decorators.length ? Formbot.decorate(decorators, items, _props, gadgetDef, createComponent) : items;
    };

    var className = _gadgetRenderer2.default['size-' + (template.fieldSize || 'large')];
    var headingParts = Formbot.buildHeadingParts(Formbot, _props.mode, template);
    var showColumnVisibilityControl = (0, _lodash.get)(template, ['details', 'columnVisibilityControl'], true);
    if (printableView) {
      return _react2.default.createElement(_dialogPrintView2.default, {
        key: template.id,
        rows: value,
        template: template,
        headingParts: headingParts,
        renderRow: (0, _lodash.partial)(renderRow, Formbot, context, template.formKey, 'view', template.children)
      });
    } else {
      return _react2.default.createElement(_table2.default, {
        className: className,
        decorate: decorate,
        renderRow: (0, _lodash.partial)(renderRow, Formbot, context, template.formKey),
        addId: createRow,
        createNewRow: (0, _lodash.partial)(createRow, defaultChildValues),
        key: template.id,
        headers: headers,
        initialHiddenColumns: hiddenColumns,
        listType: (0, _lodash.get)(template, 'details.type', 'inline'),
        mode: _props.mode,
        onColumnVisibilityChange: function onColumnVisibilityChange(hiddenColumns) {
          handleColumnVisibilityChange(template.formKey, hiddenColumns);
        },
        onChange: onChange,
        rows: value,
        showColumnVisibilityControl: showColumnVisibilityControl,
        template: template,
        formbotOptions: Formbot.options,
        headingParts: headingParts
      });
    }
  };

  var component = createComponent(props);
  return decorators.length ? Formbot.decorate(decorators, { component: component }, props, gadgetDef, createComponent).component : component;
}